/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.UndoCommandFlushReason;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/command/impl/UndoDumpUnit;", "", "id", "", "command", "actions", "", "Lcom/intellij/openapi/command/undo/UndoableAction;", "isGlobal", "", "isTransparent", "isTemporary", "isValid", "confirmationPolicy", "Lcom/intellij/openapi/command/UndoConfirmationPolicy;", "affectedDocuments", "Lcom/intellij/openapi/command/undo/DocumentReference;", "additionalAffectedDocuments", "flushReason", "Lcom/intellij/openapi/command/impl/UndoCommandFlushReason;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;ZZZZLcom/intellij/openapi/command/UndoConfirmationPolicy;Ljava/util/Collection;Ljava/util/Collection;Lcom/intellij/openapi/command/impl/UndoCommandFlushReason;)V", "toString", "printDocs", "docs", "Companion", "intellij.platform.ide.impl"})
public final class UndoDumpUnit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String command;
    @NotNull
    private final Collection<UndoableAction> actions;
    private final boolean isGlobal;
    private final boolean isTransparent;
    private final boolean isTemporary;
    private final boolean isValid;
    @NotNull
    private final UndoConfirmationPolicy confirmationPolicy;
    @NotNull
    private final Collection<DocumentReference> affectedDocuments;
    @NotNull
    private final Collection<DocumentReference> additionalAffectedDocuments;
    @Nullable
    private final UndoCommandFlushReason flushReason;

    public UndoDumpUnit(@NotNull String id2, @NotNull String command, @NotNull Collection<? extends UndoableAction> actions, boolean isGlobal, boolean isTransparent, boolean isTemporary, boolean isValid, @NotNull UndoConfirmationPolicy confirmationPolicy, @NotNull Collection<? extends DocumentReference> affectedDocuments, @NotNull Collection<? extends DocumentReference> additionalAffectedDocuments, @Nullable UndoCommandFlushReason flushReason) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)confirmationPolicy, (String)"confirmationPolicy");
        Intrinsics.checkNotNullParameter(affectedDocuments, (String)"affectedDocuments");
        Intrinsics.checkNotNullParameter(additionalAffectedDocuments, (String)"additionalAffectedDocuments");
        this.id = id2;
        this.command = command;
        this.actions = actions;
        this.isGlobal = isGlobal;
        this.isTransparent = isTransparent;
        this.isTemporary = isTemporary;
        this.isValid = isValid;
        this.confirmationPolicy = confirmationPolicy;
        this.affectedDocuments = affectedDocuments;
        this.additionalAffectedDocuments = additionalAffectedDocuments;
        this.flushReason = flushReason;
    }

    @NotNull
    public String toString() {
        String actionsStr = CollectionsKt.joinToString$default((Iterable)this.actions, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, UndoDumpUnit::toString$lambda$0, (int)24, null);
        String isGlobalStr = this.isGlobal ? " global" : "";
        String isTransparentStr = this.isTransparent ? " transparent" : "";
        String isTemporaryStr = this.isTemporary ? " temp" : "";
        String isValidStr = !this.isValid ? " invalid" : "";
        String confirmationPolicyStr = this.confirmationPolicy != UndoConfirmationPolicy.DEFAULT ? " " + this.confirmationPolicy : "";
        String docs = this.affectedDocuments.size() > 1 ? " affected: " + this.printDocs(this.affectedDocuments) : "";
        String addDocs = this.additionalAffectedDocuments.size() > 1 ? " additional: " + this.printDocs(this.additionalAffectedDocuments) : "";
        return "{" + this.command + " " + this.id + isGlobalStr + isTransparentStr + isTemporaryStr + isValidStr + " with " + this.actions.size() + " " + (this.actions.size() == 1 ? "action" : "actions") + " " + this.flushReason + ": " + actionsStr + confirmationPolicyStr + docs + addDocs + "}";
    }

    private final String printDocs(Collection<? extends DocumentReference> docs) {
        return CollectionsKt.joinToString$default((Iterable)docs, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
    }

    private static final CharSequence toString$lambda$0(UndoableAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        return "(" + action2 + ")";
    }

    @JvmStatic
    @NotNull
    public static final UndoDumpUnit fromGroup(@NotNull UndoableGroup group2) {
        return Companion.fromGroup(group2);
    }

    @JvmStatic
    @NotNull
    public static final UndoDumpUnit fromMerger(@NotNull CommandMerger merger) {
        return Companion.fromMerger(merger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/command/impl/UndoDumpUnit$Companion;", "", "<init>", "()V", "fromGroup", "Lcom/intellij/openapi/command/impl/UndoDumpUnit;", "group", "Lcom/intellij/openapi/command/impl/UndoableGroup;", "fromMerger", "merger", "Lcom/intellij/openapi/command/impl/CommandMerger;", "command", "", "commandName", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UndoDumpUnit fromGroup(@NotNull UndoableGroup group2) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            String string = "@" + Integer.toHexString(System.identityHashCode(group2));
            String string2 = this.command(group2.getCommandName());
            Collection collection = new ArrayList(group2.getActions());
            boolean bl = group2.isGlobal();
            boolean bl2 = group2.isTransparent();
            boolean bl3 = group2.isTemporary();
            boolean bl4 = group2.isValid();
            UndoConfirmationPolicy undoConfirmationPolicy = group2.getConfirmationPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)undoConfirmationPolicy, (String)"getConfirmationPolicy(...)");
            Collection<DocumentReference> collection2 = group2.getAffectedDocuments();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getAffectedDocuments(...)");
            return new UndoDumpUnit(string, string2, collection, bl, bl2, bl3, bl4, undoConfirmationPolicy, collection2, CollectionsKt.emptyList(), group2.getFlushReason());
        }

        @JvmStatic
        @NotNull
        public final UndoDumpUnit fromMerger(@NotNull CommandMerger merger) {
            Intrinsics.checkNotNullParameter((Object)merger, (String)"merger");
            String string = this.command(merger.getCommandName());
            Collection collection = new ArrayList((Collection)merger.getCurrentActions());
            boolean bl = merger.isGlobal();
            boolean bl2 = merger.isTransparent();
            boolean bl3 = merger.isTransparent();
            boolean bl4 = merger.isValid();
            UndoConfirmationPolicy undoConfirmationPolicy = merger.getUndoConfirmationPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)undoConfirmationPolicy, (String)"getUndoConfirmationPolicy(...)");
            return new UndoDumpUnit("", string, collection, bl, bl2, bl3, bl4, undoConfirmationPolicy, new ArrayList(merger.getAllAffectedDocuments()), new ArrayList(merger.getAdditionalAffectedDocuments()), null);
        }

        private final String command(String commandName) {
            return commandName == null ? "NULL" : (((CharSequence)commandName).length() == 0 ? "EMPTY" : "'" + commandName + "'");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

