/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.MockEditorChangeAction;
import com.intellij.openapi.command.impl.MockGlobalUndoableAction;
import com.intellij.openapi.command.impl.MockUndoableAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoableAction;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public enum UndoableActionType {
    START_MARK,
    FINISH_MARK,
    MENTION_ONLY,
    EDITOR_CHANGE,
    NON_UNDOABLE,
    GLOBAL,
    OTHER;


    @NotNull
    public static UndoableAction getAction(@NotNull String actionType, @Nullable Collection<DocumentReference> docRefs, boolean isGlobal) {
        if (actionType == null) {
            UndoableActionType.$$$reportNull$$$0(0);
        }
        if (docRefs == null) {
            return new MockUndoableAction(docRefs, isGlobal);
        }
        UndoableActionType type = UndoableActionType.valueOf(actionType);
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new StartMarkAction(UndoableActionType.first(docRefs), "", isGlobal);
            case 1 -> new FinishMarkAction(UndoableActionType.first(docRefs), isGlobal);
            case 2 -> new MentionOnlyUndoableAction(docRefs.toArray(DocumentReference.EMPTY_ARRAY));
            case 3 -> new MockEditorChangeAction(UndoableActionType.first(docRefs));
            case 4 -> new NonUndoableAction(UndoableActionType.first(docRefs), isGlobal);
            case 5 -> new MockGlobalUndoableAction(docRefs);
            case 6 -> new MockUndoableAction(docRefs, isGlobal);
        };
    }

    @NotNull
    static UndoableActionType forAction(@NotNull UndoableAction action2) {
        if (action2 == null) {
            UndoableActionType.$$$reportNull$$$0(1);
        }
        if (action2 instanceof StartMarkAction) {
            UndoableActionType undoableActionType = START_MARK;
            if (undoableActionType == null) {
                UndoableActionType.$$$reportNull$$$0(2);
            }
            return undoableActionType;
        }
        if (action2 instanceof FinishMarkAction) {
            UndoableActionType undoableActionType = FINISH_MARK;
            if (undoableActionType == null) {
                UndoableActionType.$$$reportNull$$$0(3);
            }
            return undoableActionType;
        }
        if (action2 instanceof MentionOnlyUndoableAction) {
            UndoableActionType undoableActionType = MENTION_ONLY;
            if (undoableActionType == null) {
                UndoableActionType.$$$reportNull$$$0(4);
            }
            return undoableActionType;
        }
        if (action2 instanceof EditorChangeAction) {
            UndoableActionType undoableActionType = EDITOR_CHANGE;
            if (undoableActionType == null) {
                UndoableActionType.$$$reportNull$$$0(5);
            }
            return undoableActionType;
        }
        if (action2 instanceof NonUndoableAction) {
            UndoableActionType undoableActionType = NON_UNDOABLE;
            if (undoableActionType == null) {
                UndoableActionType.$$$reportNull$$$0(6);
            }
            return undoableActionType;
        }
        if (action2 instanceof GlobalUndoableAction) {
            UndoableActionType undoableActionType = GLOBAL;
            if (undoableActionType == null) {
                UndoableActionType.$$$reportNull$$$0(7);
            }
            return undoableActionType;
        }
        UndoableActionType undoableActionType = OTHER;
        if (undoableActionType == null) {
            UndoableActionType.$$$reportNull$$$0(8);
        }
        return undoableActionType;
    }

    @NotNull
    private static <T> T first(@NotNull Collection<T> collection) {
        if (collection == null) {
            UndoableActionType.$$$reportNull$$$0(9);
        }
        Object t = collection.stream().iterator().next();
        if (t == null) {
            UndoableActionType.$$$reportNull$$$0(10);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoableActionType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoableActionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }
}

