/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

final class AddBomAction
extends AnAction
implements DumbAware {
    AddBomAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddBomAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            AddBomAction.$$$reportNull$$$0(1);
        }
        boolean enabled2 = (file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && file2.getBOM() == null && CharsetToolkit.getPossibleBom((Charset)file2.getCharset()) != null;
        e.getPresentation().setEnabled(enabled2);
        e.getPresentation().setVisible(enabled2 || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
        e.getPresentation().setDescription(IdeBundle.messagePointer((String)"add.byte.order.mark.to", (Object[])new Object[]{enabled2 ? file2.getName() : null}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            AddBomAction.$$$reportNull$$$0(2);
        }
        if ((file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) == null) {
            return;
        }
        AddBomAction.doAddBOM(file2);
    }

    private static void doAddBOM(@NotNull VirtualFile virtualFile) {
        byte[] bom;
        if (virtualFile == null) {
            AddBomAction.$$$reportNull$$$0(3);
        }
        if ((bom = virtualFile.getBOM()) != null) {
            return;
        }
        Charset charset = virtualFile.getCharset();
        byte[] possibleBom = CharsetToolkit.getPossibleBom((Charset)charset);
        if (possibleBom == null) {
            return;
        }
        virtualFile.setBOM(possibleBom);
        try {
            byte[] bytes = virtualFile.contentsToByteArray();
            byte[] contentWithAddedBom = ArrayUtil.mergeArrays((byte[])possibleBom, (byte[])bytes);
            WriteAction.runAndWait(() -> virtualFile.setBinaryContent(contentWithAddedBom));
        }
        catch (IOException ex) {
            Logger.getInstance(AddBomAction.class).warn("Unexpected exception occurred in file " + String.valueOf(virtualFile), (Throwable)ex);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/AddBomAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/AddBomAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddBOM";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

