/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.DocumentGuardedTextUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class DuplicateAction
extends EditorAction {
    public DuplicateAction() {
        super((EditorActionHandler)new Handler());
    }

    public static void duplicateLineOrSelectedBlockAtCaret(Editor editor2) {
        Document document2 = editor2.getDocument();
        CaretModel caretModel = editor2.getCaretModel();
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        if (editor2.getSelectionModel().hasSelection()) {
            int start2 = editor2.getSelectionModel().getSelectionStart();
            int end = editor2.getSelectionModel().getSelectionEnd();
            String s = document2.getCharsSequence().subSequence(start2, end).toString();
            document2.insertString(end, (CharSequence)s);
            caretModel.moveToOffset(end + s.length());
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            editor2.getSelectionModel().removeSelection();
            editor2.getSelectionModel().setSelection(end, end + s.length());
        } else {
            DuplicateAction.duplicateLinesRange(editor2, caretModel.getVisualPosition(), caretModel.getVisualPosition());
        }
    }

    @NotNull
    static TextRange duplicateLinesRange(@NotNull Editor editor2, @NotNull VisualPosition rangeStart, @NotNull VisualPosition rangeEnd) {
        if (editor2 == null) {
            DuplicateAction.$$$reportNull$$$0(0);
        }
        if (rangeStart == null) {
            DuplicateAction.$$$reportNull$$$0(1);
        }
        if (rangeEnd == null) {
            DuplicateAction.$$$reportNull$$$0(2);
        }
        TextRange range = EditorUtil.calcSurroundingTextRange(editor2, rangeStart, rangeEnd);
        Object s = editor2.getDocument().getText(range);
        int offset = editor2.getCaretModel().getOffset();
        int newOffset = offset + range.getLength();
        int selectionStart = range.getEndOffset();
        if (!((String)s).endsWith("\n")) {
            s = "\n" + (String)s;
            ++newOffset;
            ++selectionStart;
        }
        DocumentGuardedTextUtil.insertString(editor2.getDocument(), range.getEndOffset(), (CharSequence)s);
        editor2.getCaretModel().moveToOffset(newOffset);
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TextRange textRange = TextRange.create((int)selectionStart, (int)(range.getEndOffset() + ((String)s).length()));
        if (textRange == null) {
            DuplicateAction.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public void update(Editor editor2, Presentation presentation2, DataContext dataContext2) {
        super.update(editor2, presentation2, dataContext2);
        if (editor2.getSelectionModel().hasSelection()) {
            presentation2.setText(EditorBundle.message((String)"action.duplicate.selection", (Object[])new Object[0]), true);
        } else {
            presentation2.setText(EditorBundle.message((String)"action.duplicate.line", (Object[])new Object[0]), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeStart";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeEnd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/DuplicateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/DuplicateAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicateLinesRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "duplicateLinesRange";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            DuplicateAction.duplicateLineOrSelectedBlockAtCaret(editor2);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(3);
            }
            return !editor2.isOneLineMode() || editor2.getSelectionModel().hasSelection();
        }

        public boolean reverseCaretOrder() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/DuplicateAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

