/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

final class MoveCaretUpOrDownHandler
extends EditorActionHandler.ForEachCaret {
    @NotNull
    private final Direction myDirection;

    MoveCaretUpOrDownHandler(@NotNull Direction direction) {
        if (direction == null) {
            MoveCaretUpOrDownHandler.$$$reportNull$$$0(0);
        }
        this.myDirection = direction;
    }

    public void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            MoveCaretUpOrDownHandler.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            MoveCaretUpOrDownHandler.$$$reportNull$$$0(2);
        }
        Runnable runnable2 = () -> {
            if (!(!caret.hasSelection() || editor2 instanceof EditorEx && ((EditorEx)editor2).isStickySelection() || Registry.is((String)"editor.action.caretMovement.UpDownIgnoreSelectionBoundaries", (boolean)false))) {
                int targetOffset = this.myDirection == Direction.DOWN ? caret.getSelectionEnd() : caret.getSelectionStart();
                caret.moveToOffset(targetOffset);
            }
            int lineShift = this.myDirection == Direction.DOWN ? 1 : -1;
            caret.moveCaretRelatively(0, lineShift, false, caret == editor2.getCaretModel().getPrimaryCaret());
        };
        EditorUtil.runWithAnimationDisabled(editor2, runnable2);
    }

    public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            MoveCaretUpOrDownHandler.$$$reportNull$$$0(3);
        }
        if (caret == null) {
            MoveCaretUpOrDownHandler.$$$reportNull$$$0(4);
        }
        return !editor2.isOneLineMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/MoveCaretUpOrDownHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum Direction {
        UP,
        DOWN;

    }
}

