/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import java.awt.Point;
import java.util.List;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BlockInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, BlockInlayImpl<?>>
implements IntSupplier {
    final boolean myShowAbove;
    final boolean myShowWhenFolded;
    final int myPriority;
    private int myHeightInPixels;
    private GutterIconRenderer myGutterIconRenderer;

    BlockInlayImpl(@NotNull EditorImpl editor2, int offset, boolean relatesToPrecedingText, boolean showAbove, boolean showWhenFolded, int priority, @NotNull R renderer2) {
        if (editor2 == null) {
            BlockInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            BlockInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor2, offset, relatesToPrecedingText, renderer2);
        this.myShowAbove = showAbove;
        this.myShowWhenFolded = showWhenFolded;
        this.myPriority = priority;
    }

    @Override
    @ApiStatus.Internal
    public MarkerTreeWithPartialSums<BlockInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myBlockElementsTree;
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels < 0) {
            throw PluginException.createByClass((String)("Non-negative width should be defined for a block element by " + String.valueOf(this.myRenderer)), null, (Class)this.myRenderer.getClass());
        }
        int oldHeightInPixels = this.myHeightInPixels;
        this.myHeightInPixels = this.myRenderer.calcHeightInPixels((Inlay)this);
        if (oldHeightInPixels != this.myHeightInPixels) {
            this.getTree().valueUpdated(this);
        }
        if (this.myHeightInPixels < 0) {
            throw PluginException.createByClass((String)("Non-negative height should be defined for a block element by " + String.valueOf(this.myRenderer)), null, (Class)this.myRenderer.getClass());
        }
        this.myGutterIconRenderer = this.myRenderer.calcGutterIconRenderer((Inlay)this);
    }

    @Override
    Point getPosition() {
        int y;
        int visualLine = this.myEditor.offsetToVisualLine(this.getOffset());
        int[] yRange = this.myEditor.visualLineToYRange(visualLine);
        List<Inlay<?>> allInlays = this.myEditor.getInlayModel().getBlockElementsForVisualLine(visualLine, this.myShowAbove);
        if (this.myShowAbove) {
            y = yRange[0];
            boolean found = false;
            for (Inlay<?> inlay : allInlays) {
                if (inlay == this) {
                    found = true;
                }
                if (!found) continue;
                y -= inlay.getHeightInPixels();
            }
        } else {
            y = yRange[1];
            for (Inlay<?> inlay : allInlays) {
                if (inlay == this) break;
                y += inlay.getHeightInPixels();
            }
        }
        return new Point(this.myEditor.getContentComponent().getInsets().left, y);
    }

    public int getHeightInPixels() {
        return this.myHeightInPixels;
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = this.myShowAbove ? Inlay.Placement.ABOVE_LINE : Inlay.Placement.BELOW_LINE;
        if (placement == null) {
            BlockInlayImpl.$$$reportNull$$$0(2);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getOffset());
        if (visualPosition == null) {
            BlockInlayImpl.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    @Override
    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Override
    public int getAsInt() {
        return this.myHeightInPixels;
    }

    @NotNull
    public InlayProperties getProperties() {
        InlayProperties inlayProperties = new InlayProperties().relatesToPrecedingText(this.isRelatedToPrecedingText()).showAbove(this.myShowAbove).showWhenFolded(this.myShowWhenFolded).priority(this.myPriority);
        if (inlayProperties == null) {
            BlockInlayImpl.$$$reportNull$$$0(4);
        }
        return inlayProperties;
    }

    public String toString() {
        return "[Block inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", height=" + this.myHeightInPixels + ", renderer=" + String.valueOf(this.myRenderer) + "]" + (this.isValid() ? "" : "(invalid)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/BlockInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/BlockInlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

