/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ColorProvider {
    @NotNull
    public abstract Color getColor();

    @NotNull
    public static ColorProvider byColor(@NotNull Color color) {
        if (color == null) {
            ColorProvider.$$$reportNull$$$0(0);
        }
        return new StaticColorHolder(color);
    }

    public static ColorProvider byColorScheme(Editor editor2, ColorKey ... keys) {
        return ColorProvider.byColorsScheme(editor2.getColorsScheme(), keys);
    }

    public static ColorProvider byColorsScheme(EditorColorsScheme scheme, ColorKey ... keys) {
        return new ColorSchemeBasedHolder(scheme, keys);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/ColorProvider", "byColor"));
    }

    private static final class StaticColorHolder
    extends ColorProvider {
        private final Color myColor;

        StaticColorHolder(@NotNull Color color) {
            if (color == null) {
                StaticColorHolder.$$$reportNull$$$0(0);
            }
            this.myColor = color;
        }

        @Override
        @NotNull
        public Color getColor() {
            Color color = this.myColor;
            if (color == null) {
                StaticColorHolder.$$$reportNull$$$0(1);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/ColorProvider$StaticColorHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/ColorProvider$StaticColorHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ColorSchemeBasedHolder
    extends ColorProvider {
        private final EditorColorsScheme myScheme;
        private final List<ColorKey> myKeys = new ArrayList<ColorKey>();

        ColorSchemeBasedHolder(EditorColorsScheme scheme, ColorKey ... keys) {
            this.myScheme = scheme;
            this.myKeys.addAll(Arrays.asList(keys));
            Collections.reverse(this.myKeys);
        }

        @Override
        @NotNull
        public Color getColor() {
            while (!this.myKeys.isEmpty()) {
                ColorKey key = this.myKeys.get(this.myKeys.size() - 1);
                Color result2 = this.myScheme.getColor(key);
                if (result2 == null || result2.equals(this.myScheme.getDefaultForeground())) {
                    this.myKeys.remove(this.myKeys.size() - 1);
                    continue;
                }
                Color color = result2;
                if (color == null) {
                    ColorSchemeBasedHolder.$$$reportNull$$$0(0);
                }
                return color;
            }
            Color color = this.myScheme.getDefaultForeground();
            if (color == null) {
                ColorSchemeBasedHolder.$$$reportNull$$$0(1);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ColorProvider$ColorSchemeBasedHolder", "getColor"));
        }
    }
}

