/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import java.awt.Font;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorColorSchemeDelegate
extends DelegateColorScheme {
    private static final Logger LOG = Logger.getInstance(EditorColorSchemeDelegate.class);
    private static final float FONT_SIZE_TO_IGNORE = -1.0f;
    private final EditorImpl myEditor;
    private final FontPreferencesImpl myFontPreferences;
    private final FontPreferencesImpl myConsoleFontPreferences;
    private final Map<TextAttributesKey, TextAttributes> myOwnAttributes;
    private final Map<ColorKey, Color> myOwnColors;
    private final EditorColorsScheme myCustomGlobalScheme;
    private Map<EditorFontType, Font> myFontsMap;
    private float myMaxFontSize;
    private float myFontSize;
    private float myConsoleFontSize;
    private String myFaceName;
    private Float myLineSpacing;
    private boolean myFontPreferencesAreSetExplicitly;
    private Boolean myUseLigatures;

    EditorColorSchemeDelegate(@NotNull EditorImpl editor2, @Nullable EditorColorsScheme globalScheme) {
        if (editor2 == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(0);
        }
        super(globalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : globalScheme);
        this.myFontPreferences = new FontPreferencesImpl();
        this.myConsoleFontPreferences = new FontPreferencesImpl();
        this.myOwnAttributes = new HashMap<TextAttributesKey, TextAttributes>();
        this.myOwnColors = new HashMap<ColorKey, Color>();
        this.myMaxFontSize = EditorFontsConstants.getMaxEditorFontSize();
        this.myFontSize = -1.0f;
        this.myConsoleFontSize = -1.0f;
        this.myEditor = editor2;
        this.myCustomGlobalScheme = globalScheme;
        this.updateGlobalScheme();
    }

    @Override
    public TextAttributes getAttributes(TextAttributesKey key) {
        if (this.myOwnAttributes.containsKey(key)) {
            return this.myOwnAttributes.get(key);
        }
        return this.getDelegate().getAttributes(key);
    }

    @Override
    public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
        if (key == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(1);
        }
        if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
            this.getDelegate().setAttributes(key, attributes);
        } else {
            this.myOwnAttributes.put(key, attributes);
        }
    }

    @Override
    @Nullable
    public Color getColor(ColorKey key) {
        if (this.myOwnColors.containsKey(key)) {
            return this.myOwnColors.get(key);
        }
        return this.getDelegate().getColor(key);
    }

    @Override
    public void setColor(ColorKey key, Color color) {
        if (color == AbstractColorsScheme.INHERITED_COLOR_MARKER) {
            this.myOwnColors.remove(key);
        } else {
            this.myOwnColors.put(key, color);
        }
        this.myEditor.getCaretModel().reinitSettings();
        this.myEditor.getSelectionModel().reinitSettings();
    }

    @Override
    public int getEditorFontSize() {
        return (int)((double)this.getEditorFontSize2D() + 0.5);
    }

    @Override
    public float getEditorFontSize2D() {
        if (this.myFontPreferencesAreSetExplicitly) {
            return this.myFontPreferences.getSize2D(this.myFontPreferences.getFontFamily());
        }
        if (this.myFontSize == -1.0f) {
            return UISettingsUtils.getInstance().scaleFontSize(this.getDelegate().getEditorFontSize2D());
        }
        return this.myFontSize;
    }

    @Override
    public void setEditorFontSize(int fontSize) {
        this.setEditorFontSize((float)fontSize);
    }

    @Override
    public void setEditorFontSize(float fontSize) {
        float maxSize;
        float originalSize = UISettingsUtils.getInstance().scaleFontSize(this.getDelegate().getEditorFontSize2D());
        float minSize = Math.min(4.0f, originalSize);
        if (fontSize < minSize) {
            fontSize = minSize;
        }
        if (fontSize > (maxSize = Math.max(this.myMaxFontSize, originalSize))) {
            fontSize = maxSize;
        }
        if (fontSize == this.myFontSize) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Font size overridden for " + String.valueOf(this.myEditor), new Throwable());
        }
        this.myFontPreferencesAreSetExplicitly = false;
        this.myFontSize = fontSize == originalSize ? -1.0f : fontSize;
        this.reinitFonts();
        this.myEditor.reinitSettings(true, false);
    }

    @Override
    @NotNull
    public FontPreferences getFontPreferences() {
        Object object = !this.myFontPreferencesAreSetExplicitly && this.myFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getFontPreferences() : this.myFontPreferences;
        if (object == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(3);
        }
        if (this.myFontPreferencesAreSetExplicitly && Comparing.equal((Object)preferences, (Object)this.myFontPreferences)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Font preferences overridden for " + String.valueOf(this.myEditor), new Throwable());
        }
        this.myFontPreferencesAreSetExplicitly = true;
        this.myFaceName = null;
        this.myFontSize = -1.0f;
        preferences.copyTo((FontPreferences)this.myFontPreferences);
        this.reinitFontsAndSettings();
    }

    @Override
    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        Object object = this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getConsoleFontPreferences() : this.myConsoleFontPreferences;
        if (object == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(5);
        }
        if (Comparing.equal((Object)preferences, (Object)this.myConsoleFontPreferences)) {
            return;
        }
        preferences.copyTo((FontPreferences)this.myConsoleFontPreferences);
        this.reinitFontsAndSettings();
    }

    @Override
    public String getEditorFontName() {
        if (this.myFontPreferencesAreSetExplicitly) {
            return this.myFontPreferences.getFontFamily();
        }
        if (this.myFaceName == null) {
            return this.getDelegate().getEditorFontName();
        }
        return this.myFaceName;
    }

    @Override
    public void setEditorFontName(String fontName) {
        if (Objects.equals(fontName, this.myFaceName)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Font name overridden for " + String.valueOf(this.myEditor), new Throwable());
        }
        this.myFontPreferencesAreSetExplicitly = false;
        this.myFaceName = fontName;
        this.reinitFontsAndSettings();
    }

    @Override
    @NotNull
    public Font getFont(EditorFontType key) {
        Font font;
        if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
            Font font2 = font;
            if (font2 == null) {
                EditorColorSchemeDelegate.$$$reportNull$$$0(6);
            }
            return font2;
        }
        Font font3 = this.getDelegate().getFont(key);
        if (font3 == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(7);
        }
        return font3;
    }

    @Override
    public void setDelegate(@NotNull EditorColorsScheme delegate) {
        if (delegate == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(8);
        }
        super.setDelegate(delegate);
        float globalFontSize = this.getDelegate().getEditorFontSize2D();
        this.myMaxFontSize = Math.max((float)EditorFontsConstants.getMaxEditorFontSize(), globalFontSize);
        this.reinitFonts();
    }

    @Override
    public void setConsoleFontSize(int fontSize) {
        this.setConsoleFontSize((float)fontSize);
    }

    @Override
    public void setConsoleFontSize(float fontSize) {
        this.myConsoleFontSize = fontSize == super.getConsoleFontSize2D() ? -1.0f : fontSize;
        this.reinitFontsAndSettings();
    }

    @Override
    public int getConsoleFontSize() {
        return (int)((double)this.getConsoleFontSize2D() + 0.5);
    }

    @Override
    public float getConsoleFontSize2D() {
        return this.myConsoleFontSize == -1.0f ? super.getConsoleFontSize2D() : this.myConsoleFontSize;
    }

    @Override
    public float getLineSpacing() {
        return this.myLineSpacing == null ? super.getLineSpacing() : this.myLineSpacing.floatValue();
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        float oldLineSpacing = this.getLineSpacing();
        float newLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing((float)lineSpacing);
        this.myLineSpacing = Float.valueOf(newLineSpacing);
        if (oldLineSpacing != newLineSpacing) {
            this.myEditor.reinitSettings();
        }
    }

    @Override
    public boolean isUseLigatures() {
        return this.myUseLigatures == null ? super.isUseLigatures() : this.myUseLigatures.booleanValue();
    }

    @Override
    public void setUseLigatures(boolean useLigatures) {
        this.myUseLigatures = useLigatures;
        this.reinitFontsAndSettings();
    }

    @Override
    @Nullable
    public Object clone() {
        return null;
    }

    void resetEditorFontSize() {
        this.myFontSize = -1.0f;
        this.reinitFonts();
    }

    void updateGlobalScheme() {
        EditorColorSchemeDelegate scheme = this;
        while (scheme instanceof DelegateColorScheme) {
            DelegateColorScheme delegateColorScheme = scheme;
            if (scheme instanceof EditorColorSchemeDelegate) {
                EditorColorSchemeDelegate myColorSchemeDelegate = scheme;
                myColorSchemeDelegate.updateDelegate();
            }
            scheme = delegateColorScheme.getDelegate();
        }
    }

    private void reinitFontsAndSettings() {
        this.reinitFonts();
        this.myEditor.reinitSettings();
    }

    private void reinitFonts() {
        EditorColorsScheme delegate = this.getDelegate();
        String editorFontName = this.getEditorFontName();
        float editorFontSize = this.getEditorFontSize2D();
        if (!this.myFontPreferencesAreSetExplicitly) {
            EditorColorSchemeDelegate.updatePreferences(this.myFontPreferences, editorFontName, editorFontSize, this.myUseLigatures, delegate.getFontPreferences());
        }
        String consoleFontName = this.getConsoleFontName();
        float consoleFontSize = this.getConsoleFontSize2D();
        EditorColorSchemeDelegate.updatePreferences(this.myConsoleFontPreferences, consoleFontName, consoleFontSize, this.myUseLigatures, delegate.getConsoleFontPreferences());
        this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
        this.setFont(EditorFontType.PLAIN, editorFontName, 0, editorFontSize, (FontPreferences)this.myFontPreferences);
        this.setFont(EditorFontType.BOLD, editorFontName, 1, editorFontSize, (FontPreferences)this.myFontPreferences);
        this.setFont(EditorFontType.ITALIC, editorFontName, 2, editorFontSize, (FontPreferences)this.myFontPreferences);
        this.setFont(EditorFontType.BOLD_ITALIC, editorFontName, 3, editorFontSize, (FontPreferences)this.myFontPreferences);
        this.setFont(EditorFontType.CONSOLE_PLAIN, consoleFontName, 0, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
        this.setFont(EditorFontType.CONSOLE_BOLD, consoleFontName, 1, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
        this.setFont(EditorFontType.CONSOLE_ITALIC, consoleFontName, 2, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
        this.setFont(EditorFontType.CONSOLE_BOLD_ITALIC, consoleFontName, 3, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
    }

    private void setFont(@NotNull EditorFontType fontType, @NotNull String familyName, int style, float fontSize, @NotNull FontPreferences fontPreferences) {
        if (fontType == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(9);
        }
        if (familyName == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(10);
        }
        if (fontPreferences == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(11);
        }
        Font baseFont = FontFamilyService.getFont((String)familyName, (String)fontPreferences.getRegularSubFamily(), (String)fontPreferences.getBoldSubFamily(), (int)style, (float)fontSize);
        Font fontWithLigatures = EditorFontCacheImpl.deriveFontWithLigatures((Font)baseFont, (boolean)(this.myUseLigatures != null ? this.myUseLigatures.booleanValue() : fontPreferences.useLigatures()));
        this.myFontsMap.put(fontType, fontWithLigatures);
    }

    private void updateDelegate() {
        EditorColorsScheme delegate = this.myCustomGlobalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.myCustomGlobalScheme;
        this.setDelegate(delegate);
    }

    private static void updatePreferences(@NotNull FontPreferencesImpl preferences, @NotNull String fontName, float fontSize, @Nullable Boolean useLigatures, @NotNull FontPreferences delegatePreferences) {
        if (preferences == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(12);
        }
        if (fontName == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(13);
        }
        if (delegatePreferences == null) {
            EditorColorSchemeDelegate.$$$reportNull$$$0(14);
        }
        preferences.clear();
        preferences.register(fontName, fontSize);
        List families = delegatePreferences.getRealFontFamilies();
        for (int i2 = 1; i2 < families.size(); ++i2) {
            String font = (String)families.get(i2);
            preferences.register(font, fontSize);
        }
        preferences.setUseLigatures(useLigatures != null ? useLigatures.booleanValue() : delegatePreferences.useLigatures());
        preferences.setRegularSubFamily(delegatePreferences.getRegularSubFamily());
        preferences.setBoldSubFamily(delegatePreferences.getBoldSubFamily());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorColorSchemeDelegate";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPreferences";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegatePreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorColorSchemeDelegate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleFontPreferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFontPreferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleFontPreferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDelegate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFont";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updatePreferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

