/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SingleEdtTaskScheduler;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorSizeAdjustmentStrategy {
    private static final long TIMING_TTL_MILLIS = 10000L;
    private static final int FREQUENT_SIZE_CHANGES_NUMBER = EditorSizeAdjustmentStrategy.getFrequentSizeChangesNumber();
    private static final int DEFAULT_RESERVE_COLUMNS_NUMBER = 4;
    private final SingleEdtTaskScheduler alarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
    private final LongList myTimings = new LongArrayList();
    private int myReserveColumns = 4;
    private boolean myInsideValidation;

    EditorSizeAdjustmentStrategy() {
    }

    @NotNull
    Dimension adjust(@NotNull Dimension newPreferredSize, @Nullable Dimension oldPreferredSize, @NotNull EditorImpl editor2) {
        Dimension result2;
        boolean increaseWidth;
        if (newPreferredSize == null) {
            EditorSizeAdjustmentStrategy.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EditorSizeAdjustmentStrategy.$$$reportNull$$$0(1);
        }
        if (oldPreferredSize == null || this.myInsideValidation) {
            Dimension dimension = newPreferredSize;
            if (dimension == null) {
                EditorSizeAdjustmentStrategy.$$$reportNull$$$0(2);
            }
            return dimension;
        }
        if (newPreferredSize.height != oldPreferredSize.height) {
            Dimension dimension = newPreferredSize;
            if (dimension == null) {
                EditorSizeAdjustmentStrategy.$$$reportNull$$$0(3);
            }
            return dimension;
        }
        this.stripTimings();
        this.myTimings.add(System.currentTimeMillis());
        if (this.myTimings.size() < FREQUENT_SIZE_CHANGES_NUMBER) {
            Dimension dimension = newPreferredSize;
            if (dimension == null) {
                EditorSizeAdjustmentStrategy.$$$reportNull$$$0(4);
            }
            return dimension;
        }
        boolean bl = increaseWidth = newPreferredSize.width > oldPreferredSize.width;
        if (increaseWidth) {
            int spaceWidth = EditorUtil.getSpaceWidth(0, editor2);
            newPreferredSize.width += this.myReserveColumns * spaceWidth;
            this.myReserveColumns += 3;
            result2 = newPreferredSize;
        } else {
            result2 = oldPreferredSize;
        }
        this.scheduleSizeUpdate(editor2);
        Dimension dimension = result2;
        if (dimension == null) {
            EditorSizeAdjustmentStrategy.$$$reportNull$$$0(5);
        }
        return dimension;
    }

    void cancelAllRequests() {
        this.alarm.cancel();
    }

    private void stripTimings() {
        int endIndex;
        long limit = System.currentTimeMillis() - 10000L;
        for (endIndex = 0; endIndex < this.myTimings.size() && this.myTimings.getLong(endIndex) <= limit; ++endIndex) {
        }
        if (endIndex > 0) {
            this.myTimings.removeElements(0, endIndex);
        }
    }

    private void scheduleSizeUpdate(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            EditorSizeAdjustmentStrategy.$$$reportNull$$$0(6);
        }
        this.alarm.cancelAndRequest(1000L, (Runnable)new UpdateSizeTask(editor2));
    }

    private static int getFrequentSizeChangesNumber() {
        return Registry.intValue((String)"editor.viewport.width.update.frequency", (int)200);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPreferredSize";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjust";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjust";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSizeUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private final class UpdateSizeTask
    implements Runnable {
        private final EditorImpl myEditor;

        UpdateSizeTask(EditorImpl editor2) {
            if (editor2 == null) {
                UpdateSizeTask.$$$reportNull$$$0(0);
            }
            this.myEditor = editor2;
        }

        @Override
        public void run() {
            EditorSizeAdjustmentStrategy.this.myInsideValidation = true;
            EditorSizeAdjustmentStrategy.this.myReserveColumns = 4;
            EditorSizeAdjustmentStrategy.this.myTimings.clear();
            try {
                this.myEditor.validateSize();
            }
            finally {
                EditorSizeAdjustmentStrategy.this.myInsideValidation = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy$UpdateSizeTask", "<init>"));
        }
    }
}

