/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.text.CharArrayIterator;
import com.intellij.util.text.CharSequenceIterator;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FontFallbackIterator {
    private static final char COMPLEX_CHAR_START = '\u0300';
    private final BreakAtEveryCharacterIterator myTrivialBreaker = new BreakAtEveryCharacterIterator();
    private FontPreferences myFontPreferences = new FontPreferencesImpl();
    private int myFontStyle = 0;
    private FontRenderContext myFontRenderContext;
    private char[] myTextAsArray;
    private CharSequence myTextAsCharSequence;
    private BreakIterator myIterator;
    private int myStart;
    private int myEnd;
    private FontInfo myFontInfo;
    private FontInfo myNextFontInfo;

    public FontFallbackIterator setPreferredFonts(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            FontFallbackIterator.$$$reportNull$$$0(0);
        }
        this.myFontPreferences = fontPreferences;
        return this;
    }

    public FontFallbackIterator setPreferredFont(@NotNull String familyName, int size2) {
        if (familyName == null) {
            FontFallbackIterator.$$$reportNull$$$0(1);
        }
        FontPreferencesImpl preferences = new FontPreferencesImpl();
        preferences.register(familyName, size2);
        this.myFontPreferences = preferences;
        return this;
    }

    public FontFallbackIterator setFontStyle(@JdkConstants.FontStyle int fontStyle) {
        this.myFontStyle = fontStyle;
        return this;
    }

    public FontFallbackIterator setFontRenderContext(@Nullable FontRenderContext fontRenderContext) {
        this.myFontRenderContext = fontRenderContext;
        return this;
    }

    public void start(@NotNull CharSequence text2, int start2, int end) {
        if (text2 == null) {
            FontFallbackIterator.$$$reportNull$$$0(2);
        }
        assert (0 <= start2 && start2 <= end && end <= text2.length()) : "Text length: " + text2.length() + ", start: " + start2 + ", end: " + end;
        CharSequenceIterator characterIterator = null;
        for (int i2 = start2; i2 < end; ++i2) {
            if (text2.charAt(i2) < '\u0300') continue;
            characterIterator = new CharSequenceIterator(text2, start2, end);
            break;
        }
        this.doStart(text2, null, (CharacterIterator)characterIterator, start2, end);
    }

    public void start(char @NotNull [] text2, int start2, int end) {
        if (text2 == null) {
            FontFallbackIterator.$$$reportNull$$$0(3);
        }
        assert (0 <= start2 && start2 <= end && end <= text2.length) : "Text length: " + text2.length + ", start: " + start2 + ", end: " + end;
        CharArrayIterator characterIterator = null;
        for (int i2 = start2; i2 < end; ++i2) {
            if (text2[i2] < '\u0300') continue;
            characterIterator = new CharArrayIterator(text2, start2, end);
            break;
        }
        this.doStart(null, text2, (CharacterIterator)characterIterator, start2, end);
    }

    private void doStart(CharSequence textAsCharSequence, char[] textAsArray, CharacterIterator characterIterator, int start2, int end) {
        this.myTextAsCharSequence = textAsCharSequence;
        this.myTextAsArray = textAsArray;
        if (characterIterator == null) {
            this.myTrivialBreaker.setRange(start2, end);
            this.myIterator = this.myTrivialBreaker;
        } else {
            this.myIterator = BreakIterator.getCharacterInstance();
            this.myIterator.setText(characterIterator);
        }
        this.myStart = this.myEnd = this.myIterator.first();
        assert (this.myStart == start2);
        this.myNextFontInfo = null;
        this.myFontInfo = null;
        this.advance();
    }

    public boolean atEnd() {
        return this.myStart == this.myEnd;
    }

    public void advance() {
        int end;
        this.myStart = this.myEnd;
        this.myEnd = this.myIterator.current();
        this.myFontInfo = this.myNextFontInfo;
        while ((end = this.myIterator.next()) != -1) {
            this.myNextFontInfo = this.isFormatChar(this.myEnd, end) && this.myFontInfo != null ? this.myFontInfo : this.getFontAbleToDisplay(this.myEnd, end);
            if (this.myFontInfo == null) {
                this.myFontInfo = this.myNextFontInfo;
            }
            if (this.myNextFontInfo.equals(this.myFontInfo)) {
                this.myEnd = end;
                continue;
            }
            return;
        }
    }

    private boolean isFormatChar(int start2, int end) {
        if (end - start2 == 1) {
            char charCode;
            char c = charCode = this.myTextAsCharSequence == null ? this.myTextAsArray[start2] : this.myTextAsCharSequence.charAt(start2);
            if (charCode >= '\u200c' && (charCode <= '\u200f' || charCode >= '\u2028' && charCode <= '\u202e' || charCode >= '\u206a' && charCode <= '\u206f')) {
                return true;
            }
        }
        return false;
    }

    private FontInfo getFontAbleToDisplay(int start2, int end) {
        if (this.myTextAsCharSequence == null) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(this.myTextAsArray, start2, end, this.myFontStyle, this.myFontPreferences, this.myFontRenderContext);
        }
        return ComplementaryFontsRegistry.getFontAbleToDisplay(this.myTextAsCharSequence, start2, end, this.myFontStyle, this.myFontPreferences, this.myFontRenderContext);
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public FontInfo getFontInfo() {
        if (this.myFontRenderContext == null) {
            throw new IllegalStateException("FontRenderContext must be set to generate FontInfo");
        }
        FontInfo fontInfo = this.myFontInfo;
        if (fontInfo == null) {
            FontFallbackIterator.$$$reportNull$$$0(4);
        }
        return fontInfo;
    }

    @NotNull
    public Font getFont() {
        Font font = this.myFontInfo.getFont();
        if (font == null) {
            FontFallbackIterator.$$$reportNull$$$0(5);
        }
        return font;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPreferences";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FontFallbackIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FontFallbackIterator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredFonts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredFont";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class BreakAtEveryCharacterIterator
    extends BreakIterator {
        private int myStart;
        private int myEnd;
        private int myCurrent;

        private BreakAtEveryCharacterIterator() {
        }

        public void setRange(int start2, int end) {
            this.myStart = start2;
            this.myEnd = end;
        }

        @Override
        public int first() {
            this.myCurrent = this.myStart;
            return this.myCurrent;
        }

        @Override
        public int last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int next(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int next() {
            return this.myCurrent >= this.myEnd ? -1 : (this.myCurrent = this.myCurrent + 1);
        }

        @Override
        public int previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int following(int offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int current() {
            return this.myCurrent;
        }

        @Override
        public CharacterIterator getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setText(CharacterIterator newText) {
            throw new UnsupportedOperationException();
        }
    }
}

