/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.LightweightHint;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IndentsModelCaretListener
implements CaretListener {
    @NotNull
    private final EditorImpl myEditor;
    @Nullable
    private IndentGuideDescriptor myCurrentCaretGuide;
    @Nullable
    protected LightweightHint myCurrentHint;

    public IndentsModelCaretListener(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            IndentsModelCaretListener.$$$reportNull$$$0(0);
        }
        this.myEditor = editor2;
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        IndentGuideDescriptor newGuide;
        if (event == null) {
            IndentsModelCaretListener.$$$reportNull$$$0(1);
        }
        if (!Comparing.equal((Object)this.myCurrentCaretGuide, (Object)(newGuide = this.getCaretIndentGuide(event)))) {
            this.repaintGuide(newGuide);
            this.repaintGuide(this.myCurrentCaretGuide);
            this.myCurrentCaretGuide = newGuide;
            if (this.myCurrentHint != null) {
                this.myCurrentHint.hide();
                this.myCurrentHint = null;
            }
            if (newGuide != null && this.shouldShowHint(newGuide)) {
                this.showHint(newGuide);
            }
        }
    }

    private void repaintGuide(@Nullable IndentGuideDescriptor guide) {
        if (guide != null) {
            this.myEditor.repaintLines(guide.startLine, guide.endLine);
        }
    }

    private boolean shouldShowHint(@NotNull IndentGuideDescriptor descriptor) {
        if (descriptor == null) {
            IndentsModelCaretListener.$$$reportNull$$$0(2);
        }
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        boolean isLineBeforeVisibleArea = this.myEditor.logicalLineToY(descriptor.startLine) < visibleArea.y;
        return isLineBeforeVisibleArea && !this.myEditor.shouldSuppressEditorFragmentHint(descriptor.startLine);
    }

    @Nullable
    protected IndentGuideDescriptor getCaretIndentGuide(@NotNull CaretEvent event) {
        if (event == null) {
            IndentsModelCaretListener.$$$reportNull$$$0(3);
        }
        return this.myEditor.getIndentsModel().getCaretIndentGuide();
    }

    protected void showHint(@NotNull IndentGuideDescriptor descriptor) {
        if (descriptor == null) {
            IndentsModelCaretListener.$$$reportNull$$$0(4);
        }
        int startLine = Math.max(descriptor.codeConstructStartLine, descriptor.startLine - EditorFragmentComponent.getAvailableVisualLinesAboveEditor(this.myEditor) + 1);
        TextRange textRange = new TextRange(this.myEditor.getDocument().getLineStartOffset(startLine), this.myEditor.getDocument().getLineEndOffset(descriptor.startLine));
        this.myCurrentHint = EditorFragmentComponent.showEditorFragmentHint(this.myEditor, textRange, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/IndentsModelCaretListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "caretPositionChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCaretIndentGuide";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

