/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/editor/impl/RelativeLineHelper;", "", "<init>", "()V", "getHybridLine", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretLine", "logicalLine", "getRelativeLine", "getLogicalLine", "relativeLine", "getOffsetAtFoldStart", "line", "checkIfShouldCheckForFolds", "", "step", "getFoldBorderLine", "getLogicalLineRangeInVisualLine", "Lkotlin/ranges/IntRange;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class RelativeLineHelper {
    @NotNull
    public static final RelativeLineHelper INSTANCE = new RelativeLineHelper();

    private RelativeLineHelper() {
    }

    public final int getHybridLine(@NotNull Editor editor2, int caretLine, int logicalLine) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (caretLine == logicalLine) {
            return logicalLine + 1;
        }
        IntRange caretFoldLineRange = this.getLogicalLineRangeInVisualLine(editor2, caretLine);
        int n = caretFoldLineRange.getFirst();
        return (logicalLine <= caretFoldLineRange.getLast() ? n <= logicalLine : false) ? caretFoldLineRange.getFirst() + 1 : this.getRelativeLine(editor2, caretLine, logicalLine);
    }

    public final int getRelativeLine(@NotNull Editor editor2, int caretLine, int logicalLine) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        FoldingModelImpl foldingModel2 = (FoldingModelImpl)foldingModel;
        int caretOffset = this.getOffsetAtFoldStart(editor2, caretLine);
        int lineOffset = this.getOffsetAtFoldStart(editor2, logicalLine);
        int foldedBeforeCaret = foldingModel2.getFoldedLinesCountBefore(caretOffset);
        int foldedBeforeLine = foldingModel2.getFoldedLinesCountBefore(lineOffset);
        int caretLineAtFoldStart = editor2.offsetToLogicalPosition((int)caretOffset).line;
        int logicalLineAtFoldStart = editor2.offsetToLogicalPosition((int)lineOffset).line;
        return logicalLineAtFoldStart - caretLineAtFoldStart - (foldedBeforeLine - foldedBeforeCaret);
    }

    public final int getLogicalLine(@NotNull Editor editor2, int caretLine, int relativeLine) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int step2 = MathKt.getSign((int)relativeLine);
        boolean shouldHandleFolds = this.checkIfShouldCheckForFolds(editor2, caretLine, step2);
        if (!shouldHandleFolds) {
            n = caretLine + relativeLine;
        } else {
            int line = this.getFoldBorderLine(editor2, caretLine, step2);
            for (int relativeDistance = 0; relativeDistance < Math.abs(relativeLine); ++relativeDistance) {
                line = this.getFoldBorderLine(editor2, line + step2, step2);
            }
            n = this.getFoldBorderLine(editor2, line, -1);
        }
        return n;
    }

    private final int getOffsetAtFoldStart(Editor editor2, int line) {
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int lineStartOffset = document3.getLineStartOffset(line);
        return EditorUtil.getNotFoldedLineStartOffset(editor2, lineStartOffset);
    }

    private final boolean checkIfShouldCheckForFolds(Editor editor2, int caretLine, int step2) {
        int caretLineOffset;
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        FoldingModelImpl foldingModelImpl = (FoldingModelImpl)foldingModel;
        int n = caretLineOffset = step2 < 0 ? document3.getLineEndOffset(caretLine) : document3.getLineStartOffset(caretLine);
        if (foldingModelImpl.isOffsetCollapsed(caretLineOffset)) {
            return true;
        }
        int foldedLinesBeforeCaret = foldingModelImpl.getFoldedLinesCountBefore(caretLineOffset);
        int foldedLinesAfterCaret = foldingModelImpl.getTotalNumberOfFoldedLines() - foldedLinesBeforeCaret;
        return step2 < 0 ? foldedLinesBeforeCaret != 0 : foldedLinesAfterCaret != 0;
    }

    private final int getFoldBorderLine(Editor editor2, int line, int step2) {
        IntRange fold = this.getLogicalLineRangeInVisualLine(editor2, line);
        return step2 < 0 ? fold.getFirst() : fold.getLast();
    }

    private final IntRange getLogicalLineRangeInVisualLine(Editor editor2, int line) {
        int lineOffset = editor2.getDocument().getLineStartOffset(line);
        int foldRegionStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor2, lineOffset);
        int foldRegionEndOffset = EditorUtil.getNotFoldedLineEndOffset(editor2, lineOffset);
        int firstLine = editor2.offsetToLogicalPosition((int)foldRegionStartOffset).line;
        int lastLine = editor2.offsetToLogicalPosition((int)foldRegionEndOffset).line;
        return new IntRange(firstLine, lastLine);
    }
}

