/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollPositionCalculator;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J(\u0010\u0016\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J0\u0010\u001a\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J0\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010%\u001a\u00020\u0005*\u00020&H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/editor/impl/ScrollPositionCalculatorImpl;", "Lcom/intellij/openapi/editor/ScrollPositionCalculator;", "<init>", "()V", "getHorizontalOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "targetLocation", "Ljava/awt/Point;", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "viewRect", "Ljava/awt/Rectangle;", "scrollPane", "Ljavax/swing/JScrollPane;", "getTopmostLocation", "editorHeight", "offsetBottomBound", "getBottommostLocation", "textHeight", "offsetTopBound", "getLeftmostLocation", "editorWidth", "scrollOffset", "spaceWidth", "getRightmostLocation", "textWidth", "getVerticalOffset", "addVerticalOffsetToPosition", "point", "getLastVisualLine", "isUseSoftWraps", "", "getFirstVisualLine", "visualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "getExtent", "Ljavax/swing/JScrollBar;", "intellij.platform.ide.impl"})
public final class ScrollPositionCalculatorImpl
implements ScrollPositionCalculator {
    public int getHorizontalOffset(@NotNull Editor editor2, @NotNull Point targetLocation, @NotNull ScrollType scrollType, @NotNull Rectangle viewRect, @NotNull JScrollPane scrollPane) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)targetLocation, (String)"targetLocation");
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        Intrinsics.checkNotNullParameter((Object)viewRect, (String)"viewRect");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        int horizontalOffset = viewRect.x;
        int spaceWidth = EditorUtil.getSpaceWidth(0, editor2);
        int editorWidth = viewRect.width;
        int n = scrollPane.getHorizontalScrollBar().getMaximum();
        JScrollBar jScrollBar = scrollPane.getHorizontalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"getHorizontalScrollBar(...)");
        int scrollWidth = n - this.getExtent(jScrollBar);
        int textWidth = scrollWidth + editorWidth;
        int scrollOffset = editor2.getSettings().getHorizontalScrollOffset();
        int scrollJump = editor2.getSettings().getHorizontalScrollJump();
        int leftBound = targetLocation.x - scrollOffset * spaceWidth;
        int rightBound = targetLocation.x + scrollOffset * spaceWidth;
        if (rightBound - leftBound > editorWidth) {
            horizontalOffset = targetLocation.x - editorWidth / 2;
        } else if (leftBound < viewRect.x) {
            int n2;
            if (scrollType == ScrollType.MAKE_VISIBLE && rightBound < editorWidth) {
                n2 = 0;
            } else {
                int leftmostPossibleLocation = this.getLeftmostLocation(targetLocation, editorWidth, scrollOffset, spaceWidth);
                int leftAfterScrollJump = Math.max(leftmostPossibleLocation, viewRect.x - scrollJump * spaceWidth);
                n2 = Math.min(leftBound, leftAfterScrollJump);
            }
            horizontalOffset = n2;
        } else if (rightBound > viewRect.x + editorWidth) {
            int rightmostPossibleLocation = this.getRightmostLocation(targetLocation, textWidth, editorWidth, scrollOffset, spaceWidth);
            int rightAfterScrollJump = Math.min(rightmostPossibleLocation, viewRect.x + editorWidth + scrollJump * spaceWidth);
            horizontalOffset = Math.max(rightBound, rightAfterScrollJump) - editorWidth;
        }
        horizontalOffset = Math.max(0, horizontalOffset);
        horizontalOffset = Math.min(scrollWidth, horizontalOffset);
        return horizontalOffset;
    }

    private final int getTopmostLocation(Point targetLocation, int editorHeight, int offsetBottomBound) {
        int topmostLocation = targetLocation.y - editorHeight;
        return topmostLocation < 0 ? 0 : topmostLocation + (offsetBottomBound - targetLocation.y);
    }

    private final int getBottommostLocation(Point targetLocation, int textHeight, int editorHeight, int offsetTopBound) {
        int bottommostLocation = targetLocation.y + editorHeight;
        return bottommostLocation > textHeight ? textHeight : bottommostLocation - (targetLocation.y - offsetTopBound);
    }

    private final int getLeftmostLocation(Point targetLocation, int editorWidth, int scrollOffset, int spaceWidth) {
        int leftmostLocation = targetLocation.x - editorWidth;
        return leftmostLocation < 0 ? 0 : leftmostLocation + scrollOffset * spaceWidth;
    }

    private final int getRightmostLocation(Point targetLocation, int textWidth, int editorWidth, int scrollOffset, int spaceWidth) {
        int rightmostLocation = targetLocation.x + editorWidth;
        return rightmostLocation > textWidth ? textWidth : rightmostLocation - scrollOffset * spaceWidth;
    }

    public int getVerticalOffset(@NotNull Editor editor2, @NotNull Point targetLocation, @NotNull ScrollType scrollType, @NotNull Rectangle viewRect, @NotNull JScrollPane scrollPane) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)targetLocation, (String)"targetLocation");
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        Intrinsics.checkNotNullParameter((Object)viewRect, (String)"viewRect");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        int editorHeight = viewRect.height;
        int lineHeight = editor2.getLineHeight();
        int n = scrollPane.getVerticalScrollBar().getMaximum();
        JScrollBar jScrollBar = scrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"getVerticalScrollBar(...)");
        int scrollHeight = n - this.getExtent(jScrollBar);
        int textHeight = scrollHeight + editorHeight;
        int scrollOffset = editor2.getSettings().getVerticalScrollOffset();
        int scrollJump = editor2.getSettings().getVerticalScrollJump();
        int offsetTopBound = this.addVerticalOffsetToPosition(editor2, -scrollOffset, targetLocation);
        int offsetBottomBound = this.addVerticalOffsetToPosition(editor2, scrollOffset, targetLocation) + lineHeight;
        int oneThirdPosition = targetLocation.y - editorHeight / 3;
        int centerPosition = oneThirdPosition < offsetTopBound ? oneThirdPosition : targetLocation.y - Math.max(0, viewRect.height - lineHeight) / 2;
        int verticalOffset = viewRect.y;
        if (scrollType == ScrollType.CENTER) {
            verticalOffset = centerPosition;
        } else if (scrollType == ScrollType.CENTER_UP) {
            if (viewRect.y > offsetTopBound || viewRect.y + viewRect.height < offsetBottomBound || viewRect.y > centerPosition) {
                verticalOffset = centerPosition;
            }
        } else if (scrollType == ScrollType.CENTER_DOWN) {
            if (viewRect.y > offsetTopBound || viewRect.y + viewRect.height < offsetBottomBound || viewRect.y < centerPosition) {
                verticalOffset = centerPosition;
            }
        } else if (scrollType == ScrollType.RELATIVE) {
            if (offsetBottomBound - offsetTopBound > editorHeight) {
                verticalOffset = centerPosition;
            } else if (viewRect.y + viewRect.height < offsetBottomBound) {
                int bottomAfterScrollJump = Math.min(this.getBottommostLocation(targetLocation, textHeight, editorHeight, offsetTopBound), this.addVerticalOffsetToPosition(editor2, scrollJump, new Point(viewRect.x, viewRect.y + viewRect.height)));
                verticalOffset = Math.max(offsetBottomBound - viewRect.height, bottomAfterScrollJump - viewRect.height);
            } else if (viewRect.y > offsetTopBound) {
                int topAfterScrollJump = Math.max(this.getTopmostLocation(targetLocation, editorHeight, offsetBottomBound), this.addVerticalOffsetToPosition(editor2, -scrollJump, new Point(viewRect.x, viewRect.y)));
                verticalOffset = Math.min(offsetTopBound, topAfterScrollJump);
            }
        } else if (scrollType == ScrollType.MAKE_VISIBLE && (viewRect.y > offsetTopBound || viewRect.y + viewRect.height < offsetBottomBound)) {
            verticalOffset = centerPosition;
        }
        verticalOffset = Math.max(0, verticalOffset);
        verticalOffset = Math.min(scrollHeight, verticalOffset);
        return verticalOffset;
    }

    private final int addVerticalOffsetToPosition(Editor editor2, int scrollOffset, Point point) {
        int n;
        boolean isUseSoftWraps = editor2.getSettings().isUseSoftWraps();
        if (scrollOffset > 0) {
            int lastVisualLine = this.getLastVisualLine(editor2, point, isUseSoftWraps);
            int bottomLine = lastVisualLine + scrollOffset;
            n = editor2.visualLineToY(bottomLine);
        } else if (scrollOffset < 0) {
            int topVisualLine = this.getFirstVisualLine(editor2, point, isUseSoftWraps);
            int topLineWithOffset = Math.max(0, topVisualLine + scrollOffset);
            topLineWithOffset = this.getFirstVisualLine(editor2, new VisualPosition(topLineWithOffset, 0), isUseSoftWraps);
            n = editor2.visualLineToY(topLineWithOffset);
        } else {
            n = point.y;
        }
        return n;
    }

    private final int getLastVisualLine(Editor editor2, Point point, boolean isUseSoftWraps) {
        if (isUseSoftWraps) {
            LogicalPosition logicalPosition = editor2.xyToLogicalPosition(point);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            int lineCount = editor2.getDocument().getLineCount();
            if (logicalPosition2.line < lineCount) {
                int endOffset = editor2.getDocument().getLineEndOffset(logicalPosition2.line);
                return editor2.offsetToVisualPosition((int)endOffset).line;
            }
        }
        return editor2.yToVisualLine(point.y);
    }

    private final int getFirstVisualLine(Editor editor2, Point point, boolean isUseSoftWraps) {
        int n;
        if (isUseSoftWraps) {
            int logicalLine = editor2.xyToLogicalPosition((Point)point).line;
            n = editor2.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0)).line;
        } else {
            n = editor2.yToVisualLine(point.y);
        }
        return n;
    }

    private final int getFirstVisualLine(Editor editor2, VisualPosition visualPosition, boolean isUseSoftWraps) {
        int n;
        if (isUseSoftWraps) {
            LogicalPosition logicalPosition = editor2.visualToLogicalPosition(visualPosition);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"visualToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            n = editor2.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalPosition2.line, (int)0)).line;
        } else {
            n = visualPosition.line;
        }
        return n;
    }

    private final int getExtent(JScrollBar $this$getExtent) {
        BoundedRangeModel boundedRangeModel = $this$getExtent.getModel();
        return boundedRangeModel != null ? boundedRangeModel.getExtent() : 0;
    }
}

