/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ArrowPainter;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.util.Computable;
import java.awt.Graphics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ArrowSoftWrapPainter
implements SoftWrapPainter {
    private final HeightProvider myHeightProvider = new HeightProvider();
    private final Editor myEditor;
    private final ArrowPainter myArrowPainter;
    private int myMinWidth = -1;

    public ArrowSoftWrapPainter(Editor editor2) {
        this.myEditor = editor2;
        this.myArrowPainter = new ArrowPainter(ColorProvider.byColor(this.myEditor.getColorsScheme().getDefaultForeground()), new WidthProvider(), this.myHeightProvider);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        int end;
        int start2;
        if (g == null) {
            ArrowSoftWrapPainter.$$$reportNull$$$0(0);
        }
        if (drawingType == null) {
            ArrowSoftWrapPainter.$$$reportNull$$$0(1);
        }
        this.myHeightProvider.myHeight = lineHeight / 2;
        int result2 = switch (drawingType) {
            case SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED -> {
                start2 = x;
                end = this.myEditor.getScrollingModel().getVisibleArea().width;
                yield end - start2;
            }
            case SoftWrapDrawingType.AFTER_SOFT_WRAP -> {
                start2 = 0;
                end = x;
                yield 0;
            }
            default -> throw new IllegalStateException("Soft wrap arrow painting is not set up for drawing type " + String.valueOf((Object)drawingType));
        };
        this.myArrowPainter.paint(g, y + lineHeight - g.getFontMetrics().getDescent(), start2, end);
        return result2;
    }

    @Override
    public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            ArrowSoftWrapPainter.$$$reportNull$$$0(2);
        }
        if (drawingType == null) {
            ArrowSoftWrapPainter.$$$reportNull$$$0(3);
        }
        return switch (drawingType) {
            default -> throw new MatchException(null, null);
            case SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED -> this.myEditor.getScrollingModel().getVisibleArea().width - x;
            case SoftWrapDrawingType.AFTER_SOFT_WRAP -> 0;
        };
    }

    @Override
    public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            ArrowSoftWrapPainter.$$$reportNull$$$0(4);
        }
        if (this.myMinWidth < 0) {
            this.myMinWidth = EditorUtil.charWidth('a', 0, this.myEditor);
        }
        return this.myMinWidth;
    }

    @Override
    public boolean canUse() {
        return true;
    }

    @Override
    public void reinit() {
        this.myMinWidth = -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDrawingHorizontalOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinDrawingWidth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HeightProvider
    implements Computable<Integer> {
        public int myHeight;

        private HeightProvider() {
        }

        public Integer compute() {
            return this.myHeight;
        }
    }

    private final class WidthProvider
    implements Computable<Integer> {
        private WidthProvider() {
        }

        public Integer compute() {
            return EditorUtil.getSpaceWidth(0, ArrowSoftWrapPainter.this.myEditor);
        }
    }
}

