/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.view.IterationState;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WrapElementIterator {
    protected final Document myDocument;
    protected final CharSequence myText;
    private final IterationState myIterationState;
    private int myElementStartOffset;
    private int myElementEndOffset;
    private boolean myLineBreak;
    private int myCodePoint;
    private int myLogicalLine;

    public WrapElementIterator(EditorEx editor2, int startOffset, int endOffset) {
        this.myDocument = editor2.getDocument();
        this.myText = this.myDocument.getImmutableCharSequence();
        this.myIterationState = new IterationState(editor2, startOffset, endOffset, null, false, true, true, false);
        this.myLogicalLine = this.myDocument.getLineNumber(startOffset);
        this.setElementOffsets();
    }

    public boolean atEnd() {
        return this.myIterationState.atEnd();
    }

    public void advance() {
        if (this.myLineBreak) {
            ++this.myLogicalLine;
        } else if (this.isFoldRegion()) {
            this.myLogicalLine = this.myDocument.getLineNumber(this.getElementEndOffset());
        }
        if (this.myElementEndOffset < this.myIterationState.getEndOffset()) {
            this.myElementStartOffset = this.myElementEndOffset;
            this.setCharElement();
        } else {
            this.myIterationState.advance();
            this.setElementOffsets();
        }
    }

    private void setElementOffsets() {
        if (this.myIterationState.atEnd()) {
            return;
        }
        this.myElementStartOffset = this.myIterationState.getStartOffset();
        if (this.myIterationState.getCurrentFold() == null) {
            this.setCharElement();
        } else {
            this.myElementEndOffset = this.myIterationState.getEndOffset();
            this.myLineBreak = false;
        }
    }

    private void setCharElement() {
        this.myElementEndOffset = Character.offsetByCodePoints(this.myText, this.myElementStartOffset, 1);
        this.myCodePoint = Character.codePointAt(this.myText, this.myElementStartOffset);
        this.myLineBreak = false;
        if (this.myCodePoint == 10) {
            this.myLineBreak = true;
        } else if (this.myCodePoint == 13) {
            char secondChar;
            char c = secondChar = this.myElementEndOffset < this.myText.length() ? this.myText.charAt(this.myElementEndOffset) : (char)'\u0000';
            if (secondChar != '\n') {
                this.myLineBreak = true;
            } else if (this.myElementEndOffset < this.myIterationState.getEndOffset()) {
                this.myLineBreak = true;
                ++this.myElementEndOffset;
            }
        }
    }

    public void retreat(int offset) {
        if (offset >= this.myElementStartOffset) {
            return;
        }
        if (offset >= this.myIterationState.getStartOffset()) {
            this.myElementStartOffset = offset;
            this.setCharElement();
        } else {
            this.myIterationState.retreat(offset);
            this.setElementOffsets();
        }
    }

    public int getElementStartOffset() {
        return this.myElementStartOffset;
    }

    public int getElementEndOffset() {
        return this.myElementEndOffset;
    }

    public boolean isLineBreak() {
        return this.myLineBreak;
    }

    public FoldRegion getCurrentFold() {
        return this.myIterationState.getCurrentFold();
    }

    public boolean isFoldRegion() {
        return this.getCurrentFold() != null;
    }

    public int getCodePoint() {
        return this.myCodePoint;
    }

    public boolean isWhitespace() {
        return !this.isFoldRegion() && (this.myCodePoint == 32 || this.myCodePoint == 9);
    }

    public int getLogicalLine() {
        return this.myLogicalLine;
    }

    public boolean nextIsFoldRegion() {
        return this.myElementEndOffset == this.myIterationState.getEndOffset() && this.myIterationState.nextIsFoldRegion();
    }

    @JdkConstants.FontStyle
    public int getFontStyle() {
        return this.myIterationState.getMergedAttributes().getFontType();
    }
}

