/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesLanguageSupport;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "supportedLanguages", "", "Lcom/intellij/lang/Language;", "rwLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "supportedLang", "lang", "updateLanguages", "", "subscribeProviderChanges", "subscribeFileTypeChanges", "subscribePluginChanges", "dispose", "intellij.platform.ide.impl"})
public final class StickyLinesLanguageSupport
implements Disposable {
    @NotNull
    private final Set<Language> supportedLanguages;
    @NotNull
    private final ReentrantReadWriteLock rwLock;

    public StickyLinesLanguageSupport(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.supportedLanguages = new LinkedHashSet();
        this.rwLock = new ReentrantReadWriteLock();
        this.updateLanguages();
        this.subscribeProviderChanges();
        this.subscribeFileTypeChanges(project2);
        this.subscribePluginChanges(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Language supportedLang(@NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            for (Language supported = lang; supported != null; supported = supported.getBaseLanguage()) {
                if (!this.supportedLanguages.contains(supported)) continue;
                Language language = supported;
                return language;
            }
            Language language = lang;
            return language;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateLanguages() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.supportedLanguages.clear();
            for (BreadcrumbsProvider provider : BreadcrumbsProvider.EP_NAME.getExtensionList()) {
                Collection collection = this.supportedLanguages;
                Language[] languageArray = provider.getLanguages();
                Intrinsics.checkNotNullExpressionValue((Object)languageArray, (String)"getLanguages(...)");
                CollectionsKt.addAll((Collection)collection, (Object[])languageArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void subscribeProviderChanges() {
        BreadcrumbsProvider.EP_NAME.addChangeListener(() -> StickyLinesLanguageSupport.subscribeProviderChanges$lambda$0(this), (Disposable)this);
    }

    private final void subscribeFileTypeChanges(Project project2) {
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)this);
        Topic topic = FileTypeManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new FileTypeListener(this){
            final /* synthetic */ StickyLinesLanguageSupport this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileTypesChanged(FileTypeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                StickyLinesLanguageSupport.access$updateLanguages(this.this$0);
            }
        });
    }

    private final void subscribePluginChanges(Project project2) {
        project2.getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(this){
            final /* synthetic */ StickyLinesLanguageSupport this$0;
            {
                this.this$0 = $receiver;
            }

            public void pluginLoaded(IdeaPluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                StickyLinesLanguageSupport.access$updateLanguages(this.this$0);
            }

            public void pluginUnloaded(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                StickyLinesLanguageSupport.access$updateLanguages(this.this$0);
            }
        });
    }

    public void dispose() {
    }

    private static final void subscribeProviderChanges$lambda$0(StickyLinesLanguageSupport this$0) {
        this$0.updateLanguages();
    }

    public static final /* synthetic */ void access$updateLanguages(StickyLinesLanguageSupport $this) {
        $this.updateLanguages();
    }
}

