/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.stickyLines.StickyLine;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesCollector;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StickyLinesModelImpl
implements StickyLinesModel {
    private static final Logger LOG = Logger.getInstance(StickyLinesModelImpl.class);
    private static final Key<StickyLinesModel.SourceID> STICKY_LINE_SOURCE = Key.create((String)"editor.sticky.lines.source");
    private static final Key<StickyLinesModelImpl> STICKY_LINES_MODEL_KEY = Key.create((String)"editor.sticky.lines.model");
    private static final Key<StickyLineImpl> STICKY_LINE_IMPL_KEY = Key.create((String)"editor.sticky.line.impl");
    private static final String STICKY_LINE_MARKER = "STICKY_LINE_MARKER";
    private static final TextAttributesKey STICKY_LINE_ATTRIBUTE = TextAttributesKey.createTextAttributesKey((String)"STICKY_LINE_MARKER");
    private final MarkupModelEx myMarkupModel;
    private final List<StickyLinesModel.Listener> myListeners;
    private boolean myIsCleared;

    public static boolean isStickyLine(@NotNull RangeHighlighter highlighter) {
        TextAttributesKey key;
        if (highlighter == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(0);
        }
        return (key = highlighter.getTextAttributesKey()) != null && STICKY_LINE_MARKER.equals(key.getExternalName());
    }

    public static void skipInAllEditors(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(1);
        }
        highlighter.setEditorFilter(StickyLinesModelImpl::alwaysFalsePredicate);
    }

    @Nullable
    static StickyLinesModelImpl getModel(@NotNull Project project2, @NotNull Document document2) {
        if (project2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(2);
        }
        if (document2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(3);
        }
        if (project2.isDisposed()) {
            String editors = StickyLinesModelImpl.editorsAsString(document2);
            LOG.error("______________________________________________________________________________________\ngetting sticky lines model when project is already disposed\ndisposed project: %s\neditors:\n%s\n______________________________________________________________________________________\n".formatted(project2, editors), new Throwable());
            return null;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document2, (Project)project2, (boolean)false);
        if (markupModel == null) {
            String editors = StickyLinesModelImpl.editorsAsString(document2);
            LOG.warn("______________________________________________________________________________________\ngetting sticky lines model when markup model is not created\neditors:\n%s\n______________________________________________________________________________________\n".formatted(editors), new Throwable());
            return null;
        }
        return StickyLinesModelImpl.getModel(markupModel);
    }

    @NotNull
    static StickyLinesModelImpl getModel(@NotNull MarkupModel markupModel) {
        StickyLinesModelImpl stickyModel;
        if (markupModel == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(4);
        }
        if ((stickyModel = (StickyLinesModelImpl)markupModel.getUserData(STICKY_LINES_MODEL_KEY)) == null) {
            stickyModel = new StickyLinesModelImpl((MarkupModelEx)markupModel);
            markupModel.putUserData(STICKY_LINES_MODEL_KEY, (Object)stickyModel);
        }
        StickyLinesModelImpl stickyLinesModelImpl = stickyModel;
        if (stickyLinesModelImpl == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(5);
        }
        return stickyLinesModelImpl;
    }

    private StickyLinesModelImpl(MarkupModelEx markupModel) {
        this.myMarkupModel = markupModel;
        this.myListeners = new ArrayList<StickyLinesModel.Listener>();
        this.myIsCleared = false;
    }

    @Override
    @NotNull
    public StickyLine addStickyLine(@NotNull StickyLinesModel.SourceID source, int startOffset, int endOffset, @Nullable String debugText) {
        if (source == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(6);
        }
        if (startOffset >= endOffset) {
            throw new IllegalArgumentException(String.format("sticky line endOffset %s should be less than startOffset %s", startOffset, endOffset));
        }
        RangeHighlighter highlighter = this.myMarkupModel.addRangeHighlighter(STICKY_LINE_ATTRIBUTE, startOffset, endOffset, 0, HighlighterTargetArea.EXACT_RANGE);
        StickyLineImpl stickyLine = new StickyLineImpl(highlighter.getDocument(), (RangeMarker)highlighter, debugText);
        highlighter.putUserData(STICKY_LINE_IMPL_KEY, (Object)stickyLine);
        highlighter.putUserData(STICKY_LINE_SOURCE, (Object)source);
        StickyLinesModelImpl.skipInAllEditors(highlighter);
        this.myIsCleared = false;
        StickyLineImpl stickyLineImpl = stickyLine;
        if (stickyLineImpl == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(7);
        }
        return stickyLineImpl;
    }

    @Override
    public void removeStickyLine(@NotNull StickyLine stickyLine) {
        if (stickyLine == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(8);
        }
        RangeMarker rangeMarker = ((StickyLineImpl)stickyLine).rangeMarker();
        this.myMarkupModel.removeHighlighter((RangeHighlighter)rangeMarker);
    }

    @Override
    public void processStickyLines(int startOffset, int endOffset, @NotNull @NotNull Processor<? super @NotNull StickyLine> processor2) {
        if (processor2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(9);
        }
        this.processStickyLines(null, startOffset, endOffset, processor2);
    }

    @Override
    public void processStickyLines(@NotNull StickyLinesModel.SourceID source, @NotNull @NotNull Processor<? super @NotNull StickyLine> processor2) {
        if (source == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(11);
        }
        this.processStickyLines(source, 0, this.myMarkupModel.getDocument().getTextLength(), processor2);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull StickyLine> getAllStickyLines() {
        ArrayList<StickyLine> stickyLines = new ArrayList<StickyLine>();
        this.processStickyLines(0, this.myMarkupModel.getDocument().getTextLength(), (Processor<? super StickyLine>)((Processor)line -> {
            stickyLines.add((StickyLine)line);
            return true;
        }));
        ArrayList<StickyLine> arrayList = stickyLines;
        if (arrayList == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    public void addListener(@NotNull StickyLinesModel.Listener listener2) {
        if (listener2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(13);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull StickyLinesModel.Listener listener2) {
        if (listener2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(14);
        }
        this.myListeners.remove(listener2);
    }

    @Override
    public void notifyLinesUpdate() {
        for (StickyLinesModel.Listener listener2 : this.myListeners) {
            listener2.linesUpdated();
        }
    }

    @Override
    public void removeAllStickyLines(@Nullable Project project2) {
        if (this.myIsCleared) {
            return;
        }
        for (StickyLine line : this.getAllStickyLines()) {
            this.removeStickyLine(line);
        }
        if (project2 != null) {
            this.restartStickyLinesPass(project2);
        }
        this.myIsCleared = true;
    }

    private void processStickyLines(@Nullable StickyLinesModel.SourceID source, int startOffset, int endOffset, @NotNull Processor<? super StickyLine> processor2) {
        if (processor2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(15);
        }
        this.myMarkupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, highlighter -> {
            if (STICKY_LINE_ATTRIBUTE.equals((Object)highlighter.getTextAttributesKey()) && StickyLinesModelImpl.isSuitableSource(highlighter, source)) {
                StickyLineImpl stickyLine = (StickyLineImpl)highlighter.getUserData(STICKY_LINE_IMPL_KEY);
                if (stickyLine == null) {
                    stickyLine = new StickyLineImpl(highlighter.getDocument(), (RangeMarker)highlighter, "StickyZombie");
                }
                return processor2.process((Object)stickyLine);
            }
            return true;
        });
    }

    private static boolean isSuitableSource(RangeHighlighterEx highlighter, @Nullable StickyLinesModel.SourceID source) {
        return source == null || source.equals(highlighter.getUserData(STICKY_LINE_SOURCE));
    }

    private static boolean alwaysFalsePredicate(@NotNull Editor editor2) {
        if (editor2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(16);
        }
        return false;
    }

    private void restartStickyLinesPass(@NotNull Project project2) {
        if (project2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
            if (!project2.isDisposed()) {
                StickyLinesCollector collector = new StickyLinesCollector(project2, this.myMarkupModel.getDocument());
                collector.forceCollectPass();
            }
        }));
    }

    @NotNull
    private static String editorsAsString(@NotNull Document document2) {
        if (document2 == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(18);
        }
        String string = Arrays.stream(EditorFactory.getInstance().getEditors(document2)).map(editor2 -> editor2.toString() + "\n" + String.valueOf(editor2.getProject())).collect(Collectors.joining("\n"));
        if (string == null) {
            StickyLinesModelImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 12, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/stickyLines/StickyLinesModelImpl";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stickyLine";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/stickyLines/StickyLinesModelImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addStickyLine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStickyLines";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "editorsAsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isStickyLine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipInAllEditors";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addStickyLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeStickyLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processStickyLines";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "alwaysFalsePredicate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "restartStickyLinesPass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "editorsAsString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 12, 19 -> new IllegalStateException(string);
        };
    }

    private record StickyLineImpl(@NotNull Document document, @NotNull RangeMarker rangeMarker, @Nullable String debugText) implements StickyLine
    {
        @NotNull
        private final Document document;
        @NotNull
        private final RangeMarker rangeMarker;

        private StickyLineImpl(@NotNull Document document2, @NotNull RangeMarker rangeMarker, @Nullable String debugText) {
            if (document2 == null) {
                StickyLineImpl.$$$reportNull$$$0(0);
            }
            if (rangeMarker == null) {
                StickyLineImpl.$$$reportNull$$$0(1);
            }
        }

        @Override
        public int primaryLine() {
            return this.document.getLineNumber(this.rangeMarker.getStartOffset());
        }

        @Override
        public int scopeLine() {
            return this.document.getLineNumber(this.rangeMarker.getEndOffset());
        }

        @Override
        public int navigateOffset() {
            return this.rangeMarker.getStartOffset();
        }

        @Override
        @NotNull
        public TextRange textRange() {
            TextRange textRange = this.rangeMarker.getTextRange();
            if (textRange == null) {
                StickyLineImpl.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StickyLineImpl)) {
                return false;
            }
            StickyLineImpl impl = (StickyLineImpl)other;
            return this.textRange().equals((Object)impl.textRange());
        }

        @Override
        public int hashCode() {
            return this.textRange().hashCode();
        }

        @Override
        public int compareTo(@NotNull StickyLine other) {
            if (other == null) {
                StickyLineImpl.$$$reportNull$$$0(3);
            }
            TextRange range = this.textRange();
            TextRange otherRange = other.textRange();
            int compare = Integer.compare(range.getStartOffset(), otherRange.getStartOffset());
            if (compare != 0) {
                return compare;
            }
            return Integer.compare(otherRange.getEndOffset(), range.getEndOffset());
        }

        @Override
        @NotNull
        public String toString() {
            String prefix = this.debugText == null ? "" : this.debugText;
            String string = prefix + "(" + this.primaryLine() + ", " + this.scopeLine() + ")";
            if (string == null) {
                StickyLineImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Document document() {
            Document document2 = this.document;
            if (document2 == null) {
                StickyLineImpl.$$$reportNull$$$0(5);
            }
            return document2;
        }

        @NotNull
        public RangeMarker rangeMarker() {
            RangeMarker rangeMarker = this.rangeMarker;
            if (rangeMarker == null) {
                StickyLineImpl.$$$reportNull$$$0(6);
            }
            return rangeMarker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarker";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/stickyLines/StickyLinesModelImpl$StickyLineImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/stickyLines/StickyLinesModelImpl$StickyLineImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "textRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "document";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rangeMarker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

