/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesLanguageSupport;
import com.intellij.openapi.editor.impl.stickyLines.actions.StickyLinesAbstractAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/actions/StickyLinesDisableForLangAction;", "Lcom/intellij/openapi/editor/impl/stickyLines/actions/StickyLinesAbstractAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "stickyLinesLanguage", "Lcom/intellij/lang/Language;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nStickyLinesDisableForLangAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StickyLinesDisableForLangAction.kt\ncom/intellij/openapi/editor/impl/stickyLines/actions/StickyLinesDisableForLangAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,42:1\n30#2,2:43\n*S KotlinDebug\n*F\n+ 1 StickyLinesDisableForLangAction.kt\ncom/intellij/openapi/editor/impl/stickyLines/actions/StickyLinesDisableForLangAction\n*L\n36#1:43,2\n*E\n"})
public final class StickyLinesDisableForLangAction
extends StickyLinesAbstractAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Language language = this.stickyLinesLanguage(e);
        if (language != null) {
            Object[] objectArray = new Object[]{language.getDisplayName()};
            e.getPresentation().setText(ActionsBundle.message((String)"action.EditorStickyLinesDisableForLang.for.lang.text", (Object[])objectArray));
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Language language = this.stickyLinesLanguage(e);
        if (language != null) {
            EditorSettingsExternalizable.getInstance().setStickyLinesShownFor(language.getID(), false);
        }
    }

    private final Language stickyLinesLanguage(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null && EditorSettingsExternalizable.getInstance().areStickyLinesShown()) {
            Language psiFileLang;
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Language language = psiFile != null && (psiFile = psiFile.getViewProvider()) != null ? psiFile.getBaseLanguage() : (psiFileLang = null);
            if (psiFileLang != null) {
                ComponentManager $this$service$iv = (ComponentManager)project2;
                boolean $i$f$service = false;
                Class<StickyLinesLanguageSupport> serviceClass$iv = StickyLinesLanguageSupport.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return ((StickyLinesLanguageSupport)object).supportedLang(psiFileLang);
            }
        }
        return null;
    }
}

