/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.SpecialCharacterFragment;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import org.intellij.lang.annotations.JdkConstants;

final class CharWidthCache {
    private static final int CACHE_SIZE_LIMIT = 1024;
    private static final float SHIFT = 1.0f;
    private final EditorView myView;
    private final Int2FloatOpenHashMap myCache = new Int2FloatOpenHashMap();

    CharWidthCache(EditorView view2) {
        this.myView = view2;
    }

    void clear() {
        this.myCache.clear();
    }

    float getCodePointWidth(int codePoint, @JdkConstants.FontStyle int fontStyle) {
        int key = CharWidthCache.createKey(codePoint, fontStyle);
        float width = this.getCachedValue(key);
        if (width < 0.0f) {
            width = this.calcValue(codePoint, fontStyle);
            this.saveInCache(key, width);
        }
        return width;
    }

    private float calcValue(int codePoint, int fontStyle) {
        SpecialCharacterFragment specialCharacterFragment;
        EditorImpl editor2 = this.myView.getEditor();
        if (editor2.getSettings().isShowingSpecialChars() && (specialCharacterFragment = SpecialCharacterFragment.create(this.myView, codePoint, null, 0)) != null) {
            return specialCharacterFragment.visualColumnToX(0.0f, 1);
        }
        return ComplementaryFontsRegistry.getFontAbleToDisplay(codePoint, fontStyle, editor2.getColorsScheme().getFontPreferences(), this.myView.getFontRenderContext()).charWidth2D(codePoint);
    }

    private float getCachedValue(int key) {
        return this.myCache.get(key) - 1.0f;
    }

    private void saveInCache(int key, float value) {
        if (this.myCache.size() >= 1024) {
            this.myCache.clear();
        }
        this.myCache.put(key, value + 1.0f);
    }

    private static int createKey(int codePoint, @JdkConstants.FontStyle int fontStyle) {
        return fontStyle << 21 | codePoint;
    }
}

