/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.CharacterGrid;
import com.intellij.openapi.editor.impl.view.CharacterGridIterator;
import com.intellij.openapi.editor.impl.view.CharacterGridIteratorImpl;
import com.intellij.openapi.editor.impl.view.DoubleWidthCharacterStrategy;
import com.intellij.openapi.editor.impl.view.EditorView;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/editor/impl/view/CharacterGridImpl;", "Lcom/intellij/openapi/editor/impl/view/CharacterGrid;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "view", "Lcom/intellij/openapi/editor/impl/view/EditorView;", "getView", "()Lcom/intellij/openapi/editor/impl/view/EditorView;", "columnSpacing", "", "getColumnSpacing", "()F", "size", "Ljava/awt/Dimension;", "getSize", "()Ljava/awt/Dimension;", "charWidth", "getCharWidth", "columns", "", "getColumns", "()I", "rows", "getRows", "doubleWidthCharacterStrategy", "Lcom/intellij/openapi/editor/impl/view/DoubleWidthCharacterStrategy;", "getDoubleWidthCharacterStrategy", "()Lcom/intellij/openapi/editor/impl/view/DoubleWidthCharacterStrategy;", "setDoubleWidthCharacterStrategy", "(Lcom/intellij/openapi/editor/impl/view/DoubleWidthCharacterStrategy;)V", "codePointWidth", "codePoint", "iterator", "Lcom/intellij/openapi/editor/impl/view/CharacterGridIterator;", "startOffset", "endOffset", "intellij.platform.ide.impl"})
public final class CharacterGridImpl
implements CharacterGrid {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private DoubleWidthCharacterStrategy doubleWidthCharacterStrategy;

    public CharacterGridImpl(@NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.doubleWidthCharacterStrategy = CharacterGridImpl::doubleWidthCharacterStrategy$lambda$0;
    }

    private final EditorView getView() {
        EditorView editorView = this.editor.getView();
        Intrinsics.checkNotNullExpressionValue((Object)editorView, (String)"getView(...)");
        return editorView;
    }

    private final float getColumnSpacing() {
        Float f = this.editor.getSettings().getCharacterGridWidthMultiplier();
        if (f == null) {
            boolean bl = false;
            String string = "The editor must be in the grid mode to create an instance of a character grid";
            throw new IllegalStateException(string.toString());
        }
        return ((Number)f).floatValue();
    }

    private final Dimension getSize() {
        Dimension dimension = this.editor.getScrollingModel().getVisibleArea().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        return dimension;
    }

    @Override
    public float getCharWidth() {
        return this.getView().getMaxCharWidth() * this.getColumnSpacing();
    }

    @Override
    public int getColumns() {
        int width = this.getSize().width;
        return width > 0 ? (int)((float)width / this.getCharWidth()) : 0;
    }

    @Override
    public int getRows() {
        int lineHeight = this.getView().getLineHeight();
        int height = this.getSize().height;
        return height > 0 ? (int)((float)height / (float)lineHeight) : 0;
    }

    @Override
    @NotNull
    public DoubleWidthCharacterStrategy getDoubleWidthCharacterStrategy() {
        return this.doubleWidthCharacterStrategy;
    }

    @Override
    public void setDoubleWidthCharacterStrategy(@NotNull DoubleWidthCharacterStrategy doubleWidthCharacterStrategy) {
        Intrinsics.checkNotNullParameter((Object)doubleWidthCharacterStrategy, (String)"<set-?>");
        this.doubleWidthCharacterStrategy = doubleWidthCharacterStrategy;
    }

    @Override
    public float codePointWidth(int codePoint) {
        return (this.getDoubleWidthCharacterStrategy().isDoubleWidth(codePoint) ? 2.0f : 1.0f) * this.getCharWidth();
    }

    @Override
    @NotNull
    public CharacterGridIterator iterator(int startOffset, int endOffset) {
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        return new CharacterGridIteratorImpl(charSequence, this.getDoubleWidthCharacterStrategy(), startOffset, endOffset);
    }

    private static final boolean doubleWidthCharacterStrategy$lambda$0(int it) {
        return false;
    }
}

