/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.impl.view.CaretDataInView;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

final class LineWhitespacePaintingStrategy {
    private static final char IDEOGRAPHIC_SPACE = '\u3000';
    private static final String WHITESPACE_CHARS = " \t\u3000";
    private final boolean whitespaceShown;
    private final boolean leadingWhitespaceShown;
    private final boolean innerWhitespaceShown;
    private final boolean trailingWhitespaceShown;
    private final boolean selectionWhitespaceShown;
    private int currentLeadingEdge;
    private int currentTrailingEdge;

    LineWhitespacePaintingStrategy(@NotNull EditorSettings settings) {
        if (settings == null) {
            LineWhitespacePaintingStrategy.$$$reportNull$$$0(0);
        }
        this.whitespaceShown = settings.isWhitespacesShown();
        this.leadingWhitespaceShown = settings.isLeadingWhitespaceShown();
        this.innerWhitespaceShown = settings.isInnerWhitespaceShown();
        this.trailingWhitespaceShown = settings.isTrailingWhitespaceShown();
        this.selectionWhitespaceShown = settings.isSelectionWhitespaceShown();
    }

    boolean showAnyWhitespace() {
        return this.whitespaceShown && (this.leadingWhitespaceShown || this.innerWhitespaceShown || this.trailingWhitespaceShown || this.selectionWhitespaceShown);
    }

    void update(CharSequence chars, int lineStart, int lineEnd) {
        if (!(!this.showAnyWhitespace() || this.leadingWhitespaceShown && this.innerWhitespaceShown && this.trailingWhitespaceShown)) {
            this.currentTrailingEdge = CharArrayUtil.shiftBackward((CharSequence)chars, (int)lineStart, (int)(lineEnd - 1), (String)WHITESPACE_CHARS) + 1;
            this.currentLeadingEdge = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (int)this.currentTrailingEdge, (String)WHITESPACE_CHARS);
        }
    }

    boolean showWhitespaceAtOffset(int offset, CaretDataInView caretData) {
        if (!this.whitespaceShown) {
            return false;
        }
        if (offset < this.currentLeadingEdge ? this.leadingWhitespaceShown : (offset >= this.currentTrailingEdge ? this.trailingWhitespaceShown : this.innerWhitespaceShown)) {
            return true;
        }
        return this.selectionWhitespaceShown && caretData != null && caretData.isOffsetInSelection(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/impl/view/LineWhitespacePaintingStrategy", "<init>"));
    }
}

