/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.SimpleTextFragment;
import java.awt.Font;
import java.util.List;

final class TextFragmentFactory {
    TextFragmentFactory() {
    }

    static void createTextFragments(List<? super LineFragment> fragments, char[] lineChars, int start2, int end, boolean isRtl, FontInfo fontInfo, EditorView view2) {
        boolean needsLayout = isRtl || fontInfo.getFont().hasLayoutAttributes();
        boolean nonLatinText = false;
        if (!needsLayout && (TextFragmentFactory.containsSurrogatePairs(lineChars, start2, end) || Font.textRequiresLayout(lineChars, start2, end))) {
            needsLayout = true;
            nonLatinText = true;
        }
        if (needsLayout) {
            int lastOffset = start2;
            if (nonLatinText || TextFragmentFactory.containsNonLatinText(lineChars, start2, end)) {
                Character.UnicodeScript lastScript = Character.UnicodeScript.COMMON;
                for (int i2 = start2; i2 < end; ++i2) {
                    Character.UnicodeScript script;
                    int c = Character.codePointAt(lineChars, i2, end);
                    if (Character.isSupplementaryCodePoint(c)) {
                        ++i2;
                    }
                    if ((script = Character.UnicodeScript.of(c)) == Character.UnicodeScript.COMMON || script == Character.UnicodeScript.INHERITED || script == Character.UnicodeScript.UNKNOWN) continue;
                    if (lastScript != script && lastScript != Character.UnicodeScript.COMMON) {
                        fragments.add(new ComplexTextFragment(lineChars, lastOffset, i2, isRtl, fontInfo, view2));
                        lastOffset = i2;
                    }
                    lastScript = script;
                }
            }
            fragments.add(new ComplexTextFragment(lineChars, lastOffset, end, isRtl, fontInfo, view2));
        } else {
            fragments.add(new SimpleTextFragment(lineChars, start2, end, fontInfo, view2));
        }
    }

    private static boolean containsSurrogatePairs(char[] chars, int start2, int end) {
        --end;
        for (int i2 = start2; i2 < end; ++i2) {
            if (!Character.isHighSurrogate(chars[i2]) || !Character.isLowSurrogate(chars[i2 + 1])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsNonLatinText(char[] chars, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (chars[i2] < '\u02ea') continue;
            return true;
        }
        return false;
    }
}

