/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.UIBundle;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileNameInputValidator
implements InputValidatorEx {
    private final FileSystem myFileSystem;

    FileNameInputValidator(@NotNull FileSystem fileSystem) {
        if (fileSystem == null) {
            FileNameInputValidator.$$$reportNull$$$0(0);
        }
        this.myFileSystem = fileSystem;
    }

    @NlsContexts.HintText
    @Nullable
    public String getErrorText(String input) {
        if ((input = input.trim()).isEmpty()) {
            return UIBundle.message((String)"file.name.validator.empty", (Object[])new Object[0]);
        }
        try {
            if (this.myFileSystem.getPath(input, new String[0]).isAbsolute()) {
                return UIBundle.message((String)"file.name.validator.absolute", (Object[])new Object[0]);
            }
        }
        catch (InvalidPathException e) {
            return UIBundle.message((String)"file.name.validator.invalid", (Object[])new Object[]{e.getMessage()});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/fileChooser/actions/FileNameInputValidator", "<init>"));
    }
}

