/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileChooser.actions.FileNameInputValidator;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.IoErrorText;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class NewFileAction
extends FileChooserAction
implements LightEditCompatible {
    NewFileAction() {
    }

    @Override
    protected void update(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        if (panel2 == null) {
            NewFileAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            NewFileAction.$$$reportNull$$$0(1);
        }
        boolean visible = e.getData(FileChooserKeys.NEW_FILE_TYPE) != null;
        Path directory = panel2.currentDirectory();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && directory != null && !directory.getFileSystem().isReadOnly());
    }

    @Override
    protected void actionPerformed(@NotNull FileChooserPanel panel2, final @NotNull AnActionEvent e) {
        String input;
        if (panel2 == null) {
            NewFileAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            NewFileAction.$$$reportNull$$$0(3);
        }
        final Path directory = panel2.currentDirectory();
        FileType fileType2 = (FileType)e.getData(FileChooserKeys.NEW_FILE_TYPE);
        if (fileType2 == null || directory == null || directory.getFileSystem().isReadOnly()) {
            return;
        }
        String title2 = UIBundle.message((String)"file.chooser.new.file.title", (Object[])new Object[0]);
        String prompt = UIBundle.message((String)"file.chooser.new.file.prompt", (Object[])new Object[0]);
        Object initial = "newFile." + fileType2.getDefaultExtension();
        TextRange selection = new TextRange(0, 7);
        FileNameInputValidator validator2 = new FileNameInputValidator(directory.getFileSystem());
        while ((input = MessagesService.getInstance().showInputDialog(null, (Component)panel2.getComponent(), prompt, title2, null, (String)initial, (InputValidator)validator2, selection, null)) != null) {
            final String name2 = input.trim();
            initial = name2;
            selection = null;
            String progress = UIBundle.message((String)"file.chooser.creating.progress", (Object[])new Object[]{name2});
            try {
                panel2.reloadAfter(() -> (Path)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Path, IOException>(this, e.getProject(), panel2.getComponent(), progress, true){

                    protected Path compute(@NotNull ProgressIndicator indicator2) throws IOException {
                        if (indicator2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator2.setIndeterminate(true);
                        Path newFile = directory.resolve(name2);
                        NioFiles.createDirectories((Path)newFile.getParent());
                        String content2 = Objects.requireNonNullElse((String)e.getData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT), "");
                        Files.writeString(newFile, (CharSequence)content2, StandardOpenOption.CREATE_NEW);
                        return newFile;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileChooser/actions/NewFileAction$1", "compute"));
                    }
                }));
                break;
            }
            catch (IOException | InvalidPathException ex) {
                Messages.showErrorDialog((Component)panel2.getComponent(), (String)IoErrorText.message((Throwable)ex), (String)CommonBundle.getErrorTitle());
            }
        }
    }

    @Override
    protected void update(@NotNull FileSystemTree fileSystemTree, @NotNull AnActionEvent e) {
        if (fileSystemTree == null) {
            NewFileAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            NewFileAction.$$$reportNull$$$0(5);
        }
        Presentation presentation2 = e.getPresentation();
        FileType fileType2 = (FileType)e.getData(FileChooserKeys.NEW_FILE_TYPE);
        String initialContent = (String)e.getData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT);
        if (fileType2 != null && initialContent != null) {
            presentation2.setVisible(true);
            VirtualFile selectedFile = fileSystemTree.getNewFileParent();
            presentation2.setEnabled(selectedFile != null && selectedFile.isDirectory());
            presentation2.setIcon(LayeredIcon.create((Icon)fileType2.getIcon(), (Icon)AllIcons.Actions.New));
        } else {
            presentation2.setEnabledAndVisible(false);
        }
    }

    @Override
    protected void actionPerformed(@NotNull FileSystemTree fileSystemTree, @NotNull AnActionEvent e) {
        if (fileSystemTree == null) {
            NewFileAction.$$$reportNull$$$0(6);
        }
        if (e == null) {
            NewFileAction.$$$reportNull$$$0(7);
        }
        FileType fileType2 = (FileType)e.getData(FileChooserKeys.NEW_FILE_TYPE);
        String initialContent = (String)e.getData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT);
        if (fileType2 == null || initialContent == null) {
            return;
        }
        VirtualFile file2 = fileSystemTree.getNewFileParent();
        if (file2 == null || !file2.isDirectory()) {
            return;
        }
        while (true) {
            String name2;
            if ((name2 = Messages.showInputDialog((String)UIBundle.message((String)"create.new.file.enter.new.file.name.prompt.text", (Object[])new Object[0]), (String)UIBundle.message((String)"new.file.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == null) {
                return;
            }
            if ((name2 = name2.strip()).isEmpty()) {
                Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.file.name.cannot.be.empty.error.message", (Object[])new Object[0]), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                continue;
            }
            Exception failReason = ((FileSystemTreeImpl)fileSystemTree).createNewFile(file2, name2, fileType2, initialContent);
            if (failReason == null) break;
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{name2}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemTree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/actions/NewFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

