/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@State(name="editorHistoryManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, getStateRequiresEdt=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 12\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u00041234B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0011J*\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020\rH\u0007J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0013J\u000e\u0010&\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0002H\u0016J\b\u0010'\u001a\u00020\u0002H\u0016J\b\u00100\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "entries", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/fileEditor/impl/HistoryEntry;", "Lkotlin/collections/ArrayList;", "removeEntry", "", "entry", "moveOnTop", "isIncludedInHistory", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpenedImpl", "fallback", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "updateHistoryEntry", "changeEntryOrderOnly", "files", "", "getFiles", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "removeAllFiles", "fileList", "", "getFileList", "()Ljava/util/List;", "hasBeenOpen", "f", "removeFile", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "provider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "getSelectedProvider", "getEntry", "trimToSize", "loadState", "state", "dispose", "Companion", "IncludeInEditorHistoryFile", "OptionallyIncluded", "MyEditorManagerListener", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorHistoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorHistoryManager.kt\ncom/intellij/openapi/fileEditor/impl/EditorHistoryManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,415:1\n1#2:416\n1#2:419\n1#2:432\n1#2:454\n1625#3:417\n1869#3:418\n1870#3:420\n1626#3:421\n1617#3,9:422\n1869#3:431\n1870#3:433\n1626#3:434\n1761#3,3:435\n543#3,6:438\n1617#3,9:444\n1869#3:453\n1870#3:455\n1626#3:456\n13#4:457\n*S KotlinDebug\n*F\n+ 1 EditorHistoryManager.kt\ncom/intellij/openapi/fileEditor/impl/EditorHistoryManager\n*L\n249#1:419\n268#1:432\n322#1:454\n249#1:417\n249#1:418\n249#1:420\n249#1:421\n268#1:422,9\n268#1:431\n268#1:433\n268#1:434\n271#1:435,3\n290#1:438,6\n322#1:444,9\n322#1:453\n322#1:455\n322#1:456\n62#1:457\n*E\n"})
public final class EditorHistoryManager
implements PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ArrayList<HistoryEntry> entries;
    @NotNull
    private static final Logger LOG;

    public EditorHistoryManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.entries = new ArrayList();
        SimpleMessageBusConnection connection = this.project.getMessageBus().simpleConnect();
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> EditorHistoryManager._init_$lambda$0(this, arg_0));
        Topic topic2 = FileEditorManagerListener.Before.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic2, (Object)new FileEditorManagerListener.Before(){

            public void beforeFileClosed(FileEditorManager source, VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                this.updateHistoryEntry(source, file2, null, false);
            }
        });
        FileEditorProvider.EP_FILE_EDITOR_PROVIDER.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionRemoved(FileEditorProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                Iterator iterator = entries.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    HistoryEntry it = (HistoryEntry)e;
                    it.onProviderRemoval(extension);
                }
            }
        }, (Disposable)this);
    }

    private final synchronized void removeEntry(HistoryEntry entry) {
        if (this.entries.remove(entry)) {
            entry.destroy();
        }
    }

    private final synchronized void moveOnTop(HistoryEntry entry) {
        this.entries.remove(entry);
        this.entries.add(entry);
    }

    private final boolean isIncludedInHistory(VirtualFile file2) {
        if (file2 instanceof OptionallyIncluded) {
            return ((OptionallyIncluded)file2).isIncludedInEditorHistory(this.project);
        }
        return VirtualFileManager.getInstance().findFileByUrl(file2.getUrl()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fileOpenedImpl(VirtualFile file2, FileEditorWithProvider fallback, FileEditorManager fileEditorManager) {
        FileEditorWithProvider selected;
        Object selected2;
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.isIncludedInHistory(file2)) {
            return;
        }
        FileEditorComposite editorComposite = fileEditorManager.getComposite(file2);
        Object list2 = null;
        Object object = editorComposite;
        if (object == null || (object = object.getAllEditorsWithProviders()) == null) {
            object = CollectionsKt.emptyList();
        }
        if ((list2 = object).isEmpty() && (list2 = CollectionsKt.listOfNotNull((Object)fallback)).isEmpty()) {
            return;
        }
        if (editorComposite instanceof EditorComposite) {
            v1 = ((EditorComposite)editorComposite).getSelectedWithProvider();
            if (v1 == null) {
                v1 = (FileEditorWithProvider)CollectionsKt.first((List)list2);
            }
        } else {
            int selectedProviderIndex;
            FileEditorManagerEx fileEditorManagerEx = fileEditorManager instanceof FileEditorManagerEx ? (FileEditorManagerEx)fileEditorManager : null;
            if (fileEditorManagerEx == null || (fileEditorManagerEx = fileEditorManagerEx.getSelectedEditorWithProvider(file2)) == null) {
                fileEditorManagerEx = fallback;
            }
            Object object2 = selected2 = fileEditorManagerEx;
            if (object2 != null) {
                Object it = object2;
                boolean bl = false;
                v4 = list2.indexOf(it);
            } else {
                v4 = selectedProviderIndex = -1;
            }
            if (selectedProviderIndex == -1) {
                LOG.error("Can't find " + (FileEditorWithProvider)selected2 + " among " + list2);
                v1 = (FileEditorWithProvider)CollectionsKt.first((List)list2);
            } else {
                v1 = selected = (FileEditorWithProvider)list2.get(selectedProviderIndex);
            }
        }
        if ((selected2 = this.getEntry(file2)) != null) {
            Object it = selected2;
            boolean bl = false;
            this.moveOnTop((HistoryEntry)it);
            return;
        }
        LinkedHashMap<FileEditorProvider, FileEditor> stateMap = new LinkedHashMap<FileEditorProvider, FileEditor>(list2.size());
        Iterator selectedProviderIndex = list2.iterator();
        while (selectedProviderIndex.hasNext()) {
            FileEditor fileEditor;
            FileEditorWithProvider item = (FileEditorWithProvider)selectedProviderIndex.next();
            FileEditor it = fileEditor = item.getFileEditor();
            boolean bl = false;
            Object object3 = it.isValid() ? fileEditor : null;
            if (object3 == null || (object3 = object3.getState(FileEditorStateLevel.FULL)) == null) continue;
            FileEditor state2 = object3;
            stateMap.put(item.getProvider(), state2);
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        VirtualFilePointer virtualFilePointer = VirtualFilePointerManager.getInstance().create(file2, disposable2, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointer, (String)"create(...)");
        VirtualFilePointer pointer = virtualFilePointer;
        boolean isPersisted = file2 instanceof OptionallyIncluded ? ((OptionallyIncluded)file2).isPersistedInEditorHistory() : true;
        Object object4 = selected.getProvider();
        boolean it = editorComposite != null && editorComposite.isPreview();
        HistoryEntry entry = new HistoryEntry(pointer, (FileEditorProvider)object4, it, isPersisted, (Map<FileEditorProvider, ? extends FileEditorState>)stateMap, disposable2);
        object4 = this;
        synchronized (object4) {
            boolean bl = false;
            this.entries.add(entry);
            this.trimToSize();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void updateHistoryEntry(@NotNull VirtualFile file2, boolean changeEntryOrderOnly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"getInstance(...)");
        this.updateHistoryEntry(fileEditorManager, file2, null, changeEntryOrderOnly);
    }

    private final void updateHistoryEntry(FileEditorManager fileEditorManager, VirtualFile file2, FileEditorWithProvider fallback, boolean changeEntryOrderOnly) {
        FileEditorWithProvider selectedEditorWithProvider;
        List list2 = null;
        boolean preview = false;
        if (fallback == null) {
            FileEditorComposite fileEditorComposite = fileEditorManager.getComposite(file2);
            if (fileEditorComposite == null) {
                return;
            }
            FileEditorComposite composite2 = fileEditorComposite;
            list2 = composite2.getAllEditorsWithProviders();
            preview = composite2.isPreview();
        } else {
            list2 = CollectionsKt.listOf((Object)fallback);
        }
        if (list2.isEmpty()) {
            return;
        }
        HistoryEntry entry = this.getEntry(file2);
        if (entry == null) {
            if (file2.isValid()) {
                this.fileOpenedImpl(file2, fallback, fileEditorManager);
            }
            return;
        }
        if (!changeEntryOrderOnly) {
            for (FileEditorWithProvider fileEditorWithProvider : CollectionsKt.reversed((Iterable)list2)) {
                FileEditorState newState;
                FileEditor editor2 = fileEditorWithProvider.component1();
                FileEditorProvider provider = fileEditorWithProvider.component2();
                if (!editor2.isValid()) continue;
                FileEditorState oldState = entry.getState(provider);
                Intrinsics.checkNotNullExpressionValue((Object)editor2.getState(FileEditorStateLevel.FULL), (String)"getState(...)");
                if (Intrinsics.areEqual((Object)newState, (Object)oldState)) continue;
                entry.putState(provider, newState);
            }
        }
        FileEditorManagerEx fileEditorManagerEx = fileEditorManager instanceof FileEditorManagerEx ? (FileEditorManagerEx)fileEditorManager : null;
        Object object = selectedEditorWithProvider = fileEditorManagerEx != null ? fileEditorManagerEx.getSelectedEditorWithProvider(file2) : null;
        if (selectedEditorWithProvider != null) {
            entry.selectedProvider = selectedEditorWithProvider.getProvider();
            if (changeEntryOrderOnly) {
                this.moveOnTop(entry);
            }
        }
        if (preview) {
            entry.isPreview = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized VirtualFile[] getFiles() {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Iterable iterable = this.entries;
        Collection destination$iv = new ArrayList(this.entries.size());
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            HistoryEntry it = (HistoryEntry)element$iv;
            boolean bl2 = false;
            if (it.getFile() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
        return virtualFileArray;
    }

    @VisibleForTesting
    public final synchronized void removeAllFiles() {
        Iterator<HistoryEntry> iterator = this.entries.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<HistoryEntry> iterator2 = iterator;
        while (iterator2.hasNext()) {
            HistoryEntry entry;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            entry.destroy();
        }
        this.entries.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<VirtualFile> getFileList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.entries;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            HistoryEntry it = (HistoryEntry)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final synchronized boolean hasBeenOpen(@NotNull VirtualFile f) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HistoryEntry it = (HistoryEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)f, (Object)it.getFile())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final synchronized void removeFile(@NotNull VirtualFile file2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            HistoryEntry historyEntry = this.getEntry(file2);
            if (historyEntry == null) break block0;
            HistoryEntry it = historyEntry;
            boolean bl = false;
            this.removeEntry(it);
        }
    }

    @Nullable
    public final FileEditorState getState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        HistoryEntry historyEntry = this.getEntry(file2);
        return historyEntry != null ? historyEntry.getState(provider) : null;
    }

    @Nullable
    public final FileEditorProvider getSelectedProvider(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HistoryEntry historyEntry = this.getEntry(file2);
        return historyEntry != null ? historyEntry.selectedProvider : null;
    }

    private final synchronized HistoryEntry getEntry(VirtualFile file2) {
        Object v0;
        block1: {
            List $this$lastOrNull$iv = this.entries;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                HistoryEntry it = (HistoryEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final synchronized void trimToSize() {
        int limit = UISettings.Companion.getInstance().getRecentFilesLimit() + 1;
        while (this.entries.size() > limit) {
            this.entries.remove(0).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void loadState(@NotNull Element state2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.removeAllFiles();
        LinkedHashMap<String, Element> fileToElement = new LinkedHashMap<String, Element>();
        for (Element e : state2.getChildren("entry")) {
            String file2 = e.getAttributeValue("file");
            fileToElement.remove(file2);
            fileToElement.put(file2, e);
        }
        if (PlatformUtils.isJetBrainsClient()) {
            return;
        }
        Collection collection = fileToElement.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AutoCloseable it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element element = (Element)element$iv$iv;
            boolean bl2 = false;
            try {
                HistoryEntry historyEntry;
                object = (AutoCloseable)SlowOperations.knownIssue((String)"IDEA-333919, EA-831462");
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)object;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)element);
                    historyEntry = HistoryEntry.Companion.createHeavy(this.project, element);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
                object = historyEntry;
            }
            catch (ProcessCanceledException ignored) {
                object = null;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                object = null;
            }
            if (object == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        EditorHistoryManager editorHistoryManager = this;
        synchronized (editorHistoryManager) {
            boolean bl = false;
            boolean bl5 = this.entries.addAll(list2);
        }
    }

    @NotNull
    public synchronized Element getState() {
        Element element = new Element("state");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object object = ArraysKt.reversed((Object[])virtualFileArray);
        int n = object.size();
        for (int j = 0; j < n; ++j) {
            VirtualFile file2 = (VirtualFile)object.get(j);
            Intrinsics.checkNotNull((Object)file2);
            if (this.getEntry(file2) == null) continue;
            Intrinsics.checkNotNull((Object)fileEditorManager);
            this.updateHistoryEntry(fileEditorManager, file2, null, false);
        }
        Iterator<HistoryEntry> iterator = this.entries.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            HistoryEntry entry = (HistoryEntry)e;
            if (!entry.isPersisted()) continue;
            element.addContent(entry.writeExternal(this.project));
        }
        return element;
    }

    public synchronized void dispose() {
        this.removeAllFiles();
    }

    private static final void _init_$lambda$0(EditorHistoryManager this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.trimToSize();
    }

    @JvmStatic
    @NotNull
    public static final EditorHistoryManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorHistoryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nEditorHistoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorHistoryManager.kt\ncom/intellij/openapi/fileEditor/impl/EditorHistoryManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,415:1\n30#2,2:416\n*S KotlinDebug\n*F\n+ 1 EditorHistoryManager.kt\ncom/intellij/openapi/fileEditor/impl/EditorHistoryManager$Companion\n*L\n65#1:416,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EditorHistoryManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<EditorHistoryManager> serviceClass$iv = EditorHistoryManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (EditorHistoryManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$IncludeInEditorHistoryFile;", "Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$OptionallyIncluded;", "isIncludedInEditorHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static interface IncludeInEditorHistoryFile
    extends OptionallyIncluded {
        @Override
        default public boolean isIncludedInEditorHistory(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "service", "Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager;", "getService", "()Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager;", "service$delegate", "Lkotlin/Lazy;", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nEditorHistoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorHistoryManager.kt\ncom/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
    public static final class MyEditorManagerListener
    implements FileEditorManagerListener {
        @NotNull
        private final Project project;
        @NotNull
        private final Lazy service$delegate;

        public MyEditorManagerListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
            this.service$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MyEditorManagerListener.service_delegate$lambda$0(this));
        }

        private final EditorHistoryManager getService() {
            Lazy lazy = this.service$delegate;
            return (EditorHistoryManager)lazy.getValue();
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.getService().fileOpenedImpl(file2, null, source);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PsiDocumentManager.getInstance((Project)this.project).performWhenAllCommitted(() -> MyEditorManagerListener.selectionChanged$lambda$0(event, this));
        }

        private static final EditorHistoryManager service_delegate$lambda$0(MyEditorManagerListener this$0) {
            return Companion.getInstance(this$0.project);
        }

        /*
         * WARNING - void declaration
         */
        private static final void selectionChanged$lambda$0(FileEditorManagerEvent $event, MyEditorManagerListener this$0) {
            VirtualFile newFile;
            FileEditorWithProvider fileEditorWithProvider;
            EditorHistoryManager editorHistoryManager;
            FileEditorManager fileEditorManager;
            VirtualFile virtualFile;
            FileEditor newEditor = $event.getNewEditor();
            if (newEditor != null && !newEditor.isValid()) {
                return;
            }
            VirtualFile oldFile = $event.getOldFile();
            if (oldFile != null) {
                FileEditorWithProvider fileEditorWithProvider2;
                EditorHistoryManager editorHistoryManager2 = this$0.getService();
                FileEditorManager fileEditorManager2 = $event.getManager();
                VirtualFile virtualFile2 = oldFile;
                FileEditor fileEditor = $event.getOldEditor();
                if (fileEditor != null) {
                    void it;
                    FileEditor fileEditor2 = fileEditor;
                    virtualFile = virtualFile2;
                    fileEditorManager = fileEditorManager2;
                    editorHistoryManager = editorHistoryManager2;
                    boolean bl = false;
                    FileEditorProvider fileEditorProvider = $event.getOldProvider();
                    Intrinsics.checkNotNull((Object)fileEditorProvider);
                    fileEditorWithProvider = new FileEditorWithProvider((FileEditor)it, fileEditorProvider);
                    editorHistoryManager2 = editorHistoryManager;
                    fileEditorManager2 = fileEditorManager;
                    virtualFile2 = virtualFile;
                    fileEditorWithProvider2 = fileEditorWithProvider;
                } else {
                    fileEditorWithProvider2 = null;
                }
                editorHistoryManager2.updateHistoryEntry(fileEditorManager2, virtualFile2, fileEditorWithProvider2, false);
            }
            if ((newFile = $event.getNewFile()) != null) {
                FileEditorWithProvider fileEditorWithProvider3;
                EditorHistoryManager editorHistoryManager3 = this$0.getService();
                FileEditorManager fileEditorManager3 = $event.getManager();
                VirtualFile virtualFile3 = newFile;
                FileEditor fileEditor = $event.getNewEditor();
                if (fileEditor != null) {
                    void it;
                    FileEditor bl = fileEditor;
                    virtualFile = virtualFile3;
                    fileEditorManager = fileEditorManager3;
                    editorHistoryManager = editorHistoryManager3;
                    boolean bl2 = false;
                    FileEditorProvider fileEditorProvider = $event.getNewProvider();
                    Intrinsics.checkNotNull((Object)fileEditorProvider);
                    fileEditorWithProvider = new FileEditorWithProvider((FileEditor)it, fileEditorProvider);
                    editorHistoryManager3 = editorHistoryManager;
                    fileEditorManager3 = fileEditorManager;
                    virtualFile3 = virtualFile;
                    fileEditorWithProvider3 = fileEditorWithProvider;
                } else {
                    fileEditorWithProvider3 = null;
                }
                editorHistoryManager3.updateHistoryEntry(fileEditorManager3, virtualFile3, fileEditorWithProvider3, true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$OptionallyIncluded;", "", "isIncludedInEditorHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "isPersistedInEditorHistory", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static interface OptionallyIncluded {
        public boolean isIncludedInEditorHistory(@NotNull Project var1);

        default public boolean isPersistedInEditorHistory() {
            return true;
        }
    }
}

