/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabPainter;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabPainterAdapter;", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "<init>", "()V", "magicOffset", "", "tabPainter", "Lcom/intellij/ui/tabs/impl/JBEditorTabPainter;", "getTabPainter", "()Lcom/intellij/ui/tabs/impl/JBEditorTabPainter;", "paintBackground", "", "label", "Lcom/intellij/ui/tabs/impl/TabLabel;", "g", "Ljava/awt/Graphics;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "paintBorders", "Ljava/awt/Graphics2D;", "intellij.platform.ide.impl"})
public final class EditorTabPainterAdapter
implements TabPainterAdapter {
    private final int magicOffset;
    @NotNull
    private final JBEditorTabPainter tabPainter = new JBEditorTabPainter();

    public EditorTabPainterAdapter() {
        this.magicOffset = 1;
    }

    @NotNull
    public JBEditorTabPainter getTabPainter() {
        return this.tabPainter;
    }

    public void paintBackground(@NotNull TabLabel label2, @NotNull Graphics g, @NotNull JBTabsImpl tabs) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        TabInfo info = label2.getInfo();
        boolean isSelected = Intrinsics.areEqual((Object)info, (Object)tabs.getSelectedInfo());
        boolean isHovered = tabs.isHoveredTab(label2);
        Rectangle rect = new Rectangle(0, 0, label2.getWidth(), label2.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        if (isSelected) {
            this.getTabPainter().paintSelectedTab(tabs.getTabsPosition(), g2d, rect, tabs.getBorderThickness(), info.getTabColor(), tabs.isActiveTabs(info), isHovered);
            this.paintBorders(g2d, label2, tabs);
        } else {
            if (ExperimentalUI.Companion.isNewUI() && isHovered && tabs.getTabsPosition() == JBTabsPosition.top && ((JBEditorTabs)tabs).shouldPaintBottomBorder()) {
                --rect.height;
            }
            this.getTabPainter().paintTab(tabs.getTabsPosition(), g2d, rect, tabs.getBorderThickness(), info.getTabColor(), tabs.isActiveTabs(info), isHovered);
            this.paintBorders(g2d, label2, tabs);
        }
    }

    private final void paintBorders(Graphics2D g, TabLabel label2, JBTabsImpl tabs) {
        Rectangle bounds;
        boolean paintStandardBorder = !ExperimentalUI.Companion.isNewUI() && !tabs.isSingleRow() || !tabs.getTabsPosition().isSide() && Registry.Companion.is("ide.new.editor.tabs.vertical.borders") || label2.isForcePaintBorders();
        boolean lastPinned = label2.isLastPinned();
        boolean nextToLastPinned = label2.isNextToLastPinned();
        Rectangle rect = new Rectangle(0, 0, label2.getWidth(), label2.getHeight());
        if (paintStandardBorder || lastPinned || nextToLastPinned) {
            bounds = label2.getBounds();
            if (bounds.x > this.magicOffset && (paintStandardBorder || nextToLastPinned)) {
                this.getTabPainter().paintLeftGap(tabs.getTabsPosition(), g, rect, tabs.getBorderThickness());
            }
            if (!(bounds.x + bounds.width >= tabs.getWidth() - this.magicOffset || label2.isLastInRow() && ExperimentalUI.Companion.isNewUI() || !paintStandardBorder && !lastPinned)) {
                this.getTabPainter().paintRightGap(tabs.getTabsPosition(), g, rect, tabs.getBorderThickness());
            }
        }
        if (tabs.getTabsPosition().isSide() && lastPinned) {
            bounds = label2.getBounds();
            if (bounds.y + bounds.height < tabs.getHeight() - this.magicOffset) {
                this.getTabPainter().paintBottomGap(tabs.getTabsPosition(), g, rect, tabs.getBorderThickness());
            }
        }
        if (tabs.getTabsPosition().isSide() && nextToLastPinned) {
            bounds = label2.getBounds();
            if (bounds.y + bounds.height < tabs.getHeight() - this.magicOffset) {
                this.getTabPainter().paintTopGap(tabs.getTabsPosition(), g, rect, tabs.getBorderThickness());
            }
        }
    }
}

