/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorCaretState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorFoldingState;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextEditorState
implements FileEditorState {
    private static final int MIN_CHANGE_DISTANCE = 4;
    @NotNull
    private final @NotNull TextEditorCaretState @NotNull [] carets;
    private final int relativeCaretPosition;
    @NotNull
    private final TextEditorFoldingState foldingState;

    public TextEditorState() {
        this(new TextEditorCaretState[0], 0, new TextEditorFoldingState(null, null));
    }

    TextEditorState(@NotNull @NotNull TextEditorCaretState @NotNull [] carets, int relativeCaretPosition) {
        if (carets == null) {
            TextEditorState.$$$reportNull$$$0(0);
        }
        this(carets, relativeCaretPosition, new TextEditorFoldingState(null, null));
    }

    private TextEditorState(@NotNull @NotNull TextEditorCaretState @NotNull [] carets, int relativeCaretPosition, @NotNull TextEditorFoldingState foldingState) {
        if (foldingState == null) {
            TextEditorState.$$$reportNull$$$0(1);
        }
        if (carets == null) {
            TextEditorState.$$$reportNull$$$0(2);
        }
        this.carets = carets;
        this.relativeCaretPosition = relativeCaretPosition;
        this.foldingState = foldingState;
    }

    @ApiStatus.Internal
    @NotNull
    public TextEditorState withLazyFoldingState(@NotNull Supplier<? extends CodeFoldingState> lazyFoldingState) {
        if (lazyFoldingState == null) {
            TextEditorState.$$$reportNull$$$0(3);
        }
        return new TextEditorState(this.carets, this.relativeCaretPosition, new TextEditorFoldingState(null, lazyFoldingState));
    }

    @ApiStatus.Internal
    @NotNull
    public TextEditorState withFoldingState(@NotNull CodeFoldingState foldingState) {
        if (foldingState == null) {
            TextEditorState.$$$reportNull$$$0(4);
        }
        return new TextEditorState(this.carets, this.relativeCaretPosition, new TextEditorFoldingState(foldingState, null));
    }

    @ApiStatus.Internal
    @Nullable
    public Supplier<? extends CodeFoldingState> getLazyFoldingState() {
        return this.foldingState.getLazyFoldingState();
    }

    @ApiStatus.Internal
    @Nullable
    public CodeFoldingState getFoldingState() {
        return this.foldingState.getFoldingState();
    }

    TextEditorCaretState @NotNull [] getCarets() {
        if (this.carets == null) {
            TextEditorState.$$$reportNull$$$0(5);
        }
        return this.carets;
    }

    int getRelativeCaretPosition() {
        return this.relativeCaretPosition;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextEditorState)) {
            return false;
        }
        TextEditorState textEditorState = (TextEditorState)o;
        if (!Arrays.equals(this.carets, textEditorState.carets)) {
            return false;
        }
        if (this.relativeCaretPosition != textEditorState.relativeCaretPosition) {
            return false;
        }
        CodeFoldingState localFoldingState = this.getFoldingState();
        CodeFoldingState theirFoldingState = textEditorState.getFoldingState();
        return Objects.equals(localFoldingState, theirFoldingState);
    }

    public int hashCode() {
        return Arrays.hashCode(this.carets);
    }

    public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
        if (otherState == null) {
            TextEditorState.$$$reportNull$$$0(6);
        }
        if (level == null) {
            TextEditorState.$$$reportNull$$$0(7);
        }
        if (!(otherState instanceof TextEditorState)) {
            return false;
        }
        TextEditorState other = (TextEditorState)otherState;
        return level == FileEditorStateLevel.NAVIGATION && ArrayUtil.areEqual((Object[])this.carets, (Object[])other.carets, (a, b) -> Math.abs(a.line() - b.line()) < 4);
    }

    public String toString() {
        return Arrays.toString(this.carets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "carets";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyFoldingState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/TextEditorState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCarets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withLazyFoldingState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withFoldingState";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeMergedWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

