/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.EmptyIcon;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeRenderer
extends SimpleListCellRenderer<FileType> {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    @Nullable
    private final ListModel<? extends FileType> myModel;
    @Nullable
    private Set<String> myDuplicateDescriptions;

    public FileTypeRenderer() {
        this.myDuplicateDescriptions = null;
        this.myModel = null;
        this.myDuplicateDescriptions = new HashSet<String>();
        HashSet<String> filter2 = new HashSet<String>();
        for (FileType type : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String s = type.getDescription();
            if (filter2.add(s)) continue;
            this.myDuplicateDescriptions.add(s);
        }
    }

    public FileTypeRenderer(@NotNull ListModel<? extends FileType> model2) {
        if (model2 == null) {
            FileTypeRenderer.$$$reportNull$$$0(0);
        }
        this.myDuplicateDescriptions = null;
        this.myModel = model2;
        this.myModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                FileTypeRenderer.this.myDuplicateDescriptions = null;
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FileTypeRenderer.this.myDuplicateDescriptions = null;
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FileTypeRenderer.this.myDuplicateDescriptions = null;
            }
        });
    }

    public void customize(@NotNull JList<? extends FileType> list2, FileType value, int index, boolean selected, boolean hasFocus) {
        if (list2 == null) {
            FileTypeRenderer.$$$reportNull$$$0(1);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        Icon icon2 = value.getIcon();
        if (icon2 != null) {
            layeredIcon.setIcon(icon2, 1, (-icon2.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon2.getIconHeight()) / 2);
        }
        this.setIcon((Icon)layeredIcon);
        String description = value.getDescription();
        if (this.isDuplicated(description)) {
            this.setText(description + " (" + value.getName() + ")");
        } else {
            this.setText(description);
        }
    }

    private boolean isDuplicated(String description) {
        if (this.myDuplicateDescriptions == null) {
            assert (this.myModel != null);
            this.myDuplicateDescriptions = new HashSet<String>();
            HashSet<String> filter2 = new HashSet<String>();
            for (int i2 = 0; i2 < this.myModel.getSize(); ++i2) {
                String s = this.myModel.getElementAt(i2).getDescription();
                if (filter2.add(s)) continue;
                this.myDuplicateDescriptions.add(s);
            }
        }
        return this.myDuplicateDescriptions.contains(description);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

