/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableVisitor
implements Predicate<Configurable> {
    public static final Predicate<Configurable> ALL = Predicates.alwaysTrue();

    @Override
    public boolean test(Configurable configurable) {
        return this.accept(configurable);
    }

    protected abstract boolean accept(@NotNull Configurable var1);

    @Deprecated
    @Nullable
    public final Configurable find(ConfigurableGroup ... groups) {
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(0);
        }
        return ConfigurableVisitor.find((Predicate<? super Configurable>)this, Arrays.asList(groups));
    }

    @Nullable
    public static Configurable findById(@NotNull String id2, @NotNull List<? extends ConfigurableGroup> groups) {
        if (id2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(1);
        }
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(2);
        }
        return ConfigurableVisitor.find((? super Configurable configurable) -> id2.equals(ConfigurableVisitor.getId(configurable)), groups);
    }

    @Nullable
    public static Configurable findByType(@NotNull Class<? extends Configurable> type, @NotNull List<? extends ConfigurableGroup> groups) {
        if (type == null) {
            ConfigurableVisitor.$$$reportNull$$$0(3);
        }
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(4);
        }
        return ConfigurableVisitor.find((? super Configurable configurable) -> ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable) != null, groups);
    }

    @Nullable
    public static Configurable find(@NotNull Predicate<? super Configurable> visitor, @NotNull List<? extends ConfigurableGroup> groups) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(5);
        }
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(6);
        }
        for (ConfigurableGroup configurableGroup : groups) {
            Configurable result2 = ConfigurableVisitor.find(visitor, configurableGroup.getConfigurables());
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Configurable find(@NotNull Predicate<? super Configurable> visitor, Configurable @NotNull [] configurables2) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(7);
        }
        if (configurables2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(8);
        }
        for (Configurable configurable : configurables2) {
            if (!visitor.test((Configurable)configurable)) continue;
            return configurable;
        }
        for (Configurable configurable : configurables2) {
            Configurable.Composite composite2;
            Configurable result2;
            if (!(configurable instanceof Configurable.Composite) || (result2 = ConfigurableVisitor.find(visitor, (composite2 = (Configurable.Composite)configurable).getConfigurables())) == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    public static List<Configurable> findAll(@NotNull Predicate<? super Configurable> visitor, @NotNull List<? extends ConfigurableGroup> groups) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(9);
        }
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(10);
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        Consumer<Configurable> consumer = configurable -> {
            if (visitor.test((Configurable)configurable)) {
                list2.add((Configurable)configurable);
            }
        };
        for (ConfigurableGroup configurableGroup : groups) {
            ConfigurableVisitor.collect(consumer, configurableGroup.getConfigurables());
        }
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ConfigurableVisitor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    public static void collect(@NotNull Consumer<? super Configurable> visitor, Configurable @NotNull [] configurables2) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(12);
        }
        if (configurables2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(13);
        }
        for (Configurable configurable : configurables2) {
            visitor.accept((Configurable)configurable);
            if (!(configurable instanceof Configurable.Composite)) continue;
            ConfigurableVisitor.collect(visitor, ((Configurable.Composite)configurable).getConfigurables());
        }
    }

    @NotNull
    public static String getId(@NotNull Configurable configurable) {
        if (configurable == null) {
            ConfigurableVisitor.$$$reportNull$$$0(14);
        }
        String string = configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getId() : configurable.getClass().getName();
        if (string == null) {
            ConfigurableVisitor.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableVisitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableVisitor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findByType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 15 -> new IllegalStateException(string);
        };
    }
}

