/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.ProgressModel;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.ide.progress.CancellableTaskCancellation;
import com.intellij.platform.ide.progress.TaskCancellation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\rB1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\n\u0010\u0012J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u000f\u0010\u001c\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u00112\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u0005J\u000f\u0010 \u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b!H\u0016J\u0012\u0010\"\u001a\u00020\u00112\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0005J\b\u0010$\u001a\u00020\u001bH\u0016J\b\u0010%\u001a\u00020\tH\u0016J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\tJ\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\tH\u0016J\b\u0010+\u001a\u00020\u0011H\u0016J\u0014\u0010,\u001a\u00020\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\u0005H\u0017J\u0010\u0010/\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0003J\u0010\u00102\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J\b\u00103\u001a\u00020\u0003H\u0016J\u001c\u00104\u001a\u00020\u00112\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001105H\u0016J\u0016\u00106\u001a\u00020\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Lcom/intellij/openapi/progress/ProgressIndicatorModel;", "Lcom/intellij/openapi/progress/ProgressModel;", "progressIndicator", "Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;", "title", "", "cancellation", "Lcom/intellij/platform/ide/progress/TaskCancellation;", "visibleInStatusBar", "", "<init>", "(Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;Ljava/lang/String;Lcom/intellij/platform/ide/progress/TaskCancellation;Z)V", "isCancellable", "(Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;Ljava/lang/String;Z)V", "taskCancellation", "onCancel", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lcom/intellij/platform/ide/progress/TaskCancellation;ZLkotlin/jvm/functions/Function0;)V", "getTitle", "()Ljava/lang/String;", "getCancellation", "()Lcom/intellij/platform/ide/progress/TaskCancellation;", "getVisibleInStatusBar", "()Z", "setFraction", "fraction", "", "getText", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "setText", "text", "getDetails", "Lcom/intellij/openapi/util/NlsContexts$ProgressDetails;", "setText2", "text2", "getFraction", "isIndeterminate", "setIndeterminate", "isStopping", "taskInfo", "Lcom/intellij/openapi/progress/TaskInfo;", "isRunning", "cancel", "onProgressChange", "action", "getCancelTooltipText", "finish", "addStateDelegate", "delegate", "isFinished", "getProgressIndicator", "addOnFinishAction", "Lkotlin/Function1;", "addOnChangeAction", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ProgressIndicatorModel
implements ProgressModel {
    @NotNull
    private final ProgressIndicatorEx progressIndicator;
    @NotNull
    private final String title;
    @NotNull
    private final TaskCancellation cancellation;
    private final boolean visibleInStatusBar;

    public ProgressIndicatorModel(@NotNull ProgressIndicatorEx progressIndicator, @NotNull String title2, @NotNull TaskCancellation cancellation, boolean visibleInStatusBar) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        this.progressIndicator = progressIndicator;
        this.title = title2;
        this.cancellation = cancellation;
        this.visibleInStatusBar = visibleInStatusBar;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public TaskCancellation getCancellation() {
        return this.cancellation;
    }

    @Override
    public boolean getVisibleInStatusBar() {
        return this.visibleInStatusBar;
    }

    public ProgressIndicatorModel(@NotNull ProgressIndicatorEx progressIndicator, @NotNull String title2, boolean isCancellable) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this(progressIndicator, title2, isCancellable ? (TaskCancellation)TaskCancellation.Companion.cancellable() : (TaskCancellation)TaskCancellation.Companion.nonCancellable(), true);
    }

    /*
     * WARNING - void declaration
     */
    public ProgressIndicatorModel(@NotNull String title2, @NotNull TaskCancellation taskCancellation, boolean visibleInStatusBar, @NotNull Function0<Unit> onCancel) {
        void $this$_init__u24lambda_u240;
        ProgressIndicatorBase progressIndicatorBase;
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)taskCancellation, (String)"taskCancellation");
        Intrinsics.checkNotNullParameter(onCancel, (String)"onCancel");
        ProgressIndicatorBase progressIndicatorBase2 = progressIndicatorBase = new ProgressIndicatorBase();
        ProgressIndicatorModel progressIndicatorModel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(onCancel){
            final /* synthetic */ Function0<Unit> $onCancel;
            {
                this.$onCancel = $onCancel;
            }

            public void cancel() {
                this.$onCancel.invoke();
                super.cancel();
            }
        });
        progressIndicatorModel((ProgressIndicatorEx)progressIndicatorBase, title2, taskCancellation, visibleInStatusBar);
    }

    public /* synthetic */ ProgressIndicatorModel(String string, TaskCancellation taskCancellation, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, taskCancellation, bl, (Function0<Unit>)function0);
    }

    public final void setFraction(double fraction) {
        this.progressIndicator.setFraction(fraction);
    }

    @Override
    @Nullable
    public String getText() {
        return this.progressIndicator.getText();
    }

    public final void setText(@NlsContexts.ProgressText @Nullable String text2) {
        String string = text2;
        if (string == null) {
            string = "";
        }
        this.progressIndicator.setText(string);
    }

    @Override
    @Nullable
    public String getDetails() {
        return this.progressIndicator.getText2();
    }

    public final void setText2(@NlsContexts.ProgressDetails @Nullable String text2) {
        String string = text2;
        if (string == null) {
            string = "";
        }
        this.progressIndicator.setText2(string);
    }

    @Override
    public double getFraction() {
        return this.progressIndicator.getFraction();
    }

    @Override
    public boolean isIndeterminate() {
        return this.progressIndicator.isIndeterminate();
    }

    public final void setIndeterminate(boolean isIndeterminate) {
        this.progressIndicator.setIndeterminate(isIndeterminate);
    }

    @Override
    public boolean isStopping(@NotNull TaskInfo taskInfo2) {
        Intrinsics.checkNotNullParameter((Object)taskInfo2, (String)"taskInfo");
        return this.progressIndicator.wasStarted() && (this.progressIndicator.isCanceled() || !this.progressIndicator.isRunning()) && !this.progressIndicator.isFinished(taskInfo2);
    }

    @Override
    public boolean isRunning() {
        return this.progressIndicator.isRunning();
    }

    @Override
    public void cancel() {
        this.progressIndicator.cancel();
    }

    public final void onProgressChange(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.progressIndicator.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(action2){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            protected void onProgressChange() {
                super.onProgressChange();
                this.$action.invoke();
            }
        });
    }

    @Override
    public boolean isCancellable() {
        return this.getCancellation() instanceof TaskCancellation.Cancellable;
    }

    @Override
    @NlsContexts.Tooltip
    @NotNull
    public String getCancelTooltipText() {
        if (!this.isCancellable()) {
            return "";
        }
        TaskCancellation taskCancellation = this.getCancellation();
        Object object = taskCancellation instanceof CancellableTaskCancellation ? (CancellableTaskCancellation)taskCancellation : null;
        if (object == null || (object = object.getTooltipText()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    public void finish(@NotNull TaskInfo taskInfo2) {
        Intrinsics.checkNotNullParameter((Object)taskInfo2, (String)"taskInfo");
        this.progressIndicator.finish(taskInfo2);
    }

    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.progressIndicator.addStateDelegate(delegate);
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo taskInfo2) {
        Intrinsics.checkNotNullParameter((Object)taskInfo2, (String)"taskInfo");
        return this.progressIndicator.isFinished(taskInfo2);
    }

    @Override
    @NotNull
    public ProgressIndicatorEx getProgressIndicator() {
        return this.progressIndicator;
    }

    @Override
    public void addOnFinishAction(@NotNull Function1<? super TaskInfo, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        AbstractProgressIndicatorExBase indicator2 = new AbstractProgressIndicatorExBase(action2){
            final /* synthetic */ Function1<TaskInfo, Unit> $action;
            {
                this.$action = $action;
            }

            public void finish(TaskInfo task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                super.finish(task);
                this.$action.invoke((Object)task);
            }
        };
        this.progressIndicator.addStateDelegate((ProgressIndicatorEx)indicator2);
    }

    @Override
    public void addOnChangeAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        AbstractProgressIndicatorExBase indicator2 = new AbstractProgressIndicatorExBase(action2){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            protected void onProgressChange() {
                this.$action.invoke();
            }

            public void cancel() {
                super.cancel();
                this.$action.invoke();
            }

            public void stop() {
                super.stop();
                this.$action.invoke();
            }
        };
        this.progressIndicator.addStateDelegate((ProgressIndicatorEx)indicator2);
    }
}

