/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.application.impl.JobProvider;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.ComponentModalTaskOwner;
import com.intellij.platform.ide.progress.GuessModalTaskOwner;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.ProjectModalTaskOwner;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/progress/impl/JobProviderWithOwnerContext;", "Lcom/intellij/openapi/application/impl/JobProvider;", "modalJob", "Lkotlinx/coroutines/Job;", "owner", "Lcom/intellij/platform/ide/progress/ModalTaskOwner;", "<init>", "(Lkotlinx/coroutines/Job;Lcom/intellij/platform/ide/progress/ModalTaskOwner;)V", "getModalJob", "()Lkotlinx/coroutines/Job;", "getOwner", "()Lcom/intellij/platform/ide/progress/ModalTaskOwner;", "isPartOf", "", "frame", "Ljavax/swing/JFrame;", "project", "Lcom/intellij/openapi/project/Project;", "getJob", "intellij.platform.ide.impl"})
final class JobProviderWithOwnerContext
implements JobProvider {
    @NotNull
    private final Job modalJob;
    @NotNull
    private final ModalTaskOwner owner;

    public JobProviderWithOwnerContext(@NotNull Job modalJob2, @NotNull ModalTaskOwner owner) {
        Intrinsics.checkNotNullParameter((Object)modalJob2, (String)"modalJob");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.modalJob = modalJob2;
        this.owner = owner;
    }

    @NotNull
    public final Job getModalJob() {
        return this.modalJob;
    }

    @NotNull
    public final ModalTaskOwner getOwner() {
        return this.owner;
    }

    public boolean isPartOf(@NotNull JFrame frame, @Nullable Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        ModalTaskOwner modalTaskOwner = this.owner;
        if (modalTaskOwner instanceof ComponentModalTaskOwner) {
            bl = ProgressWindow.calcParentWindow(((ComponentModalTaskOwner)this.owner).getComponent(), null) == frame;
        } else if (modalTaskOwner instanceof ProjectModalTaskOwner) {
            bl = ((ProjectModalTaskOwner)this.owner).getProject() == project2;
        } else if (modalTaskOwner instanceof GuessModalTaskOwner) {
            bl = ProgressWindow.calcParentWindow(null, null) == frame;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public Job getJob() {
        return this.modalJob;
    }
}

