/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.progress.util.ProgressDialogWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import java.awt.Component;
import java.awt.Window;
import java.util.function.Function;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001a\u001e\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\b\u0010\u0013\u001a\u00020\nH\u0000\u00a8\u0006\u0014"}, d2={"createDialogWrapper", "Lcom/intellij/openapi/ui/DialogWrapper;", "panel", "Ljavax/swing/JPanel;", "cancelAction", "Lkotlin/Function0;", "", "window", "Ljava/awt/Window;", "writeAction", "", "project", "Lcom/intellij/openapi/project/Project;", "peerFactory", "Ljava/util/function/Function;", "Lcom/intellij/openapi/ui/DialogWrapperPeer;", "lightPopup", "setupProgressDialog", "dialog", "areLightPopupsEnabled", "intellij.platform.ide.impl"})
public final class ProgressDialogWrapperKt {
    @NotNull
    public static final DialogWrapper createDialogWrapper(@NotNull JPanel panel2, @NotNull Function0<Unit> cancelAction, @NotNull Window window, boolean writeAction, @Nullable Project project2) {
        ProgressDialogWrapper progressDialogWrapper;
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter(cancelAction, (String)"cancelAction");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (window.isShowing()) {
            progressDialogWrapper = new ProgressDialogWrapper(panel2, cancelAction, ProgressDialogWrapperKt.peerFactory(window, !writeAction));
        } else {
            ProgressDialogWrapper progressDialogWrapper2;
            ProgressDialogWrapper it = progressDialogWrapper2 = new ProgressDialogWrapper(panel2, cancelAction, ProgressDialogWrapperKt.peerFactory(project2));
            boolean bl = false;
            it.superInitResizeListener();
            progressDialogWrapper = progressDialogWrapper2;
        }
        ProgressDialogWrapper dialog2 = progressDialogWrapper;
        ProgressDialogWrapperKt.setupProgressDialog(dialog2, writeAction);
        return dialog2;
    }

    private static final Function<DialogWrapper, DialogWrapperPeer> peerFactory(Window window, boolean lightPopup) {
        return arg_0 -> ProgressDialogWrapperKt.peerFactory$lambda$0(lightPopup, window, arg_0);
    }

    private static final Function<DialogWrapper, DialogWrapperPeer> peerFactory(Project project2) {
        return arg_0 -> ProgressDialogWrapperKt.peerFactory$lambda$1(project2, arg_0);
    }

    public static final void setupProgressDialog(@NotNull DialogWrapper dialog2, boolean writeAction) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        dialog2.setUndecorated(true);
        DialogWrapperPeer dialogWrapperPeer = dialog2.getPeer();
        Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"getPeer(...)");
        DialogWrapperPeer peer = dialogWrapperPeer;
        if (peer instanceof DialogWrapperPeerImpl) {
            ((DialogWrapperPeerImpl)peer).setAutoRequestFocus(false);
            if (writeAction) {
                dialog2.setModal(false);
            }
        }
        dialog2.pack();
    }

    public static final boolean areLightPopupsEnabled() {
        return ClientSessionsManager.Companion.getAppSessions(ClientKind.CONTROLLER).isEmpty();
    }

    private static final DialogWrapperPeer peerFactory$lambda$0(boolean $lightPopup, Window $window, DialogWrapper dialogWrapper) {
        DialogWrapperPeer dialogWrapperPeer;
        Intrinsics.checkNotNullParameter((Object)dialogWrapper, (String)"dialogWrapper");
        if ($lightPopup && ProgressDialogWrapperKt.areLightPopupsEnabled()) {
            DialogWrapperPeer dialogWrapperPeer2;
            try {
                dialogWrapperPeer2 = new GlassPaneDialogWrapperPeer(dialogWrapper, $window);
            }
            catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                dialogWrapperPeer2 = DialogWrapperPeerFactory.getInstance().createPeer(dialogWrapper, (Component)$window, false);
            }
            dialogWrapperPeer = dialogWrapperPeer2;
        } else {
            dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(dialogWrapper, (Component)$window, false);
        }
        return dialogWrapperPeer;
    }

    private static final DialogWrapperPeer peerFactory$lambda$1(Project $project, DialogWrapper dialogWrapper) {
        Intrinsics.checkNotNullParameter((Object)dialogWrapper, (String)"dialogWrapper");
        return DialogWrapperPeerFactory.getInstance().createPeer(dialogWrapper, $project, false, DialogWrapper.IdeModalityType.IDE);
    }
}

