/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.util.BaseTextCommentCellAppearance;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ValidFileCellAppearance
extends BaseTextCommentCellAppearance {
    private final VirtualFile myFile;

    public ValidFileCellAppearance(VirtualFile file2) {
        this.myFile = file2;
    }

    protected Icon getIcon() {
        return this.myFile.getFileType().getIcon();
    }

    protected String getSecondaryText() {
        return this.getSubname(true);
    }

    protected String getPrimaryText() {
        return this.getSubname(false);
    }

    @NlsSafe
    private String getSubname(boolean headOrTail) {
        String presentableUrl = this.myFile.getPresentableUrl();
        int separatorIndex = this.getSplitUrlIndex(presentableUrl);
        if (headOrTail) {
            return separatorIndex >= 0 ? presentableUrl.substring(0, separatorIndex) : "";
        }
        return presentableUrl.substring(separatorIndex + 1);
    }

    protected int getSplitUrlIndex(String presentableUrl) {
        return presentableUrl.lastIndexOf(File.separatorChar);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }
}

