/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import io.opentelemetry.context.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractCommand
implements PlaybackCommand {
    private static final Logger LOG = Logger.getInstance(AbstractCommand.class);
    @NonNls
    public static final String CMD_PREFIX = "%";
    @NonNls
    @NotNull
    private final String myText;
    private final int myLine;
    private final boolean executeInAwt;
    @Nullable
    private File myScriptDir;

    public String extractCommandArgument(String prefix) {
        if (this.myText.startsWith(prefix)) {
            return this.myText.substring(prefix.length()).trim();
        }
        return this.myText;
    }

    public ArrayList<String> extractCommandList(String prefix, String delimiter) {
        return new ArrayList<String>(Arrays.stream(this.extractCommandArgument(prefix).split(delimiter)).map(argument -> argument.trim()).filter(argument -> !argument.isEmpty()).toList());
    }

    public AbstractCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            AbstractCommand.$$$reportNull$$$0(0);
        }
        this(text2, line, false);
    }

    public AbstractCommand(@NotNull String text2, int line, boolean executeInAwt) {
        if (text2 == null) {
            AbstractCommand.$$$reportNull$$$0(1);
        }
        this.executeInAwt = executeInAwt;
        this.myText = text2;
        this.myLine = line;
    }

    @NonNls
    @NotNull
    public final String getText() {
        String string = this.myText;
        if (string == null) {
            AbstractCommand.$$$reportNull$$$0(2);
        }
        return string;
    }

    public final int getLine() {
        return this.myLine;
    }

    @Override
    @Nullable
    public final File getScriptDir() {
        return this.myScriptDir;
    }

    public final void setScriptDir(@Nullable File scriptDir) {
        this.myScriptDir = scriptDir;
    }

    @Override
    public boolean canGoFurther() {
        return true;
    }

    @Override
    @NotNull
    public final CompletableFuture<?> execute(@NotNull PlaybackContext context) {
        CompletableFuture completableFuture;
        if (context == null) {
            AbstractCommand.$$$reportNull$$$0(3);
        }
        try {
            if (this.isToDumpCommand()) {
                context.code(this.getText(), this.getLine());
            }
            CompletableFuture result2 = new CompletableFuture();
            Runnable runnable2 = Context.current().wrap(() -> {
                try {
                    Promises.asCompletableFuture(this._execute(context)).whenComplete((o, throwable) -> {
                        if (throwable == null) {
                            result2.complete(o);
                        } else {
                            result2.completeExceptionally((Throwable)throwable);
                        }
                    });
                }
                catch (Throwable e) {
                    LOG.error(e);
                    this.dumpError(context, e.getMessage());
                    result2.completeExceptionally(e);
                }
            });
            Application application = ApplicationManager.getApplication();
            if (this.executeInAwt) {
                application.invokeLater(runnable2);
            } else {
                application.executeOnPooledThread(runnable2);
            }
            completableFuture = result2;
        }
        catch (Throwable e) {
            this.dumpError(context, e.getMessage());
            CompletableFuture completableFuture2 = CompletableFuture.failedFuture(e);
            if (completableFuture2 == null) {
                AbstractCommand.$$$reportNull$$$0(5);
            }
            return completableFuture2;
        }
        if (completableFuture == null) {
            AbstractCommand.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    protected boolean isToDumpCommand() {
        return true;
    }

    @NotNull
    protected abstract Promise<Object> _execute(@NotNull PlaybackContext var1);

    protected final void dumpError(@NotNull PlaybackContext context, @NotNull String text2) {
        if (context == null) {
            AbstractCommand.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            AbstractCommand.$$$reportNull$$$0(7);
        }
        context.error(text2, this.getLine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/AbstractCommand";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/AbstractCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dumpError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

