/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AlphaNumericTypeCommand
extends TypeCommand {
    public AlphaNumericTypeCommand(String text2, int line) {
        super(text2, line, true);
    }

    @Override
    @NotNull
    public Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            AlphaNumericTypeCommand.$$$reportNull$$$0(0);
        }
        Promise<Object> promise = this.type(context, this.getText());
        if (promise == null) {
            AlphaNumericTypeCommand.$$$reportNull$$$0(1);
        }
        return promise;
    }

    protected Promise<Object> type(PlaybackContext context, String text2) {
        ActionCallback result2 = new ActionCallback();
        AlphaNumericTypeCommand.inWriteSafeContext(() -> {
            TypingTarget typingTarget = AlphaNumericTypeCommand.findTarget(context);
            if (typingTarget != null) {
                typingTarget.type(text2).doWhenDone(result2.createSetDoneRunnable()).doWhenRejected(() -> this.typeByRobot(context.getRobot(), text2).notify(result2));
            } else {
                this.typeByRobot(context.getRobot(), text2).notify(result2);
            }
        });
        return Promises.toPromise((ActionCallback)result2);
    }

    private ActionCallback typeByRobot(Robot robot, String text2) {
        ActionCallback result2 = new ActionCallback();
        Runnable typeRunnable = () -> {
            for (int i2 = 0; i2 < text2.length(); ++i2) {
                char each = text2.charAt(i2);
                if ('\\' == each && i2 + 1 < text2.length()) {
                    char next = text2.charAt(i2 + 1);
                    boolean processed = true;
                    switch (next) {
                        case 'n': 
                        case 'r': {
                            this.type(robot, 10, 0);
                            break;
                        }
                        case 't': {
                            this.type(robot, 9, 0);
                            break;
                        }
                        default: {
                            processed = false;
                        }
                    }
                    if (processed) {
                        ++i2;
                        continue;
                    }
                }
                this.type(robot, this.get(each));
            }
            result2.setDone();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(typeRunnable);
        } else {
            typeRunnable.run();
        }
        return result2;
    }

    @Nullable
    public static TypingTarget findTarget(PlaybackContext context) {
        if (!context.isUseTypingTargets()) {
            return null;
        }
        for (Component each = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); each != null; each = each.getParent()) {
            if (!(each instanceof TypingTarget)) continue;
            return (TypingTarget)each;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/AlphaNumericTypeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/AlphaNumericTypeCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

