/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public final class CallCommand
extends AbstractCommand {
    public static final String PREFIX = "%call";

    public CallCommand(String text2, int line) {
        super(text2, line, true);
    }

    @Override
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Promise result2;
        AsyncPromise cmdResult;
        String cmd;
        block18: {
            Method m;
            Pair<Method, Class<?>> methodClass;
            boolean noArgs;
            String[] args;
            String methodName;
            block17: {
                block16: {
                    int open;
                    if (context == null) {
                        CallCommand.$$$reportNull$$$0(0);
                    }
                    if ((open = (cmd = this.getText().substring(PREFIX.length()).trim()).indexOf("(")) == -1) {
                        context.error("( expected", this.getLine());
                        Promise promise = Promises.resolvedPromise();
                        if (promise == null) {
                            CallCommand.$$$reportNull$$$0(1);
                        }
                        return promise;
                    }
                    int close2 = cmd.lastIndexOf(")");
                    if (close2 == -1) {
                        context.error(") expected", this.getLine());
                        Promise promise = Promises.resolvedPromise();
                        if (promise == null) {
                            CallCommand.$$$reportNull$$$0(2);
                        }
                        return promise;
                    }
                    methodName = cmd.substring(0, open);
                    args = cmd.substring(open + 1, close2).split(",");
                    noArgs = args.length == 1 && args[0].isEmpty();
                    Object[] types = noArgs ? new Class[1] : new Class[args.length + 1];
                    types[0] = PlaybackContext.class;
                    for (int i2 = 1; i2 < types.length; ++i2) {
                        types[i2] = String.class;
                    }
                    cmdResult = new AsyncPromise();
                    methodClass = CallCommand.findMethod(context, methodName, (Class[])types);
                    if (methodClass != null) break block16;
                    context.error("No method \"" + methodName + "\" with parameters [" + StringUtil.join((Object[])types, type -> type.getName(), (String)", ") + "] found in facade classes: " + String.valueOf(context.getCallClasses()), this.getLine());
                    Promise promise = Promises.rejectedPromise();
                    if (promise == null) {
                        CallCommand.$$$reportNull$$$0(3);
                    }
                    return promise;
                }
                m = (Method)methodClass.getFirst();
                if (m.getReturnType().isAssignableFrom(Promise.class)) break block17;
                context.error("Method " + String.valueOf(methodClass.getSecond()) + ":" + methodName + " must return Promise object", this.getLine());
                Promise promise = Promises.rejectedPromise();
                if (promise == null) {
                    CallCommand.$$$reportNull$$$0(4);
                }
                return promise;
            }
            Object[] actualArgs = noArgs ? new Object[1] : new Object[args.length + 1];
            actualArgs[0] = context;
            System.arraycopy(args, 0, actualArgs, 1, actualArgs.length - 1);
            result2 = (Promise)m.invoke(null, actualArgs);
            if (result2 != null) break block18;
            context.error("Method " + String.valueOf(methodClass.getSecond()) + ":" + methodName + " must return AsyncResult object, but was null", this.getLine());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                CallCommand.$$$reportNull$$$0(5);
            }
            return promise;
        }
        try {
            result2.onSuccess(s -> {
                if (s != null) {
                    context.message((String)s, this.getLine());
                }
                cmdResult.setResult(null);
            }).onError(error -> {
                context.error(error.getMessage(), this.getLine());
                cmdResult.setError(error);
            });
        }
        catch (InvocationTargetException ignored) {
            context.error("InvocationTargetException while executing command: " + cmd, this.getLine());
        }
        catch (IllegalAccessException ignored) {
            context.error("IllegalAccessException while executing command: " + cmd, this.getLine());
        }
        AsyncPromise asyncPromise = cmdResult;
        if (asyncPromise == null) {
            CallCommand.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    private static Pair<Method, Class<?>> findMethod(PlaybackContext context, String methodName, Class[] types) {
        Set<Class<?>> classes = context.getCallClasses();
        for (Class<?> eachClass : classes) {
            try {
                Method method = eachClass.getMethod(methodName, types);
                return Pair.create((Object)method, eachClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/CallCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/CallCommand";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

