/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public enum ExternalUpdateManager {
    TOOLBOX("Toolbox App"),
    SNAP("Snap"),
    BREW("Homebrew"),
    UNKNOWN(null);

    @NlsSafe
    public final String toolName;
    @Nullable
    public static final ExternalUpdateManager ACTUAL;

    private ExternalUpdateManager(String name2) {
        this.toolName = name2 != null ? name2 : ("true".equalsIgnoreCase(name2 = System.getProperty("ide.no.platform.update")) ? "(unknown)" : name2);
    }

    @ApiStatus.Internal
    public static boolean isCreatingDesktopEntries() {
        return ACTUAL == TOOLBOX || ACTUAL == SNAP;
    }

    static {
        String home = PathManager.getHomePath().replace('\\', '/');
        String toolboxV2Path = System.getProperty("ide.managed.by.toolbox");
        ACTUAL = home.contains("/apps/") && home.contains("/ch-") ? TOOLBOX : (toolboxV2Path != null && Files.exists(Path.of(toolboxV2Path, new String[0]), new LinkOption[0]) ? TOOLBOX : (OS.CURRENT == OS.Linux && (home.startsWith("/snap/") || home.startsWith("/var/lib/snapd/snap/")) ? SNAP : (OS.CURRENT != OS.Windows && home.contains("/homebrew/") ? BREW : (System.getProperty("ide.no.platform.update") != null ? UNKNOWN : null))));
        Logger.getInstance(ExternalUpdateManager.class).info("update manager: " + (ACTUAL == null ? "-" : ExternalUpdateManager.ACTUAL.toolName));
    }
}

