/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.BrokenPluginFileKt;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginDependencyImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.ide.plugins.marketplace.utils.MarketplaceUrls;
import com.intellij.ide.plugins.newui.PluginDependencyModel;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    private final PluginId myPluginId;
    @Nullable
    private final String myPluginName;
    @Nullable
    private final String myProductCode;
    @Nullable
    private final Date myReleaseDate;
    private final int myReleaseVersion;
    private final boolean myLicenseOptional;
    private final String myDescription;
    private final List<PluginDependencyModel> myDependencies;
    private final String myPluginUrl;
    private final BuildNumber myBuildNumber;
    private final Consumer<@NlsContexts.NotificationContent @NotNull String> myErrorsConsumer;
    @Nullable
    private final MarketplacePluginDownloadService myDownloadService;
    @NlsSafe
    private String myPluginVersion;
    private PluginUiModel myModel;
    private IdeaPluginDescriptor myDescriptor;
    private Path myFile;
    private Path myOldFile;
    private boolean myShownErrors;

    private PluginDownloader(PluginUiModel model2, String pluginUrl, @Nullable BuildNumber buildNumber, Consumer<@NlsContexts.NotificationContent @NotNull String> errorsConsumer, @Nullable MarketplacePluginDownloadService service) {
        this.myPluginId = model2.getPluginId();
        this.myPluginName = model2.getName();
        this.myProductCode = model2.getProductCode();
        this.myReleaseDate = model2.getReleaseDate() != null ? Date.from(Instant.ofEpochMilli(model2.getReleaseDate())) : null;
        this.myReleaseVersion = model2.getReleaseVersion();
        this.myLicenseOptional = model2.isLicenseOptional();
        this.myDescription = model2.getDescription();
        this.myDependencies = model2.getDependencies();
        this.myPluginUrl = pluginUrl;
        this.myBuildNumber = buildNumber;
        this.myPluginVersion = model2.getVersion();
        this.myDescriptor = model2.getDescriptor();
        this.myModel = model2;
        this.myErrorsConsumer = errorsConsumer;
        this.myDownloadService = service;
    }

    @NotNull
    public PluginDownloader withErrorsConsumer(@NotNull @NotNull Consumer<@NlsContexts.NotificationContent @NotNull String> errorsConsumer) {
        if (errorsConsumer == null) {
            PluginDownloader.$$$reportNull$$$0(0);
        }
        return new PluginDownloader(this.myModel, this.myPluginUrl, this.myBuildNumber, errorsConsumer, this.myDownloadService);
    }

    @NotNull
    public PluginDownloader withDownloadService(@Nullable MarketplacePluginDownloadService downloadService) {
        return new PluginDownloader(this.myModel, this.myPluginUrl, this.myBuildNumber, this.myErrorsConsumer, downloadService);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String getPluginId() {
        String string = this.myPluginId.getIdString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PluginId getId() {
        PluginId pluginId = this.myPluginId;
        if (pluginId == null) {
            PluginDownloader.$$$reportNull$$$0(2);
        }
        return pluginId;
    }

    @NlsSafe
    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @NlsSafe
    @NotNull
    public String getPluginName() {
        String string = this.myPluginName != null ? this.myPluginName : this.myPluginId.getIdString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    @Nullable
    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    public boolean isFromMarketplace() {
        try {
            return new URL(this.myPluginUrl).getHost().equals(new URL("https://plugins.jetbrains.com").getHost());
        }
        catch (MalformedURLException ignored) {
            return false;
        }
    }

    public boolean isLicenseOptional() {
        return this.myLicenseOptional;
    }

    @Nullable
    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public IdeaPluginDescriptor getDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myDescriptor;
        if (ideaPluginDescriptor == null) {
            PluginDownloader.$$$reportNull$$$0(4);
        }
        return ideaPluginDescriptor;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginUiModel getUiModel() {
        return this.myModel;
    }

    @NotNull
    public Path getFilePath() throws IOException {
        if (this.myFile != null) {
            Path path = this.myFile;
            if (path == null) {
                PluginDownloader.$$$reportNull$$$0(5);
            }
            return path;
        }
        throw new IOException("Plugin '" + this.getPluginName() + "' was not successfully downloaded");
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    public boolean prepareToInstall(@Nullable ProgressIndicator indicator2) throws IOException {
        ThreadingAssertions.assertBackgroundThread();
        this.myShownErrors = false;
        if (this.myFile != null) {
            IdeaPluginDescriptorImpl actualDescriptor = this.loadDescriptorFromArtifact();
            if (actualDescriptor == null) {
                this.reportError(IdeBundle.message((String)"error.descriptor.load.failed", (Object[])new Object[]{this.myFile}));
                return false;
            }
            this.myDescriptor = actualDescriptor;
            return true;
        }
        IdeaPluginDescriptor descriptor = null;
        if (PluginManagerCore.isPluginInstalled((PluginId)this.myPluginId)) {
            descriptor = PluginManagerCore.getPlugin((PluginId)this.myPluginId);
            LOG.assertTrue(descriptor != null);
            if (this.myPluginVersion != null) {
                int result2 = PluginDownloader.compareVersionsSkipBrokenAndIncompatible(this.myPluginVersion, descriptor);
                if (result2 < 0 && this.isDowngradeAllowed(descriptor)) {
                    LOG.info("Preparing to downgrade plugin '" + String.valueOf(this.myPluginId) + "' : " + this.myPluginVersion + " -> " + descriptor.getVersion());
                } else if (result2 <= 0) {
                    LOG.info("Preparing: plugin " + String.valueOf(this.myPluginId) + ": current version (max) " + this.myPluginVersion);
                    return false;
                }
            }
            this.myOldFile = descriptor.isBundled() ? null : descriptor.getPluginPath();
        }
        try {
            this.myFile = this.tryDownloadPlugin(indicator2);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            this.reportError(message != null ? message : IdeBundle.message((String)"unknown.error", (Object[])new Object[0]));
            return false;
        }
        boolean loaded = LoadingState.COMPONENTS_LOADED.isOccurred();
        if (loaded && !PluginSignatureChecker.verifyIfRequired(this.myDescriptor, this.myFile, this.isFromMarketplace(), true)) {
            this.myShownErrors = true;
            return false;
        }
        IdeaPluginDescriptorImpl actualDescriptor = this.loadDescriptorFromArtifact();
        if (actualDescriptor == null) {
            this.reportError(IdeBundle.message((String)"error.downloaded.descriptor.load.failed", (Object[])new Object[0]));
            return false;
        }
        if (loaded && InstalledPluginsState.getInstance().wasUpdated(actualDescriptor.getPluginId())) {
            this.reportError(IdeBundle.message((String)"error.pending.update", (Object[])new Object[]{this.getPluginName()}));
            return false;
        }
        this.myPluginVersion = actualDescriptor.getVersion();
        if (descriptor != null) {
            int result3 = PluginDownloader.compareVersionsSkipBrokenAndIncompatible(this.myPluginVersion, descriptor);
            if (result3 < 0 && this.isDowngradeAllowed(descriptor)) {
                LOG.info("Downgrading plugin '" + String.valueOf(this.myPluginId) + "' : " + this.myPluginVersion + " -> " + descriptor.getVersion());
            } else if (result3 <= 0) {
                LOG.info("Plugin " + String.valueOf(this.myPluginId) + ": current version (max) " + this.myPluginVersion);
                this.reportError(IdeBundle.message((String)"error.older.update", (Object[])new Object[]{this.myPluginVersion, descriptor.getVersion()}));
                return false;
            }
        }
        this.myDescriptor = actualDescriptor;
        BuildNumber buildNumber = this.myBuildNumber != null ? this.myBuildNumber : PluginManagerCore.getBuildNumber();
        PluginNonLoadReason incompatibleError = PluginManagerCore.checkBuildNumberCompatibility((IdeaPluginDescriptor)actualDescriptor, (BuildNumber)buildNumber);
        if (incompatibleError != null) {
            LOG.info("Plugin " + String.valueOf(this.myPluginId) + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
            this.reportError(IdeBundle.message((String)"error.incompatible.update", (Object[])new Object[]{XmlStringUtil.escapeString((String)incompatibleError.getDetailedMessage())}));
            return false;
        }
        return true;
    }

    private boolean isDowngradeAllowed(IdeaPluginDescriptor localDescriptor) {
        return PluginManagementPolicy.getInstance().isDowngradeAllowed(localDescriptor, this.myDescriptor);
    }

    @Nullable
    private IdeaPluginDescriptorImpl loadDescriptorFromArtifact() throws IOException {
        ThreadingAssertions.assertBackgroundThread();
        if (this.myBuildNumber == null) {
            return PluginDescriptorLoader.loadDescriptorFromArtifact((Path)this.getFilePath(), null);
        }
        return PluginDescriptorLoader.readBasicDescriptorDataFromArtifact((Path)this.getFilePath());
    }

    private void reportError(@NlsContexts.NotificationContent String errorMessage) {
        LOG.info("PluginDownloader error: " + errorMessage);
        this.myShownErrors = true;
        this.myErrorsConsumer.accept(IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage}));
    }

    public void install() throws IOException {
        PluginInstaller.installAfterRestartAndKeepIfNecessary(this.myDescriptor, this.getFilePath(), this.myOldFile);
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            boolean isInstalled = PluginManagerCore.isPluginInstalled((PluginId)this.myDescriptor.getPluginId());
            InstalledPluginsState.getInstance().onPluginInstall(this.myDescriptor, isInstalled, true);
        } else {
            InstalledPluginsState.addPreInstalledPlugin(this.myDescriptor);
        }
    }

    public boolean installDynamically(@Nullable JComponent ownerComponent) throws IOException {
        boolean appliedWithoutRestart;
        assert (this.myDescriptor instanceof IdeaPluginDescriptorImpl);
        IdeaPluginDescriptorImpl descriptor = (IdeaPluginDescriptorImpl)this.myDescriptor;
        boolean bl = appliedWithoutRestart = DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor) && (this.myOldFile == null || PluginDownloader.unloadDescriptorById(descriptor.getPluginId())) && PluginInstaller.installAndLoadDynamicPlugin(this.getFilePath(), ownerComponent, descriptor);
        if (!appliedWithoutRestart) {
            this.install();
        }
        return appliedWithoutRestart;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public Path tryDownloadPlugin(@Nullable ProgressIndicator indicator2) throws IOException {
        ThreadingAssertions.assertBackgroundThread();
        if (indicator2 != null) {
            indicator2.checkCanceled();
            indicator2.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        }
        LOG.info("downloading plugin " + this.myPluginName + "(" + String.valueOf(this.myPluginId) + ") version " + this.myPluginVersion + " from " + this.myPluginUrl);
        MarketplacePluginDownloadService downloader = this.myDownloadService != null ? this.myDownloadService : new MarketplacePluginDownloadService();
        Path path = this.myOldFile != null ? downloader.downloadPluginViaBlockMap(this.myPluginUrl, this.myOldFile, indicator2) : downloader.downloadPlugin(this.myPluginUrl, indicator2);
        if (path == null) {
            PluginDownloader.$$$reportNull$$$0(6);
        }
        return path;
    }

    @ApiStatus.Internal
    public boolean checkPluginCanBeDownloaded(@Nullable ProgressIndicator indicator2) {
        MarketplacePluginDownloadService downloader = this.myDownloadService != null ? this.myDownloadService : new MarketplacePluginDownloadService();
        return downloader.checkPluginCanBeDownloaded(this.myPluginUrl, indicator2);
    }

    @NotNull
    public PluginNode toPluginNode() {
        IdeaPluginDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof PluginNode) {
            PluginNode pluginNode = (PluginNode)descriptor;
            if (pluginNode == null) {
                PluginDownloader.$$$reportNull$$$0(7);
            }
            return pluginNode;
        }
        PluginNode node = new PluginNode(this.getId());
        node.setName(this.getPluginName());
        node.setProductCode(this.getProductCode());
        node.setReleaseDate(this.getReleaseDate());
        node.setReleaseVersion(this.getReleaseVersion());
        node.setLicenseOptional(this.isLicenseOptional());
        node.setVersion(this.getPluginVersion());
        node.setDownloadUrl(this.myPluginUrl);
        List dependencies = ContainerUtil.map(this.myDependencies, dep -> new PluginDependencyImpl(dep.getPluginId(), null, dep.isOptional()));
        node.setDependencies(dependencies);
        node.setDescription(this.myDescription);
        PluginNode pluginNode = node;
        if (pluginNode == null) {
            PluginDownloader.$$$reportNull$$$0(8);
        }
        return pluginNode;
    }

    void setOldFile(@Nullable Path oldFile) {
        this.myOldFile = oldFile;
    }

    public static String getMarketplaceDownloadsUUID() {
        try {
            return DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)"MarketplaceDownloads");
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException e) {
            return "";
        }
    }

    public static void showErrorDialog(@NlsContexts.NotificationContent @NotNull String text2) {
        Application app;
        if (text2 == null) {
            PluginDownloader.$$$reportNull$$$0(9);
        }
        if ((app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            app.invokeLater(() -> Messages.showErrorDialog((String)text2, (String)IdeBundle.message((String)"title.plugin.installation", (Object[])new Object[0])), ModalityState.any());
        }
    }

    public static int compareVersionsSkipBrokenAndIncompatible(String newPluginVersion, @NotNull IdeaPluginDescriptor existingPlugin) {
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(10);
        }
        return PluginDownloader.compareVersionsSkipBrokenAndIncompatible(newPluginVersion, existingPlugin, null);
    }

    public static int compareVersionsSkipBrokenAndIncompatible(String newPluginVersion, @NotNull IdeaPluginDescriptor existingPlugin, @Nullable BuildNumber newBuildNumber) {
        int state2;
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(11);
        }
        if ((state2 = VersionComparatorUtil.compare((String)newPluginVersion, (String)existingPlugin.getVersion())) < 0 && (BrokenPluginFileKt.isBrokenPlugin((IdeaPluginDescriptor)existingPlugin) || PluginManagerCore.isIncompatible((IdeaPluginDescriptor)existingPlugin, (BuildNumber)newBuildNumber))) {
            state2 = 1;
        }
        return state2;
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor) throws IOException {
        if (descriptor == null) {
            PluginDownloader.$$$reportNull$$$0(12);
        }
        return PluginDownloader.createDownloader(descriptor, null, null);
    }

    private static boolean unloadDescriptorById(PluginId pluginId) {
        IdeaPluginDescriptorImpl descriptor = PluginManagerCore.findPlugin((PluginId)pluginId);
        return descriptor != null && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor) && DynamicPlugins.INSTANCE.unloadPlugin(descriptor, new DynamicPlugins.UnloadPluginOptions().withDisable(false).withUpdate(true).withWaitForClassloaderUnload(true));
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginDownloader createDownloader(@NotNull PluginUiModel pluginUiModel, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        if (pluginUiModel == null) {
            PluginDownloader.$$$reportNull$$$0(13);
        }
        return PluginDownloader.createDownloader(pluginUiModel, host, buildNumber, pluginUiModel.getDownloadUrl(), pluginUiModel.isFromMarketplace());
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        boolean fromMarketplace;
        if (descriptor == null) {
            PluginDownloader.$$$reportNull$$$0(14);
        }
        String downloadUrl = (fromMarketplace = descriptor instanceof PluginNode) ? ((PluginNode)descriptor).getDownloadUrl() : null;
        return PluginDownloader.createDownloader(new PluginUiModelAdapter(descriptor), host, buildNumber, downloadUrl, fromMarketplace);
    }

    @NotNull
    private static PluginDownloader createDownloader(@NotNull PluginUiModel descriptor, @Nullable String host, @Nullable BuildNumber buildNumber, @Nullable String downloadUrl, boolean isFromMarketplace) throws IOException {
        if (descriptor == null) {
            PluginDownloader.$$$reportNull$$$0(15);
        }
        IdeaPluginDescriptor currentVersion = PluginManagerCore.getPlugin((PluginId)descriptor.getPluginId());
        String url = isFromMarketplace && host != null ? PluginDownloader.toAbsoluteUrl(downloadUrl, host) : MarketplaceUrls.getPluginDownloadUrl(descriptor, PluginDownloader.getMarketplaceDownloadsUUID(), buildNumber, currentVersion);
        return new PluginDownloader(descriptor, url, buildNumber, PluginDownloader::showErrorDialog, null);
    }

    private static String toAbsoluteUrl(String downloadUrl, String host) throws IOException {
        try {
            return new URL(new URL(host), downloadUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsConsumer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPlugin";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginUiModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryDownloadPlugin";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toPluginNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withErrorsConsumer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareVersionsSkipBrokenAndIncompatible";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDownloader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

