/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialogPluginInstaller;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@ApiStatus.Internal
public final class PluginsAdvertiserDialog
extends DialogWrapper {
    private final Collection<PluginDownloader> myPluginToInstall;
    @Nullable
    private final Project myProject;
    @NotNull
    private final List<PluginNode> myCustomPlugins;
    @Nullable
    private final Consumer<Boolean> myFinishFunction;
    private final boolean mySelectAllSuggestions;
    @Nullable
    private DetectedPluginsPanel myPanel;

    PluginsAdvertiserDialog(@Nullable Project project2, @NotNull Collection<PluginDownloader> pluginsToInstall, @NotNull List<PluginNode> customPlugins2, boolean selectAllSuggestions, @Nullable Consumer<Boolean> finishFunction) {
        if (pluginsToInstall == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(0);
        }
        if (customPlugins2 == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myProject = project2;
        this.myPluginToInstall = pluginsToInstall;
        this.myCustomPlugins = customPlugins2;
        this.myFinishFunction = finishFunction;
        this.mySelectAllSuggestions = selectAllSuggestions;
        this.setTitle(IdeBundle.message((String)"dialog.title.choose.plugins.to.install.or.enable", (Object[])new Object[0]));
        this.init();
        JRootPane rootPane = this.getPeer().getRootPane();
        if (rootPane != null) {
            rootPane.setPreferredSize((Dimension)new JBDimension(800, 600));
        }
    }

    public PluginsAdvertiserDialog(@Nullable Project project2, @NotNull Collection<PluginDownloader> pluginsToInstall, @NotNull List<PluginNode> customPlugins2) {
        if (pluginsToInstall == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(2);
        }
        if (customPlugins2 == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(3);
        }
        this(project2, pluginsToInstall, customPlugins2, false, null);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        if (this.myPanel == null) {
            this.myPanel = new DetectedPluginsPanel(this.myProject);
            boolean checkAll = this.mySelectAllSuggestions || this.myPluginToInstall.size() == 1;
            for (PluginDownloader downloader : this.myPluginToInstall) {
                this.myPanel.setChecked(downloader, checkAll);
            }
            this.myPanel.addAll(this.myPluginToInstall);
        }
        DetectedPluginsPanel detectedPluginsPanel = this.myPanel;
        if (detectedPluginsPanel == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(4);
        }
        return detectedPluginsPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    protected void doOKAction() {
        assert (this.myPanel != null);
        if (this.doInstallPlugins(this.myPanel::isChecked, ModalityState.stateForComponent((Component)((Object)this.myPanel)))) {
            super.doOKAction();
        }
    }

    public void doInstallPlugins(boolean showDialog, @Nullable ModalityState modalityState) {
        if (showDialog) {
            this.showAndGet();
        } else {
            this.doInstallPlugins(__ -> true, modalityState != null ? modalityState : ModalityState.nonModal());
        }
    }

    private boolean doInstallPlugins(@NotNull Predicate<? super PluginDownloader> predicate, @NotNull ModalityState modalityState) {
        if (predicate == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(6);
        }
        return new PluginsAdvertiserDialogPluginInstaller(this.myProject, this.myPluginToInstall, this.myCustomPlugins, this.myFinishFunction).doInstallPlugins(predicate, modalityState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doInstallPlugins";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

