/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.NotNull;

final class RefreshProgress
extends ProgressIndicatorBase {
    RefreshProgress() {
    }

    @NotNull
    static ProgressIndicator create() {
        return ApplicationManager.getApplication().isUnitTestMode() ? new EmptyProgressIndicator() : new RefreshProgress();
    }

    public void start() {
        String text2 = this.getText();
        super.start();
        this.setText(text2);
        this.scheduleUiUpdate();
    }

    public void stop() {
        super.stop();
        this.scheduleUiUpdate();
    }

    private void scheduleUiUpdate() {
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            WindowManager windowManager = WindowManager.getInstance();
            if (windowManager == null) {
                return;
            }
            for (IdeFrame frame : windowManager.getAllProjectFrames()) {
                StatusBar statusBar = frame.getStatusBar();
                if (statusBar == null) continue;
                if (this.isRunning()) {
                    statusBar.startRefreshIndication(this.getText());
                    continue;
                }
                statusBar.stopRefreshIndication();
            }
        }, ModalityState.any(), app.getDisposed());
    }
}

