/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.RefreshWorker;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.monitoring.VfsUsageCollector;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.EDT;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 Z2\u00020\u00012\u00020\u0002:\u0001ZB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001cJB\u0010\u001d\u001a\u00020\u001a*\u00020\u00042\u0006\u0010\u001e\u001a\u00020\t2'\u0010\u001f\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0!\u0012\u0006\u0012\u0004\u0018\u00010\"0 \u00a2\u0006\u0002\b#H\u0002\u00a2\u0006\u0002\u0010$J:\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u001b\u001a\u00020\u00102\u001c\u0010\u001f\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0!\u0012\u0006\u0012\u0004\u0018\u00010\"0'H\u0082@\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b,\u0010-J$\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0082@\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J$\u00105\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\f\u00106\u001a\b\u0012\u0004\u0012\u0002000/H\u0082@\u00a2\u0006\u0002\u00107JV\u00108\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020:09\u0012\n\u0012\b\u0012\u0004\u0012\u00020;090\u00182\u0006\u0010\u001b\u001a\u00020\u00102\f\u00106\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020>H\u0003JL\u0010A\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010=\u001a\u00020>2\u0006\u0010@\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\f\u00106\u001a\b\u0012\u0004\u0012\u00020:092\f\u0010B\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u0010C\u001a\u00020DH\u0003J&\u0010E\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00172\f\u00106\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J\u0017\u0010F\u001a\u00020\u001a2\r\u0010G\u001a\t\u0018\u00010H\u00a2\u0006\u0002\bIH\u0002J\b\u0010J\u001a\u00020\u001aH\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0002J*\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020D2\u0006\u0010O\u001a\u00020D2\b\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\u0017H\u0016J\u001e\u0010E\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020D2\f\u00106\u001a\b\u0012\u0004\u0012\u00020009H\u0016J\b\u0010S\u001a\u00020\u001aH\u0016J$\u0010T\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020D2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V09H\u0096@\u00a2\u0006\u0002\u0010WJ\u001c\u0010E\u001a\u00020\u001a2\f\u00106\u001a\b\u0012\u0004\u0012\u00020009H\u0096@\u00a2\u0006\u0002\u0010XJ\b\u0010Y\u001a\u00020DH\u0002R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/intellij/openapi/vfs/newvfs/RefreshQueueImpl;", "Lcom/intellij/openapi/vfs/newvfs/RefreshQueue;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "eventScanningScope", "eventScanSemaphore", "Lkotlinx/coroutines/sync/Semaphore;", "eventProcessingScope", "myRefreshIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lorg/jetbrains/annotations/NotNull;", "mySessions", "", "Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;", "myEventCounter", "Lcom/intellij/openapi/diagnostic/FrequentEventDetector;", "myActivityCounter", "", "parallelizationCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/application/ModalityState;", "Lkotlin/Pair;", "execute", "", "session", "execute$intellij_platform_ide_impl", "launchWithPermit", "semaphore", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/sync/Semaphore;Lkotlin/jvm/functions/Function2;)V", "executeWithParallelizationGuard", "T", "Lkotlin/Function1;", "(Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queueSession", "modality", "executeSuspending", "executeSuspending$intellij_platform_ide_impl", "(Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectEventsSuspending", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "timeInQueue", "", "(Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queueAsyncSessionWithCoroutines", "processEventsSuspending", "events", "(Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectChangeAppliersInReadAction", "", "Lcom/intellij/openapi/vfs/newvfs/CompoundVFileEvent;", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "evQueuedAt", "evTimeInQueue", "Ljava/util/concurrent/atomic/AtomicLong;", "evRetries", "evListenerTime", "doFireEvents", "changeAppliers", "backgroundWriteAction", "", "processEvents", "startIndicator", "text", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "stopIndicator", "runRefreshSession", "createSession", "Lcom/intellij/openapi/vfs/newvfs/RefreshSession;", "async", "recursive", "finishRunnable", "Ljava/lang/Runnable;", "state", "dispose", "refresh", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "(ZLjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isVfsRefreshInBackgroundWriteActionAllowed", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRefreshQueueImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshQueueImpl.kt\ncom/intellij/openapi/vfs/newvfs/RefreshQueueImpl\n+ 2 Semaphore.kt\nkotlinx/coroutines/sync/SemaphoreKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,448:1\n81#2,6:449\n1869#3,2:455\n1869#3,2:457\n374#4:459\n374#4:460\n*S KotlinDebug\n*F\n+ 1 RefreshQueueImpl.kt\ncom/intellij/openapi/vfs/newvfs/RefreshQueueImpl\n*L\n138#1:449,6\n324#1:455,2\n325#1:457,2\n416#1:459\n432#1:460\n*E\n"})
public final class RefreshQueueImpl
extends RefreshQueue
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope eventScanningScope;
    @NotNull
    private final Semaphore eventScanSemaphore;
    @NotNull
    private final CoroutineScope eventProcessingScope;
    @NotNull
    private final ProgressIndicator myRefreshIndicator;
    @NotNull
    private final Set<RefreshSessionImpl> mySessions;
    @NotNull
    private final FrequentEventDetector myEventCounter;
    private int myActivityCounter;
    @NotNull
    private final ConcurrentHashMap<ModalityState, Pair<Semaphore, Integer>> parallelizationCache;
    @NotNull
    private static final Logger LOG;

    public RefreshQueueImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.eventScanningScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"RefreshQueue pool", (CoroutineContext)((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getDefault(), (int)1, null, (int)2, null)), (boolean)false, (int)4, null);
        this.eventScanSemaphore = SemaphoreKt.Semaphore$default((int)1, (int)0, (int)2, null);
        this.eventProcessingScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"RefreshQueue pool", (CoroutineContext)((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getDefault(), (int)1, null, (int)2, null)), (boolean)false, (int)4, null);
        ProgressIndicator progressIndicator = RefreshProgress.create();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"create(...)");
        this.myRefreshIndicator = progressIndicator;
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.mySessions = set;
        this.myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.WARN);
        this.parallelizationCache = new ConcurrentHashMap();
    }

    public final void execute$intellij_platform_ide_impl(@NotNull RefreshSessionImpl session) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        if (session.isAsynchronous()) {
            if (this.isVfsRefreshInBackgroundWriteActionAllowed() && Intrinsics.areEqual((Object)session.getModality(), (Object)ModalityState.nonModal())) {
                this.queueAsyncSessionWithCoroutines(session);
            } else {
                this.queueSession(session, session.getModality());
            }
        } else if (EDT.isCurrentThreadEdt() || ApplicationManager.getApplication().isWriteAccessAllowed()) {
            TransactionGuard transactionGuard = TransactionGuard.getInstance();
            Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
            ((TransactionGuardImpl)transactionGuard).assertWriteActionAllowed();
            Collection<VFileEvent> events = this.runRefreshSession(session, -1L);
            RefreshQueueImpl.Companion.fireEvents(events, session);
        } else if (ApplicationManager.getApplication().holdsReadLock()) {
            LOG.error("Do not perform a synchronous refresh under read lock (causes deadlocks if there are events to fire)");
        } else {
            this.queueSession(session, session.getModality());
            session.waitFor();
        }
    }

    private final void launchWithPermit(CoroutineScope $this$launchWithPermit, Semaphore semaphore, Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> action2) {
        BuildersKt.launch$default((CoroutineScope)$this$launchWithPermit, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(semaphore, action2, null){
            Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ Semaphore $semaphore;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $action;
            {
                this.$semaphore = $semaphore;
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$semaphore;
                        var3_4 = this.$action;
                        $i$f$withPermit = 0;
                        this.L$0 = $this$withPermit$iv;
                        this.L$1 = var3_4;
                        this.I$0 = $i$f$withPermit;
                        this.label = 1;
                        v0 = $this$withPermit$iv.acquire((Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$f$withPermit = this.I$0;
                        var3_4 = (Function2<CoroutineScope, Continuation<? super Unit>, Object>)this.L$1;
                        $this$withPermit$iv = (Semaphore)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 3 sources

                        $i$a$-withPermit-RefreshQueueImpl$launchWithPermit$1$1 = 0;
                        this.L$0 = $this$withPermit$iv;
                        this.L$1 = null;
                        this.I$0 = $i$f$withPermit;
                        this.I$1 = $i$a$-withPermit-RefreshQueueImpl$launchWithPermit$1$1;
                        this.label = 2;
                        v1 = kotlinx.coroutines.CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var3_4, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $action;
                            {
                                this.$action = $action;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$coroutineScope;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                                        this.label = 1;
                                        Object object2 = this.$action.invoke((Object)$this$coroutineScope, (Object)((Object)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        ** if (v1 != var7_2) goto lbl33
lbl32:
                        // 1 sources

                        return var7_2;
lbl33:
                        // 1 sources

                        ** GOTO lbl42
                    }
                    case 2: {
                        $i$a$-withPermit-RefreshQueueImpl$launchWithPermit$1$1 = this.I$1;
                        $i$f$withPermit = this.I$0;
                        $this$withPermit$iv = (Semaphore)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl42:
                            // 2 sources

                            var6_10 = Unit.INSTANCE;
                        }
                        catch (Throwable var5_9) {
                            throw var5_9;
                        }
                        finally {
                            $this$withPermit$iv.release();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final <T> Object executeWithParallelizationGuard(RefreshSessionImpl session, Function1<? super Continuation<? super T>, ? extends Object> action2, Continuation<? super T> $completion) {
        return Companion.executeWithParallelizationGuard(session.getModality(), (ConcurrentMap)this.parallelizationCache, action2, $completion);
    }

    private final void queueSession(RefreshSessionImpl session, ModalityState modality) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queue session with id=" + session.hashCode());
        }
        if (session.isEventSession() && !session.isAsynchronous()) {
            this.processEvents(session, session.getModality(), this.runRefreshSession(session, -1L));
        } else {
            long queuedAt = System.nanoTime();
            this.launchWithPermit(this.eventScanningScope, this.eventScanSemaphore, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(queuedAt, this, session, modality, null){
                int label;
                final /* synthetic */ long $queuedAt;
                final /* synthetic */ RefreshQueueImpl this$0;
                final /* synthetic */ RefreshSessionImpl $session;
                final /* synthetic */ ModalityState $modality;
                {
                    this.$queuedAt = $queuedAt;
                    this.this$0 = $receiver;
                    this.$session = $session;
                    this.$modality = $modality;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            long timeInQueue = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.$queuedAt);
                            RefreshQueueImpl.access$startIndicator(this.this$0, IdeCoreBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
                            AtomicReference<V> events = new AtomicReference<V>();
                            try {
                                Object[] objectArray = new Object[]{this.$session};
                                String string = IdeCoreBundle.message((String)"progress.title.doing.file.refresh.0", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                String title2 = string;
                                HeavyProcessLatch.INSTANCE.performOperation(HeavyProcessLatch.Type.Syncing, title2, () -> queueSession.1.invokeSuspend$lambda$0(events, this.this$0, this.$session, timeInQueue));
                            }
                            finally {
                                RefreshQueueImpl.access$stopIndicator(this.this$0);
                                V v = events.get();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
                                RefreshQueueImpl.access$processEvents(this.this$0, this.$session, this.$modality, (Collection)v);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$0(AtomicReference $events, RefreshQueueImpl this$0, RefreshSessionImpl $session, long $timeInQueue) {
                    $events.set(RefreshQueueImpl.access$runRefreshSession(this$0, $session, $timeInQueue));
                }
            }));
        }
        this.myEventCounter.eventHappened((Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeSuspending$intellij_platform_ide_impl(@NotNull RefreshSessionImpl session, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof executeSuspending.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ RefreshQueueImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeSuspending$intellij_platform_ide_impl(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPermit$iv = this.eventScanSemaphore;
                $i$f$withPermit = 0;
                $continuation.L$0 = session;
                $continuation.L$1 = $this$withPermit$iv;
                $continuation.I$0 = $i$f$withPermit;
                $continuation.label = 1;
                v0 = $this$withPermit$iv.acquire((Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$f$withPermit = $continuation.I$0;
                $this$withPermit$iv = (Semaphore)$continuation.L$1;
                session = (RefreshSessionImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 3 sources

                $i$a$-withPermit-RefreshQueueImpl$executeSuspending$events$1 = 0;
                $continuation.L$0 = session;
                $continuation.L$1 = $this$withPermit$iv;
                $continuation.I$0 = $i$f$withPermit;
                $continuation.I$1 = $i$a$-withPermit-RefreshQueueImpl$executeSuspending$events$1;
                $continuation.label = 2;
                v1 = this.collectEventsSuspending(session, -1L, (Continuation<? super Collection<? extends VFileEvent>>)$continuation);
                ** if (v1 != var11_5) goto lbl39
lbl38:
                // 1 sources

                return var11_5;
lbl39:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                $i$a$-withPermit-RefreshQueueImpl$executeSuspending$events$1 = $continuation.I$1;
                $i$f$withPermit = $continuation.I$0;
                $this$withPermit$iv = (Semaphore)$continuation.L$1;
                session = (RefreshSessionImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    var7_11 = (Collection)v1;
                }
                catch (Throwable var8_12) {
                    throw var8_12;
                }
                finally {
                    $this$withPermit$iv.release();
                }
                events = var7_11;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)events);
                $continuation.label = 3;
                v2 = this.executeWithParallelizationGuard(session, (Function1<? super Continuation<? super T>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, session, (Collection<? extends VFileEvent>)events, null){
                    int label;
                    final /* synthetic */ RefreshQueueImpl this$0;
                    final /* synthetic */ RefreshSessionImpl $session;
                    final /* synthetic */ Collection<VFileEvent> $events;
                    {
                        this.this$0 = $receiver;
                        this.$session = $session;
                        this.$events = $events;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = RefreshQueueImpl.access$processEventsSuspending(this.this$0, this.$session, this.$events, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super T>)$continuation);
                if (v2 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl69
            }
            case 3: {
                events = (Collection)$continuation.L$1;
                session = (RefreshSessionImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl69:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object collectEventsSuspending(RefreshSessionImpl session, long timeInQueue, Continuation<? super Collection<? extends VFileEvent>> $completion) {
        Project project2 = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        String string = IdeCoreBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TasksKt.withBackgroundProgress((Project)project2, (String)string, (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends VFileEvent>>, Object>(this, session, timeInQueue, null){
            int label;
            final /* synthetic */ RefreshQueueImpl this$0;
            final /* synthetic */ RefreshSessionImpl $session;
            final /* synthetic */ long $timeInQueue;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                this.$timeInQueue = $timeInQueue;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return RefreshQueueImpl.access$runRefreshSession(this.this$0, this.$session, this.$timeInQueue);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Collection<? extends VFileEvent>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void queueAsyncSessionWithCoroutines(RefreshSessionImpl session) {
        if (!session.isAsynchronous()) {
            boolean $i$a$-check-RefreshQueueImpl$queueAsyncSessionWithCoroutines$32 = false;
            String $i$a$-check-RefreshQueueImpl$queueAsyncSessionWithCoroutines$32 = "Only asynchronous sessions can be queued with coroutines";
            throw new IllegalStateException($i$a$-check-RefreshQueueImpl$queueAsyncSessionWithCoroutines$32.toString());
        }
        if (!Intrinsics.areEqual((Object)session.getModality(), (Object)ModalityState.nonModal())) {
            boolean bl = false;
            String string = "Only sessions in non-modal context can be queued with coroutines. If you need to run your sessions with non-trivial modality, consider using `launchOnShow` for the component and `launch` for the session.";
            throw new IllegalStateException(string.toString());
        }
        long queuedAt = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.launchWithPermit(this.eventScanningScope, this.eventScanSemaphore, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(queuedAt, this, session, null){
            long J$0;
            int label;
            final /* synthetic */ long $queuedAt;
            final /* synthetic */ RefreshQueueImpl this$0;
            final /* synthetic */ RefreshSessionImpl $session;
            {
                this.$queuedAt = $queuedAt;
                this.this$0 = $receiver;
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.J$0 = timeInQueue = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)this.$queuedAt);
                        this.label = 1;
                        v0 = RefreshQueueImpl.access$collectEventsSuspending(this.this$0, this.$session, Duration.getInWholeNanoseconds-impl((long)timeInQueue), (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        timeInQueue = this.J$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        events = (Collection)v0;
                        BuildersKt.launch$default((CoroutineScope)RefreshQueueImpl.access$getEventProcessingScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$session, (Collection<? extends VFileEvent>)events, null){
                            int label;
                            final /* synthetic */ RefreshQueueImpl this$0;
                            final /* synthetic */ RefreshSessionImpl $session;
                            final /* synthetic */ Collection<VFileEvent> $events;
                            {
                                this.this$0 = $receiver;
                                this.$session = $session;
                                this.$events = $events;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = RefreshQueueImpl.access$executeWithParallelizationGuard(this.this$0, this.$session, (Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, this.$session, this.$events, null){
                                            int label;
                                            final /* synthetic */ RefreshQueueImpl this$0;
                                            final /* synthetic */ RefreshSessionImpl $session;
                                            final /* synthetic */ Collection<VFileEvent> $events;
                                            {
                                                this.this$0 = $receiver;
                                                this.$session = $session;
                                                this.$events = $events;
                                                super(1, $completion);
                                            }

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        Object object2 = RefreshQueueImpl.access$processEventsSuspending(this.this$0, this.$session, this.$events, (Continuation)this);
                                                        if (object2 != object) return Unit.INSTANCE;
                                                        return object;
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object2 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(Continuation<? super Unit> p1) {
                                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object processEventsSuspending(RefreshSessionImpl session, Collection<? extends VFileEvent> events, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processEventsSuspending.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RefreshQueueImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RefreshQueueImpl.access$processEventsSuspending(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                evQueuedAt = System.nanoTime();
                evTimeInQueue = new AtomicLong(-1L);
                evListenerTime = new AtomicLong(-1L);
                evRetries = new AtomicLong(0L);
                this.startIndicator(IdeCoreBundle.message((String)"async.events.progress", (Object[])new Object[0]));
                try {
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)session);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)events);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)evTimeInQueue);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)evListenerTime);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)evRetries);
                    $continuation.J$0 = evQueuedAt;
                    $continuation.label = 1;
                    v0 = CoroutinesKt.readAndBackgroundWriteAction((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processEventsSuspending$lambda$0(com.intellij.openapi.vfs.newvfs.RefreshQueueImpl com.intellij.openapi.vfs.newvfs.RefreshSessionImpl java.util.Collection long java.util.concurrent.atomic.AtomicLong java.util.concurrent.atomic.AtomicLong java.util.concurrent.atomic.AtomicLong com.intellij.openapi.application.ReadAndWriteScope ), (Lcom/intellij/openapi/application/ReadAndWriteScope;)Lcom/intellij/openapi/application/ReadResult;)((RefreshQueueImpl)this, (RefreshSessionImpl)session, (Collection)events, (long)evQueuedAt, (AtomicLong)evTimeInQueue, (AtomicLong)evRetries, (AtomicLong)evListenerTime), (Continuation)$continuation);
                    v1 = v0;
                }
                catch (CancellationException e) {
                    throw e;
                    catch (Throwable e) {
                        RefreshQueueImpl.LOG.error(e);
                        return Unit.INSTANCE;
                    }
                }
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl50
            }
            case 1: {
                evQueuedAt = $continuation.J$0;
                evRetries = (AtomicLong)$continuation.L$4;
                evListenerTime = (AtomicLong)$continuation.L$3;
                evTimeInQueue = (AtomicLong)$continuation.L$2;
                events = (Collection)$continuation.L$1;
                session = (RefreshSessionImpl)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
lbl50:
                // 2 sources

                this.stopIndicator();
                return Unit.INSTANCE;
            }
        }
        finally {
            this.stopIndicator();
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresReadLock
    @RequiresBackgroundThread
    private final Pair<List<CompoundVFileEvent>, List<AsyncFileListener.ChangeApplier>> collectChangeAppliersInReadAction(RefreshSessionImpl session, Collection<? extends VFileEvent> events, long evQueuedAt, AtomicLong evTimeInQueue, AtomicLong evRetries, AtomicLong evListenerTime) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start non-blocking action for session with id=" + session.hashCode());
        }
        evTimeInQueue.compareAndSet(-1L, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - evQueuedAt));
        evRetries.incrementAndGet();
        long t = System.nanoTime();
        try {
            Pair result2 = RefreshQueueImpl.Companion.runAsyncListeners(events);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successful finish of non-blocking read action for session with id=" + session.hashCode());
            }
            Pair pair = result2;
            return pair;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Final block of non-blocking read action for  session with id=" + session.hashCode());
            }
            evListenerTime.addAndGet(System.nanoTime() - t);
        }
    }

    @RequiresWriteLock
    private final void doFireEvents(RefreshSessionImpl session, AtomicLong evTimeInQueue, AtomicLong evListenerTime, AtomicLong evRetries, List<CompoundVFileEvent> events, List<? extends AsyncFileListener.ChangeApplier> changeAppliers, boolean backgroundWriteAction) {
        long t = System.nanoTime();
        if (backgroundWriteAction) {
            session.fireEventsInBackgroundWriteAction(events, changeAppliers);
        } else {
            session.fireEvents(events, changeAppliers, true);
        }
        t = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
        VfsUsageCollector.logEventProcessing(evTimeInQueue.longValue(), TimeUnit.NANOSECONDS.toMillis(evListenerTime.longValue()), evRetries.intValue(), t, events.size());
    }

    private final void processEvents(RefreshSessionImpl session, ModalityState modality, Collection<? extends VFileEvent> events) {
        if (Registry.Companion.is("vfs.async.event.processing", true) && !events.isEmpty()) {
            long evQueuedAt = System.nanoTime();
            AtomicLong evTimeInQueue = new AtomicLong(-1L);
            AtomicLong evListenerTime = new AtomicLong(-1L);
            AtomicLong evRetries = new AtomicLong(0L);
            this.startIndicator(IdeCoreBundle.message((String)"async.events.progress", (Object[])new Object[0]));
            v0 = ReadAction.nonBlocking(() -> RefreshQueueImpl.processEvents$lambda$0(this, session, events, evQueuedAt, evTimeInQueue, evRetries, evListenerTime)).expireWith((Disposable)this).wrapProgress(this.myRefreshIndicator).finishOnUiThread(modality, arg_0 -> RefreshQueueImpl.processEvents$lambda$2(arg_0 -> RefreshQueueImpl.processEvents$lambda$1(this, session, evTimeInQueue, evListenerTime, evRetries, arg_0), arg_0)).submit(arg_0 -> RefreshQueueImpl.processEvents$lambda$3(this, session, arg_0)).onProcessed(arg_0 -> RefreshQueueImpl.processEvents$lambda$5(arg_0 -> RefreshQueueImpl.processEvents$lambda$4(this, arg_0), arg_0)).onError(arg_0 -> RefreshQueueImpl.processEvents$lambda$6(this, arg_0));
        } else {
            v0 = AppUIExecutor.onWriteThread((ModalityState)modality).later().submit(() -> RefreshQueueImpl.processEvents$lambda$7(events, session));
        }
    }

    private final synchronized void startIndicator(String text2) {
        int n = this.myActivityCounter;
        this.myActivityCounter = n + 1;
        if (n == 0) {
            this.myRefreshIndicator.setText(text2);
            this.myRefreshIndicator.start();
        }
    }

    private final synchronized void stopIndicator() {
        this.myActivityCounter += -1;
        if (this.myActivityCounter == 0) {
            this.myRefreshIndicator.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<VFileEvent> runRefreshSession(RefreshSessionImpl session, long timeInQueue) {
        try {
            this.mySessions.add(session);
            Collection<VFileEvent> collection = session.scan(timeInQueue);
            return collection;
        }
        finally {
            this.mySessions.remove((Object)session);
        }
    }

    @NotNull
    public RefreshSession createSession(boolean async2, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return new RefreshSessionImpl(async2, recursive, false, finishRunnable, state2);
    }

    public void processEvents(boolean async2, @NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        new RefreshSessionImpl(async2, events).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Job it;
        Set<RefreshSessionImpl> set = this.mySessions;
        synchronized (set) {
            boolean bl = false;
            for (RefreshSessionImpl session : this.mySessions) {
                session.cancel();
            }
            Unit unit = Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = RefreshQueueImpl.Companion.children(this.eventScanningScope);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Job)element$iv;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
        }
        $this$forEach$iv = RefreshQueueImpl.Companion.children(this.eventProcessingScope);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Job)element$iv;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
        }
    }

    @Nullable
    public Object refresh(boolean recursive, @NotNull List<? extends VirtualFile> files2, @NotNull Continuation<? super Unit> $completion) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        RefreshSession session = this.createSession(false, recursive, null, modalityState);
        session.addAllFiles((Collection)files2);
        if (this.isVfsRefreshInBackgroundWriteActionAllowed()) {
            Object object = session.executeInBackgroundWriteAction($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        boolean $i$f$currentCoroutineContext = false;
        JobKt.getJob((CoroutineContext)$completion.getContext()).invokeOnCompletion(arg_0 -> RefreshQueueImpl.refresh$lambda$0(session, arg_0));
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, null){
            int label;
            final /* synthetic */ RefreshSession $session;
            {
                this.$session = $session;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$session.launch();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object processEvents(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        RefreshSession session = this.createSession(false, false, null, modalityState);
        session.addEvents(events);
        if (this.isVfsRefreshInBackgroundWriteActionAllowed()) {
            Object object = session.executeInBackgroundWriteAction($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        boolean $i$f$currentCoroutineContext = false;
        JobKt.getJob((CoroutineContext)$completion.getContext()).invokeOnCompletion(arg_0 -> RefreshQueueImpl.processEvents$lambda$8(session, arg_0));
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, null){
            int label;
            final /* synthetic */ RefreshSession $session;
            {
                this.$session = $session;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$session.launch();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final boolean isVfsRefreshInBackgroundWriteActionAllowed() {
        return ThreadingRuntimeFlagsKt.getUseBackgroundWriteAction() && Registry.Companion.is("vfs.refresh.use.background.write.action");
    }

    private static final ReadResult processEventsSuspending$lambda$0(RefreshQueueImpl this$0, RefreshSessionImpl $session, Collection $events, long $evQueuedAt, AtomicLong $evTimeInQueue, AtomicLong $evRetries, AtomicLong $evListenerTime, ReadAndWriteScope $this$readAndBackgroundWriteAction) {
        Intrinsics.checkNotNullParameter((Object)$this$readAndBackgroundWriteAction, (String)"$this$readAndBackgroundWriteAction");
        this$0.myRefreshIndicator.checkCanceled();
        Pair<List<CompoundVFileEvent>, List<AsyncFileListener.ChangeApplier>> pair = this$0.collectChangeAppliersInReadAction($session, $events, $evQueuedAt, $evTimeInQueue, $evRetries, $evListenerTime);
        List events = (List)pair.component1();
        List changeAppliers = (List)pair.component2();
        if (events.isEmpty() && $session.getMyFinishRunnable$intellij_platform_ide_impl() == null) {
            return $this$readAndBackgroundWriteAction.value((Object)Unit.INSTANCE);
        }
        return $this$readAndBackgroundWriteAction.writeAction(() -> RefreshQueueImpl.processEventsSuspending$lambda$0$0(this$0, $session, $evTimeInQueue, $evListenerTime, $evRetries, events, changeAppliers));
    }

    private static final Unit processEventsSuspending$lambda$0$0(RefreshQueueImpl this$0, RefreshSessionImpl $session, AtomicLong $evTimeInQueue, AtomicLong $evListenerTime, AtomicLong $evRetries, List $events, List $changeAppliers) {
        this$0.doFireEvents($session, $evTimeInQueue, $evListenerTime, $evRetries, $events, $changeAppliers, true);
        return Unit.INSTANCE;
    }

    private static final Pair processEvents$lambda$0(RefreshQueueImpl this$0, RefreshSessionImpl $session, Collection $events, long $evQueuedAt, AtomicLong $evTimeInQueue, AtomicLong $evRetries, AtomicLong $evListenerTime) {
        return this$0.collectChangeAppliersInReadAction($session, $events, $evQueuedAt, $evTimeInQueue, $evRetries, $evListenerTime);
    }

    private static final Unit processEvents$lambda$1(RefreshQueueImpl this$0, RefreshSessionImpl $session, AtomicLong $evTimeInQueue, AtomicLong $evListenerTime, AtomicLong $evRetries, Pair data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this$0.doFireEvents($session, $evTimeInQueue, $evListenerTime, $evRetries, (List)data2.getFirst(), (List)data2.getSecond(), false);
        return Unit.INSTANCE;
    }

    private static final void processEvents$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void processEvents$lambda$3(RefreshQueueImpl this$0, RefreshSessionImpl $session, Runnable it) {
        BuildersKt.launch$default((CoroutineScope)this$0.eventProcessingScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $session, it, null){
            int label;
            final /* synthetic */ RefreshQueueImpl this$0;
            final /* synthetic */ RefreshSessionImpl $session;
            final /* synthetic */ Runnable $it;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RefreshQueueImpl.access$executeWithParallelizationGuard(this.this$0, this.$session, (Function1)new Function1<Continuation<? super Unit>, Object>(this.$it, null){
                            int label;
                            final /* synthetic */ Runnable $it;
                            {
                                this.$it = $it;
                                super(1, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$it.run();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final Unit processEvents$lambda$4(RefreshQueueImpl this$0, Pair it) {
        this$0.stopIndicator();
        return Unit.INSTANCE;
    }

    private static final void processEvents$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void processEvents$lambda$6(RefreshQueueImpl this$0, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!this$0.myRefreshIndicator.isCanceled()) {
            LOG.error(t);
        }
    }

    private static final void processEvents$lambda$7(Collection $events, RefreshSessionImpl $session) {
        RefreshQueueImpl.Companion.fireEvents($events, $session);
    }

    private static final Unit refresh$lambda$0(RefreshSession $session, Throwable it) {
        $session.cancel();
        return Unit.INSTANCE;
    }

    private static final Unit processEvents$lambda$8(RefreshSession $session, Throwable it) {
        $session.cancel();
        return Unit.INSTANCE;
    }

    public static final boolean isRefreshInProgress() {
        return Companion.isRefreshInProgress();
    }

    @ApiStatus.Internal
    public static final boolean isEventProcessingInProgress() {
        return Companion.isEventProcessingInProgress();
    }

    @JvmStatic
    @TestOnly
    public static final void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
        Companion.setTestListener(testListener);
    }

    public static final /* synthetic */ Object access$executeWithParallelizationGuard(RefreshQueueImpl $this, RefreshSessionImpl session, Function1 action2, Continuation $completion) {
        return $this.executeWithParallelizationGuard(session, action2, $completion);
    }

    public static final /* synthetic */ void access$startIndicator(RefreshQueueImpl $this, String text2) {
        $this.startIndicator(text2);
    }

    public static final /* synthetic */ void access$stopIndicator(RefreshQueueImpl $this) {
        $this.stopIndicator();
    }

    public static final /* synthetic */ void access$processEvents(RefreshQueueImpl $this, RefreshSessionImpl session, ModalityState modality, Collection events) {
        $this.processEvents(session, modality, events);
    }

    public static final /* synthetic */ Collection access$runRefreshSession(RefreshQueueImpl $this, RefreshSessionImpl session, long timeInQueue) {
        return $this.runRefreshSession(session, timeInQueue);
    }

    public static final /* synthetic */ Object access$processEventsSuspending(RefreshQueueImpl $this, RefreshSessionImpl session, Collection events, Continuation $completion) {
        return $this.processEventsSuspending(session, events, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$collectEventsSuspending(RefreshQueueImpl $this, RefreshSessionImpl session, long timeInQueue, Continuation $completion) {
        return $this.collectEventsSuspending(session, timeInQueue, (Continuation<? super Collection<? extends VFileEvent>>)$completion);
    }

    static {
        Logger logger = Logger.getInstance(RefreshQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\b0\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u001c\u001a\u00020\f2\u0012\u0010\u001d\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001eH\u0007Jd\u0010 \u001a\u0002H!\"\b\b\u0000\u0010\"*\u00020\u0001\"\u0004\b\u0001\u0010!2\u0006\u0010#\u001a\u0002H\"2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u0002H\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0\u00130%2\u001c\u0010(\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0*\u0012\u0006\u0012\u0004\u0018\u00010\u00010)H\u0087@\u00a2\u0006\u0002\u0010+R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0016\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u00178GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/vfs/newvfs/RefreshQueueImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "children", "", "Lkotlinx/coroutines/Job;", "Lkotlinx/coroutines/CoroutineScope;", "fireEvents", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "session", "Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;", "runAsyncListeners", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/newvfs/CompoundVFileEvent;", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "isRefreshInProgress", "", "isRefreshInProgress$annotations", "()Z", "isEventProcessingInProgress", "isEventProcessingInProgress$annotations", "setTestListener", "testListener", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/vfs/VirtualFile;", "executeWithParallelizationGuard", "R", "T", "key", "map", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlinx/coroutines/sync/Semaphore;", "", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/Object;Ljava/util/concurrent/ConcurrentMap;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nRefreshQueueImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshQueueImpl.kt\ncom/intellij/openapi/vfs/newvfs/RefreshQueueImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 Semaphore.kt\nkotlinx/coroutines/sync/SemaphoreKt\n*L\n1#1,448:1\n1563#2:449\n1634#2,3:450\n1617#2,9:453\n1869#2:462\n1870#2:464\n1626#2:465\n1374#2:466\n1460#2,5:467\n1#3:463\n1#3:474\n72#4,2:472\n81#5,6:475\n*S KotlinDebug\n*F\n+ 1 RefreshQueueImpl.kt\ncom/intellij/openapi/vfs/newvfs/RefreshQueueImpl$Companion\n*L\n337#1:449\n337#1:450,3\n344#1:453,9\n344#1:462\n344#1:464\n344#1:465\n350#1:466\n350#1:467,5\n344#1:463\n389#1:474\n389#1:472,2\n395#1:475,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Job> children(CoroutineScope $this$children) {
            return SequencesKt.toList((Sequence)JobKt.getJob((CoroutineContext)$this$children.getCoroutineContext()).getChildren());
        }

        /*
         * WARNING - void declaration
         */
        private final void fireEvents(Collection<? extends VFileEvent> events, RefreshSessionImpl session) {
            void $this$mapTo$iv$iv;
            long t = System.nanoTime();
            Iterable $this$map$iv = events;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void event;
                VFileEvent vFileEvent = (VFileEvent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CompoundVFileEvent((VFileEvent)event));
            }
            List compoundEvents = (List)destination$iv$iv;
            session.fireEvents(compoundEvents, CollectionsKt.emptyList(), false);
            t = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            VfsUsageCollector.logEventProcessing(-1L, -1L, -1, t, compoundEvents.size());
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<List<CompoundVFileEvent>, List<AsyncFileListener.ChangeApplier>> runAsyncListeners(Collection<? extends VFileEvent> events) {
            void $this$flatMapTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = events;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<CompoundVFileEvent> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CompoundVFileEvent it$iv$iv;
                VirtualFile file2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VFileEvent e = (VFileEvent)element$iv$iv;
                boolean bl2 = false;
                if (e instanceof VFileCreateEvent) {
                    v0 = ((VFileCreateEvent)e).getParent();
                } else {
                    VFileEvent vFileEvent = e;
                    Intrinsics.checkNotNull((Object)vFileEvent);
                    v0 = file2 = vFileEvent.getFile();
                }
                if ((file2 == null || file2.isValid() ? new CompoundVFileEvent(e) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List compoundEvents = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = compoundEvents;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CompoundVFileEvent e = (CompoundVFileEvent)element$iv$iv;
                boolean bl = false;
                SmartList toMap = new SmartList((Collection)e.getInducedEvents());
                toMap.add((Object)e.getFileEvent());
                Iterable list$iv$iv = (Iterable)toMap;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List allEvents = (List)destination$iv$iv2;
            return new Pair((Object)compoundEvents, AsyncEventSupport.runAsyncListeners(allEvents));
        }

        public final boolean isRefreshInProgress() {
            RefreshQueue refreshQueue = RefreshQueue.Companion.getInstance();
            Intrinsics.checkNotNull((Object)refreshQueue, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
            RefreshQueueImpl refreshQueue2 = (RefreshQueueImpl)refreshQueue;
            return !refreshQueue2.mySessions.isEmpty() || !((Collection)this.children(refreshQueue2.eventScanningScope)).isEmpty();
        }

        @JvmStatic
        public static /* synthetic */ void isRefreshInProgress$annotations() {
        }

        @ApiStatus.Internal
        public final boolean isEventProcessingInProgress() {
            RefreshQueue refreshQueue = RefreshQueue.Companion.getInstance();
            Intrinsics.checkNotNull((Object)refreshQueue, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
            RefreshQueueImpl refreshQueue2 = (RefreshQueueImpl)refreshQueue;
            return !((Collection)this.children(refreshQueue2.eventProcessingScope)).isEmpty();
        }

        @JvmStatic
        public static /* synthetic */ void isEventProcessingInProgress$annotations() {
        }

        @JvmStatic
        @TestOnly
        public final void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            RefreshWorker.ourTestListener = testListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @VisibleForTesting
        @Nullable
        public final <T, R> Object executeWithParallelizationGuard(@NotNull T key, @NotNull ConcurrentMap<T, Pair<Semaphore, Integer>> map, @NotNull Function1<? super Continuation<? super R>, ? extends Object> action, @NotNull Continuation<? super R> $completion) {
            if (!($completion instanceof executeWithParallelizationGuard.1)) ** GOTO lbl-1000
            var13_5 = $completion;
            if ((var13_5.label & -2147483648) != 0) {
                var13_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.executeWithParallelizationGuard(null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    currentValue = null;
                    do {
                        var6_9 = map;
                        key$iv = key /* !! */ ;
                        $i$f$getOrPut = false;
                        v0 /* !! */  = $this$getOrPut$iv.get(key$iv);
                        if (v0 /* !! */  != null) continue;
                        $i$a$-getOrPut-RefreshQueueImpl$Companion$executeWithParallelizationGuard$2 = false;
                        default$iv /* !! */  = new Pair((Object)SemaphoreKt.Semaphore$default((int)1, (int)0, (int)2, null), (Object)Boxing.boxInt((int)0));
                        $i$a$-let-MapsKt__MapsJVMKt$getOrPut$1$iv = false;
                        v0 /* !! */  = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv /* !! */ );
                        if (v0 /* !! */  != null) continue;
                        v0 /* !! */  = default$iv /* !! */ ;
                    } while (!(replacementResult = map.replace(key /* !! */ , currentValue = (Pair)v0 /* !! */ , newValue = Pair.copy$default((Pair)currentValue, null, (Object)Boxing.boxInt((int)(((Number)currentValue.getSecond()).intValue() + 1)), (int)1, null))));
                    semaphore = (Semaphore)currentValue.getFirst();
                    $this$withPermit$iv = semaphore;
                    $i$f$withPermit = 0;
                    $continuation.L$0 = key /* !! */ ;
                    $continuation.L$1 = map;
                    $continuation.L$2 = action;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentValue);
                    $continuation.L$4 = semaphore;
                    $continuation.L$5 = $this$withPermit$iv;
                    $continuation.I$0 = $i$f$withPermit;
                    $continuation.label = 1;
                    v1 = $this$withPermit$iv.acquire($continuation);
                    ** if (v1 != var14_7) goto lbl44
lbl43:
                    // 1 sources

                    return var14_7;
lbl44:
                    // 1 sources

                    ** GOTO lbl58
                }
                case 1: {
                    $i$f$withPermit = $continuation.I$0;
                    $this$withPermit$iv = (Semaphore)$continuation.L$5;
                    semaphore = (Semaphore)$continuation.L$4;
                    currentValue = (Pair)$continuation.L$3;
                    action = (Function1)$continuation.L$2;
                    map = (ConcurrentMap)$continuation.L$1;
                    key /* !! */  = $continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl58:
                    // 3 sources

                    $i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3 = 0;
                    $continuation.L$0 = key /* !! */ ;
                    $continuation.L$1 = map;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)action);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentValue);
                    $continuation.L$4 = semaphore;
                    $continuation.L$5 = $this$withPermit$iv;
                    $continuation.I$0 = $i$f$withPermit;
                    $continuation.I$1 = $i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3;
                    $continuation.label = 2;
                    v2 = action.invoke($continuation);
                    ** if (v2 != var14_7) goto lbl72
lbl71:
                    // 1 sources

                    return var14_7;
lbl72:
                    // 1 sources

                    ** GOTO lbl88
                }
                case 2: {
                    $i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3 = $continuation.I$1;
                    $i$f$withPermit = $continuation.I$0;
                    $this$withPermit$iv = (Semaphore)$continuation.L$5;
                    semaphore = (Semaphore)$continuation.L$4;
                    currentValue = (Pair)$continuation.L$3;
                    action = (Function1)$continuation.L$2;
                    map = (ConcurrentMap)$continuation.L$1;
                    key /* !! */  = $continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl88:
                        // 2 sources

                        default$iv /* !! */  = v2;
                        ** GOTO lbl95
                        {
                            catch (Throwable $i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3) {
                                throw $i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3;
                            }
                        }
                        finally {
                            $this$withPermit$iv.release();
                        }
lbl95:
                        // 1 sources

                        var7_12 /* !! */  = default$iv /* !! */ ;
                        return var7_12 /* !! */ ;
                    }
                    catch (Throwable var8_15) {
                        throw var8_15;
                    }
                    finally {
                        do {
                            v3 = map.get(key /* !! */ );
                            if (v3 != null) continue;
                            $i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3 = "Required value was null.";
                            throw new IllegalArgumentException($i$a$-withPermit-RefreshQueueImpl$Companion$executeWithParallelizationGuard$3.toString());
                        } while (!(replacementResult = map.replace(key /* !! */ , currentValue = (Pair)v3, newValue = Pair.copy$default((Pair)currentValue, null, (Object)Boxing.boxInt((int)(((Number)currentValue.getSecond()).intValue() - 1)), (int)1, null))));
                        map.remove(key /* !! */ , TuplesKt.to((Object)semaphore, (Object)Boxing.boxInt((int)0)));
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

