/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.system.OS;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FsRoot
extends VirtualDirectoryImpl {
    private final String pathWithOneTrailingSlash;

    @NotNull
    public static FsRoot create(int id2, @NotNull VfsData.Segment segment, @NotNull NewVirtualFileSystem fileSystem, @NotNull String pathBeforeSlash, @NotNull FileAttributes fileAttributes, boolean offlineByDefault, @NotNull String originalDebugPath) throws VfsData.FileAlreadyCreatedException {
        if (segment == null) {
            FsRoot.$$$reportNull$$$0(0);
        }
        if (fileSystem == null) {
            FsRoot.$$$reportNull$$$0(1);
        }
        if (pathBeforeSlash == null) {
            FsRoot.$$$reportNull$$$0(2);
        }
        if (fileAttributes == null) {
            FsRoot.$$$reportNull$$$0(3);
        }
        if (originalDebugPath == null) {
            FsRoot.$$$reportNull$$$0(4);
        }
        if (!FsRoot.looksCanonical(pathBeforeSlash)) {
            throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'. FS: " + String.valueOf(fileSystem) + "; attributes(flags): " + String.valueOf(fileAttributes) + "; original path: '" + originalDebugPath + "'; " + String.valueOf(OS.CURRENT));
        }
        VfsData.DirectoryData directoryData = new VfsData.DirectoryData();
        FsRoot root = new FsRoot(id2, segment, directoryData, fileSystem, pathBeforeSlash);
        directoryData.assignDirectory(root);
        segment.setFlags(id2, -16777216, VirtualFileSystemEntry.VfsDataFlags.toFlags(fileAttributes, offlineByDefault));
        segment.initFileData(id2, directoryData, null);
        FsRoot fsRoot = root;
        if (fsRoot == null) {
            FsRoot.$$$reportNull$$$0(5);
        }
        return fsRoot;
    }

    private FsRoot(int id2, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData directoryData, @NotNull NewVirtualFileSystem fileSystem, @NotNull String pathBeforeSlash) {
        if (segment == null) {
            FsRoot.$$$reportNull$$$0(6);
        }
        if (directoryData == null) {
            FsRoot.$$$reportNull$$$0(7);
        }
        if (fileSystem == null) {
            FsRoot.$$$reportNull$$$0(8);
        }
        if (pathBeforeSlash == null) {
            FsRoot.$$$reportNull$$$0(9);
        }
        super(id2, segment, directoryData, null, fileSystem);
        this.pathWithOneTrailingSlash = pathBeforeSlash + "/";
    }

    @Override
    public void setNewName(@NotNull String newName) {
        if (newName == null) {
            FsRoot.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void setParent(@NotNull VirtualFile newParent) {
        if (newParent == null) {
            FsRoot.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.pathWithOneTrailingSlash;
        if (string == null) {
            FsRoot.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.getFileSystem().getProtocol() + "://" + this.getPath();
        if (string == null) {
            FsRoot.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getFileSystem().extractPresentableUrl(this.getName());
        if (string == null) {
            FsRoot.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i2;
        if (pathBeforeSlash == null) {
            FsRoot.$$$reportNull$$$0(15);
        }
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start2 = 0;
        while ((i2 = pathBeforeSlash.indexOf("..", start2)) != -1) {
            if (!(i2 != 0 && pathBeforeSlash.charAt(i2 - 1) != '/' || i2 != pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i2 + 2) != '/')) {
                return false;
            }
            start2 = i2 + 1;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeSlash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAttributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDebugPath";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FsRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FsRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "looksCanonical";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

