/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.StampedLock;

class FileRecordLock {
    private static final int SEGMENTS_COUNT = 16;
    private static final int SEGMENTS_MASK = 15;
    private final Segment[] segments = new Segment[16];

    FileRecordLock() {
        for (int i2 = 0; i2 < 16; ++i2) {
            this.segments[i2] = new Segment();
        }
    }

    public long lockForWrite(int fileId) {
        Segment lock = this.segmentFor(fileId);
        return lock.writeLock();
    }

    public void unlockForWrite(int fileId, long stamp) {
        Segment lock = this.segmentFor(fileId);
        lock.unlockWrite(stamp);
    }

    public long lockForRead(int fileId) {
        Segment lock = this.segmentFor(fileId);
        return lock.readLock();
    }

    public void unlockForRead(int fileId, long stamp) {
        Segment lock = this.segmentFor(fileId);
        lock.unlockRead(stamp);
    }

    public StampedLock lockFor(int fileId) {
        return this.segmentFor(fileId);
    }

    public void lockForHierarchyUpdate(int fileId) {
        this.segmentFor(fileId).lockHierarchy(fileId);
    }

    public void unlockForHierarchyUpdate(int fileId) {
        this.segmentFor(fileId).unlockHierarchy(fileId);
    }

    private Segment segmentFor(int fileId) {
        return this.segments[fileId & 0xF];
    }

    private static class Segment
    extends StampedLock {
        private final IntSet hierarchyUpdatesInProcess = new IntOpenHashSet();

        private Segment() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockHierarchy(int id2) {
            int turn = 0;
            while (true) {
                long lockStamp = this.writeLock();
                try {
                    if (!this.hierarchyUpdatesInProcess.contains(id2)) {
                        this.hierarchyUpdatesInProcess.add(id2);
                        return;
                    }
                }
                finally {
                    this.unlockWrite(lockStamp);
                }
                if (turn < 64) {
                    Thread.onSpinWait();
                } else {
                    LockSupport.parkNanos(1000L);
                }
                ++turn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlockHierarchy(int id2) {
            long lockStamp = this.writeLock();
            try {
                boolean actuallyRemoved = this.hierarchyUpdatesInProcess.remove(id2);
                if (!actuallyRemoved) {
                    throw new IllegalStateException("Trying to unlock(" + id2 + ") which is not currently locked " + String.valueOf(this.hierarchyUpdatesInProcess));
                }
            }
            finally {
                this.unlockWrite(lockStamp);
            }
        }
    }
}

