/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PersistentFS
extends ManagingFS {
    public static PersistentFS getInstance() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    @NotNull
    protected <P, R> Function<P, R> accessDiskWithCheckCanceled(Function<? super P, ? extends R> function) {
        Function<Object, Object> function2 = new DiskQueryRelay<P, R>(function)::accessDiskWithCheckCanceled;
        if (function2 == null) {
            PersistentFS.$$$reportNull$$$0(0);
        }
        return function2;
    }

    @Deprecated(forRemoval=true)
    public abstract void clearIdCache();

    @ApiStatus.Internal
    public abstract String @NotNull [] listPersisted(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    public abstract @Unmodifiable @NotNull List<? extends ChildInfo> listAll(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    public abstract ChildInfo findChildInfo(@NotNull VirtualFile var1, @NotNull String var2, @NotNull NewVirtualFileSystem var3);

    @NotNull
    public abstract String getName(int var1);

    public abstract long getLastRecordedLength(@NotNull VirtualFile var1);

    public abstract boolean isHidden(@NotNull VirtualFile var1);

    public abstract @Attributes int getFileAttributes(int var1);

    public static boolean isDirectory(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)2);
    }

    public static boolean isWritable(@Attributes int attributes) {
        return !BitUtil.isSet((int)attributes, (int)4);
    }

    public static boolean isSymLink(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)16);
    }

    public static boolean isSpecialFile(@Attributes int attributes) {
        return !PersistentFS.isDirectory(attributes) && BitUtil.isSet((int)attributes, (int)32);
    }

    public static boolean isHidden(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)64);
    }

    public static boolean isOfflineByDefault(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)2048);
    }

    @NotNull
    public static FileAttributes.CaseSensitivity areChildrenCaseSensitive(@Attributes int attributes) {
        if (!PersistentFS.isDirectory(attributes)) {
            throw new IllegalArgumentException("CHILDREN_CASE_SENSITIVE flag defined for directories only but got file: 0b" + Integer.toBinaryString(attributes));
        }
        if (!BitUtil.isSet((int)attributes, (int)512)) {
            FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
            if (caseSensitivity == null) {
                PersistentFS.$$$reportNull$$$0(1);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.fromBoolean((boolean)BitUtil.isSet((int)attributes, (int)256));
        if (caseSensitivity == null) {
            PersistentFS.$$$reportNull$$$0(2);
        }
        return caseSensitivity;
    }

    public abstract int storeUnlinkedContent(byte @NotNull [] var1);

    public abstract byte @NotNull [] contentsToByteArray(int var1) throws IOException;

    public abstract byte @NotNull [] contentsToByteArray(@NotNull VirtualFile var1, boolean var2) throws IOException;

    public abstract int acquireContent(@NotNull VirtualFile var1);

    public abstract void releaseContent(int var1);

    public abstract int getCurrentContentId(@NotNull VirtualFile var1);

    public abstract boolean mayHaveChildren(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "accessDiskWithCheckCanceled";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "areChildrenCaseSensitive";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    @ApiStatus.Internal
    public static interface Flags {
        public static final int CHILDREN_CACHED = 1;
        public static final int IS_DIRECTORY = 2;
        public static final int IS_READ_ONLY = 4;
        public static final int MUST_RELOAD_CONTENT = 8;
        public static final int IS_SYMLINK = 16;
        public static final int IS_SPECIAL = 32;
        public static final int IS_HIDDEN = 64;
        public static final int MUST_RELOAD_LENGTH = 128;
        public static final int CHILDREN_CASE_SENSITIVE = 256;
        public static final int CHILDREN_CASE_SENSITIVITY_CACHED = 512;
        public static final int FREE_RECORD_FLAG = 1024;
        public static final int OFFLINE_BY_DEFAULT = 2048;

        public static int getAllValidFlags() {
            return 4095;
        }
    }

    @Target(value={ElementType.TYPE_USE})
    public static @interface Attributes {
    }
}

