/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.AttributesStorageOverBlobStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PersistentFSAttributeAccessor {
    @NotNull
    private final PersistentFSConnection connection;
    @NotNull
    private final VFSAttributesStorage attributesStorage;

    PersistentFSAttributeAccessor(@NotNull PersistentFSConnection connection) {
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(0);
        }
        this.connection = connection;
        this.attributesStorage = connection.attributes();
    }

    public boolean hasAttributePage(int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(1);
        }
        this.connection.ensureFileIdIsValid(fileId);
        return this.attributesStorage.hasAttributePage(this.connection, fileId, attribute);
    }

    @Nullable
    public AttributeInputStream readAttribute(int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(2);
        }
        AttributeInputStream attributeStream = this.attributesStorage.readAttribute(this.connection, fileId, attribute);
        return PersistentFSAttributeAccessor.validateAttributeVersion(attribute, attributeStream);
    }

    @ApiStatus.Internal
    @Nullable
    public static AttributeInputStream validateAttributeVersion(@NotNull FileAttribute attribute, AttributeInputStream attributeStream) {
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(3);
        }
        if (attributeStream != null && attribute.isVersioned()) {
            try {
                int actualVersion = DataInputOutputUtil.readINT((DataInput)attributeStream);
                if (actualVersion != attribute.getVersion()) {
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return attributeStream;
    }

    boolean supportsRawAccess() {
        return this.attributesStorage instanceof AttributesStorageOverBlobStorage;
    }

    @Nullable
    public <R> R readAttributeRaw(int fileId, @NotNull FileAttribute attribute, ByteBufferReader<R> reader) throws IOException {
        VFSAttributesStorage vFSAttributesStorage;
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(4);
        }
        if (!((vFSAttributesStorage = this.attributesStorage) instanceof AttributesStorageOverBlobStorage)) {
            throw new UnsupportedOperationException("Raw attribute access is not implemented for " + this.attributesStorage.getClass().getName());
        }
        AttributesStorageOverBlobStorage newAttributesStorage = (AttributesStorageOverBlobStorage)vFSAttributesStorage;
        this.connection.ensureFileIdIsValid(fileId);
        return newAttributesStorage.readAttributeRaw(this.connection, fileId, attribute, buffer2 -> {
            int actualVersion;
            if (attribute.isVersioned() && (actualVersion = DataInputOutputUtil.readINT((ByteBuffer)buffer2)) != attribute.getVersion()) {
                return null;
            }
            return reader.read(buffer2);
        });
    }

    public void writeAttributeRaw(int fileId, @NotNull FileAttribute attribute, @NotNull ByteBufferWriter writer) {
        VFSAttributesStorage vFSAttributesStorage;
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(5);
        }
        if (writer == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(6);
        }
        if (!((vFSAttributesStorage = this.attributesStorage) instanceof AttributesStorageOverBlobStorage)) {
            throw new UnsupportedOperationException("Raw attribute access is not implemented for " + this.attributesStorage.getClass().getName());
        }
        AttributesStorageOverBlobStorage newAttributesStorage = (AttributesStorageOverBlobStorage)vFSAttributesStorage;
        this.connection.ensureFileIdIsValid(fileId);
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @NotNull
    public AttributeOutputStream writeAttribute(int fileId, @NotNull FileAttribute attribute) {
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(7);
        }
        this.connection.ensureFileIdIsValid(fileId);
        AttributeOutputStream attributeStream = this.attributesStorage.writeAttribute(this.connection, fileId, attribute);
        if (attribute.isVersioned()) {
            try {
                DataInputOutputUtil.writeINT((DataOutput)attributeStream, (int)attribute.getVersion());
            }
            catch (IOException e) {
                throw new AssertionError("Write to byte[]-backed stream should not throw IOException -- a bug?", e);
            }
        }
        AttributeOutputStream attributeOutputStream = attributeStream;
        if (attributeOutputStream == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(8);
        }
        return attributeOutputStream;
    }

    public void deleteAttributes(int fileId) throws IOException {
        this.connection.ensureFileIdIsValid(fileId);
        this.attributesStorage.deleteAttributes(this.connection, fileId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSAttributeAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSAttributeAccessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributePage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateAttributeVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeRaw";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeRaw";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

