/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.newvfs.persistent.AttributesStorageOverBlobStorage;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorageFactory;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAsyncTaskExecutor;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.content.CompressingAlgo;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.content.ContentHashEnumeratorOverDurableEnumerator;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.content.ContentStorageAdapter;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.content.VFSContentStorageOverMMappedFile;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoveryInfo;
import com.intellij.platform.util.io.storages.blobstorage.StreamlinedBlobStorageOverMMappedFile;
import com.intellij.platform.util.io.storages.enumerator.DurableStringEnumerator;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorageFactory;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PageCacheUtils;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.blobstorage.SpaceAllocationStrategy;
import com.intellij.util.io.blobstorage.StreamlinedBlobStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RefCountingContentStorage;
import com.intellij.util.io.storage.RefCountingContentStorageImpl;
import com.intellij.util.io.storage.VFSContentStorage;
import com.intellij.util.io.storage.lf.RefCountingContentStorageImplLF;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PersistentFSLoader {
    private static final Logger LOG = Logger.getInstance(PersistentFSLoader.class);
    private static final StorageLockContext PERSISTENT_FS_STORAGE_CONTEXT = new StorageLockContext(false, true);
    @NotNull
    private static final Function<List<? extends Throwable>, IOException> ASYNC_EXCEPTIONS_REPORTER = exceptions -> {
        List unwrappedExceptions = ContainerUtil.map((Collection)exceptions, ex -> ex instanceof CompletionException ? ex.getCause() : ex);
        IOException mainIoException = (IOException)ContainerUtil.find((Iterable)unwrappedExceptions, e -> e instanceof IOException);
        if (mainIoException != null && !mainIoException.getMessage().isEmpty()) {
            for (Throwable exception : unwrappedExceptions) {
                if (exception == mainIoException) continue;
                mainIoException.addSuppressed(exception);
            }
        } else {
            String nonEmptyErrorMessage = unwrappedExceptions.stream().map(e -> ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"")).filter(message -> !message.isBlank()).findFirst().orElse("<Error message not found>");
            mainIoException = new IOException(nonEmptyErrorMessage);
            for (Throwable exception : unwrappedExceptions) {
                mainIoException.addSuppressed(exception);
            }
        }
        return mainIoException;
    };
    private final PersistentFSPaths vfsPaths;
    private final VFSAsyncTaskExecutor executorService;
    @NotNull
    public final Path namesFile;
    @NotNull
    public final Path attributesFile;
    @NotNull
    public final Path contentsFile;
    @NotNull
    public final Path contentsHashesFile;
    @NotNull
    public final Path recordsFile;
    @NotNull
    public final Path enumeratedAttributesFile;
    @NotNull
    public final Path corruptionMarkerFile;
    private PersistentFSRecordsStorage recordsStorage;
    private ScannableDataEnumeratorEx<String> namesStorage;
    private VFSAttributesStorage attributesStorage;
    private VFSContentStorage contentsStorage;
    private SimpleStringPersistentEnumerator attributesEnumerator;
    private CompletableFuture<IntList> collectDeletedFileRecordsTask;
    private NotNullLazyValue<IntList> reusableFileIdsLazy;
    private final List<VFSInitException> problemsDuringLoad;
    private final List<VFSInitException> problemsRecovered;
    private final IntSet directoriesIdsToRefresh;
    private final IntSet filesIdsToInvalidate;
    private boolean invalidateContentIds;

    PersistentFSLoader(@NotNull PersistentFSPaths persistentFSPaths, @NotNull VFSAsyncTaskExecutor pool) {
        if (persistentFSPaths == null) {
            PersistentFSLoader.$$$reportNull$$$0(0);
        }
        if (pool == null) {
            PersistentFSLoader.$$$reportNull$$$0(1);
        }
        this.recordsStorage = null;
        this.namesStorage = null;
        this.attributesStorage = null;
        this.contentsStorage = null;
        this.attributesEnumerator = null;
        this.reusableFileIdsLazy = null;
        this.problemsDuringLoad = new ArrayList<VFSInitException>();
        this.problemsRecovered = new ArrayList<VFSInitException>();
        this.directoriesIdsToRefresh = new IntOpenHashSet();
        this.filesIdsToInvalidate = new IntOpenHashSet();
        this.recordsFile = persistentFSPaths.storagePath("records");
        this.namesFile = persistentFSPaths.storagePath("names");
        this.attributesFile = persistentFSPaths.storagePath("attributes");
        this.contentsFile = persistentFSPaths.storagePath("content");
        this.contentsHashesFile = persistentFSPaths.storagePath("contentHashes");
        this.enumeratedAttributesFile = persistentFSPaths.storagePath("attributes_enums");
        this.corruptionMarkerFile = persistentFSPaths.getCorruptionMarkerFile();
        this.vfsPaths = persistentFSPaths;
        this.executorService = pool;
    }

    public void failIfCorruptionMarkerPresent() throws IOException {
        if (Files.exists(this.corruptionMarkerFile, new LinkOption[0])) {
            List<String> corruptionCause = Files.readAllLines(this.corruptionMarkerFile, StandardCharsets.UTF_8);
            throw new VFSInitException(VFSInitException.ErrorCategory.SCHEDULED_REBUILD, "Corruption marker file found\n\tcontent: " + String.valueOf(corruptionCause));
        }
    }

    public void initializeStorages() throws IOException {
        CompletableFuture<ScannableDataEnumeratorEx> namesStorageFuture = this.executorService.async(() -> this.createFileNamesEnumerator(this.namesFile));
        CompletableFuture<VFSAttributesStorage> attributesStorageFuture = this.executorService.async(() -> this.createAttributesStorage(this.attributesFile));
        CompletableFuture<VFSContentStorage> contentsStorageFuture = this.executorService.async(() -> this.createContentStorage(this.contentsHashesFile, this.contentsFile));
        CompletableFuture<PersistentFSRecordsStorage> recordsStorageFuture = this.executorService.async(() -> this.createRecordsStorage(this.recordsFile));
        this.collectDeletedFileRecordsTask = FSRecordsImpl.REUSE_DELETED_FILE_IDS ? this.executorService.async(() -> {
            IntArrayList reusableFileIds = new IntArrayList(1024);
            PersistentFSRecordsStorage storage = (PersistentFSRecordsStorage)recordsStorageFuture.join();
            storage.processAllRecords((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> PersistentFSLoader.lambda$initializeStorages$9((IntList)reusableFileIds, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
            LOG.info("VFS scanned: " + reusableFileIds.size() + " deleted files to reuse");
            return reusableFileIds;
        }) : CompletableFuture.completedFuture(new IntArrayList(0));
        this.reusableFileIdsLazy = NotNullLazyValue.lazy(() -> {
            try {
                return this.collectDeletedFileRecordsTask.join();
            }
            catch (Throwable e) {
                throw new IllegalStateException("Lazy reusableFileIds computation is failed", e);
            }
        });
        ExceptionUtil.runAllAndRethrowAllExceptions(ASYNC_EXCEPTIONS_REPORTER, (ThrowableRunnable[])new ThrowableRunnable[]{() -> {
            this.attributesEnumerator = new SimpleStringPersistentEnumerator(this.enumeratedAttributesFile);
        }, () -> {
            this.recordsStorage = (PersistentFSRecordsStorage)recordsStorageFuture.join();
        }, () -> {
            this.namesStorage = (ScannableDataEnumeratorEx)namesStorageFuture.join();
        }, () -> {
            this.attributesStorage = (VFSAttributesStorage)attributesStorageFuture.join();
        }, () -> {
            this.contentsStorage = (VFSContentStorage)contentsStorageFuture.join();
        }});
    }

    public void ensureStoragesVersionsAreConsistent(int currentImplVersion) throws IOException {
        LOG.info("VFS: impl (expected) version=" + currentImplVersion + ", " + this.recordsStorage.recordsCount() + " file records, " + this.contentsStorage.getRecordsCount() + " content blobs");
        if (currentImplVersion == 0) {
            throw new IllegalArgumentException("currentImplVersion(=" + currentImplVersion + ") must be != 0");
        }
        int commonVersion = PersistentFSLoader.commonVersionIfExists(this.recordsStorage, this.attributesStorage, this.contentsStorage);
        if (commonVersion != currentImplVersion) {
            boolean storagesAreEmpty;
            boolean bl = storagesAreEmpty = this.recordsStorage.recordsCount() == 0 && this.contentsStorage.isEmpty() && this.attributesStorage.isEmpty();
            if (commonVersion == 0 && storagesAreEmpty) {
                PersistentFSLoader.setCurrentVersion(this.recordsStorage, this.attributesStorage, this.contentsStorage, currentImplVersion);
                return;
            }
            VFSInitException.ErrorCategory rebuildCause = commonVersion > 0 ? VFSInitException.ErrorCategory.IMPL_VERSION_MISMATCH : VFSInitException.ErrorCategory.UNRECOGNIZED;
            throw new VFSInitException(rebuildCause, "VFS storages detected version(=" + commonVersion + ") != current impl version(=" + currentImplVersion + ") -> VFS needs rebuild");
        }
    }

    public void closeEverything() throws IOException {
        try {
            this.collectDeletedFileRecordsTask.join();
        }
        catch (Throwable t) {
            LOG.trace(t);
        }
        PersistentFSConnection.closeStorages(this.recordsStorage, this.namesStorage, this.attributesStorage, this.contentsStorage);
    }

    public void deleteEverything() throws IOException {
        boolean deleted = FileUtil.delete((File)this.corruptionMarkerFile.toFile());
        if (!deleted) {
            LOG.info("Can't delete " + String.valueOf(this.corruptionMarkerFile));
        }
        PersistentFSLoader.makeBestEffortToCleanStorage(this.namesStorage, this.namesFile);
        PersistentFSLoader.makeBestEffortToCleanStorage(this.attributesStorage, this.attributesFile);
        PersistentFSLoader.makeBestEffortToCleanStorage(this.attributesEnumerator, this.attributesFile);
        PersistentFSLoader.makeBestEffortToCleanStorage(this.contentsStorage, this.contentsFile);
        PersistentFSLoader.makeBestEffortToCleanStorage(this.recordsStorage, this.recordsFile);
        deleted = IOUtil.deleteAllFilesStartingWith((Path)this.vfsPaths.getRootsBaseFile());
        if (!deleted) {
            LOG.info("Can't delete " + String.valueOf(this.vfsPaths.getRootsBaseFile()));
        }
    }

    public PersistentFSConnection createConnection() throws IOException {
        return new PersistentFSConnection(this.vfsPaths, this.recordsStorage, this.namesStorage, this.attributesStorage, this.contentsStorage, this.attributesEnumerator, this.reusableFileIdsLazy, new VFSRecoveryInfo(this.problemsRecovered, this.invalidateContentIds, this.directoriesIdsToRefresh, this.filesIdsToInvalidate));
    }

    public void selfCheck() throws IOException {
        int fileId;
        int errorsAccumulated;
        if (!this.recordsStorage.wasClosedProperly()) {
            this.addProblem(VFSInitException.ErrorCategory.NOT_CLOSED_PROPERLY, "VFS wasn't safely shut down: records.wasClosedProperly is false");
        }
        if ((errorsAccumulated = this.recordsStorage.getErrorsAccumulated()) > 0) {
            this.addProblem(VFSInitException.ErrorCategory.HAS_ERRORS_IN_PREVIOUS_SESSION, "VFS accumulated " + errorsAccumulated + " errors in last session");
        }
        if (this.recordsStorage.getFlag(1)) {
            this.addProblem(VFSInitException.ErrorCategory.DEFRAGMENTATION_REQUESTED, "VFS defragmentation requested");
        }
        if (this.attributesEnumerator.isEmpty() && !this.attributesStorage.isEmpty()) {
            this.addProblem(VFSInitException.ErrorCategory.ATTRIBUTES_STORAGE_CORRUPTED, "Attributes enumerator is empty, while attributesStorage is !empty");
        }
        int maxAllocatedID = this.recordsStorage.maxAllocatedID();
        boolean nameStorageHasErrors = false;
        boolean contentHashesStorageHasErrors = false;
        boolean attributesStorageHasErrors = false;
        if (this.problemsDuringLoad.isEmpty()) {
            for (fileId = 2; fileId <= maxAllocatedID; fileId *= 2) {
                if (!nameStorageHasErrors && !this.nameResolvedSuccessfully(fileId)) {
                    nameStorageHasErrors = true;
                }
                if (!contentHashesStorageHasErrors && !this.contentResolvedSuccessfully(fileId)) {
                    contentHashesStorageHasErrors = true;
                }
                if (attributesStorageHasErrors || this.attributeRecordIsValid(fileId)) continue;
                attributesStorageHasErrors = true;
            }
        }
        if (!this.problemsDuringLoad.isEmpty()) {
            for (fileId = 2; fileId <= maxAllocatedID; ++fileId) {
                if (!nameStorageHasErrors && !this.nameResolvedSuccessfully(fileId)) {
                    nameStorageHasErrors = true;
                }
                if (!contentHashesStorageHasErrors && !this.contentResolvedSuccessfully(fileId)) {
                    contentHashesStorageHasErrors = true;
                }
                if (attributesStorageHasErrors || this.attributeRecordIsValid(fileId)) continue;
                attributesStorageHasErrors = true;
            }
        }
    }

    private boolean contentResolvedSuccessfully(int fileId) throws IOException {
        int contentId = this.recordsStorage.getContentRecordId(fileId);
        if (contentId != 0) {
            try {
                this.contentsStorage.checkRecord(contentId, true);
            }
            catch (Throwable t) {
                this.addProblem(VFSInitException.ErrorCategory.CONTENT_STORAGES_INCOMPLETE, "file[#" + fileId + "].contentId(=" + contentId + ") failed resolution in contentStorage", t);
                return false;
            }
        }
        return true;
    }

    private boolean nameResolvedSuccessfully(int fileId) throws IOException {
        int nameId = this.recordsStorage.getNameId(fileId);
        if (nameId == 0) {
            return false;
        }
        try {
            String name2 = (String)this.namesStorage.valueOf(nameId);
            if (name2 == null) {
                this.addProblem(VFSInitException.ErrorCategory.NAME_STORAGE_INCOMPLETE, "file[#" + fileId + "].nameId(=" + nameId + ") is not present in namesEnumerator");
                return false;
            }
        }
        catch (Throwable t) {
            this.addProblem(VFSInitException.ErrorCategory.NAME_STORAGE_INCOMPLETE, "file[#" + fileId + "].nameId(=" + nameId + ") failed resolution in namesEnumerator", t);
            return false;
        }
        return true;
    }

    private boolean attributeRecordIsValid(int fileId) throws IOException {
        int attributeRecordId = this.recordsStorage.getAttributeRecordId(fileId);
        if (attributeRecordId == 0) {
            return true;
        }
        try {
            this.attributesStorage.checkAttributeRecordSanity(fileId, attributeRecordId);
            return true;
        }
        catch (Throwable t) {
            this.addProblem(VFSInitException.ErrorCategory.ATTRIBUTES_STORAGE_CORRUPTED, "file[#" + fileId + "].attributeRefId(=" + attributeRecordId + "): attributesStorage read failed", t);
            return false;
        }
    }

    private void addProblem(@NotNull VFSInitException.ErrorCategory type, @NotNull String message) {
        if (type == null) {
            PersistentFSLoader.$$$reportNull$$$0(2);
        }
        if (message == null) {
            PersistentFSLoader.$$$reportNull$$$0(3);
        }
        this.addProblem(type, message, null);
    }

    private void addProblem(@NotNull VFSInitException.ErrorCategory type, @NotNull String message, @Nullable Throwable cause) {
        if (type == null) {
            PersistentFSLoader.$$$reportNull$$$0(4);
        }
        if (message == null) {
            PersistentFSLoader.$$$reportNull$$$0(5);
        }
        LOG.warn("[VFS load problem]: " + message, cause);
        if (cause == null) {
            this.problemsDuringLoad.add(new VFSInitException(type, message));
        } else {
            this.problemsDuringLoad.add(new VFSInitException(type, message, cause));
        }
    }

    public boolean isJustCreated() throws IOException {
        return this.recordsStorage.recordsCount() == 0 && this.attributesStorage.isEmpty() && this.contentsStorage.isEmpty();
    }

    @NotNull
    public VFSAttributesStorage createAttributesStorage(@NotNull Path attributesFile) throws IOException {
        if (attributesFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(6);
        }
        SpaceAllocationStrategy.DataLengthPlusFixedPercentStrategy allocationStrategy = new SpaceAllocationStrategy.DataLengthPlusFixedPercentStrategy(64, 128, 1048571, 30);
        LOG.info("VFS uses streamlined attributes storage (over mmapped file)");
        int pageSize = 0x1000000;
        StreamlinedBlobStorage blobStorage = (StreamlinedBlobStorage)MMappedFileStorageFactory.withDefaults().pageSize(pageSize).ifFileIsNotPageAligned(MMappedFileStorageFactory.IfNotPageAligned.EXPAND_FILE).wrapStorageSafely(attributesFile, arg_0 -> PersistentFSLoader.lambda$createAttributesStorage$17((SpaceAllocationStrategy)allocationStrategy, arg_0));
        return new AttributesStorageOverBlobStorage(blobStorage);
    }

    @NotNull
    private ScannableDataEnumeratorEx<String> createFileNamesEnumerator(@NotNull Path namesFile) throws IOException {
        if (namesFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(7);
        }
        LOG.info("VFS uses names enumerator over mmapped file");
        Path namesPathEx = Path.of(String.valueOf(namesFile) + ".mmap", new String[0]);
        DurableStringEnumerator durableStringEnumerator = DurableStringEnumerator.openAsync((Path)namesPathEx, this.executorService::async);
        if (durableStringEnumerator == null) {
            PersistentFSLoader.$$$reportNull$$$0(8);
        }
        return durableStringEnumerator;
    }

    @NotNull
    public VFSContentStorage createContentStorage(@NotNull Path contentsHashesFile, @NotNull Path contentsFile) throws IOException {
        RefCountingContentStorageImpl contentStorage;
        if (contentsHashesFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(9);
        }
        if (contentsFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(10);
        }
        if (FSRecordsImpl.USE_CONTENT_STORAGE_OVER_MMAPPED_FILE) {
            int pageSize = 0x4000000;
            if (pageSize <= PersistentFSConstants.MAX_FILE_LENGTH_TO_CACHE) {
                LOG.warn("ContentStorage.pageSize(=" + pageSize + ") must be > PersistentFSConstants.MAX_FILE_LENGTH_TO_CACHE(=" + PersistentFSConstants.MAX_FILE_LENGTH_TO_CACHE + "b), otherwise large content can't fit");
            }
            CompressingAlgo compressionAlgo = switch (FSRecordsImpl.COMPRESSION_ALGO) {
                case "zip" -> new CompressingAlgo.ZipAlgo(FSRecordsImpl.COMPRESS_CONTENT_IF_LARGER_THAN);
                case "lz4" -> new CompressingAlgo.Lz4Algo(FSRecordsImpl.COMPRESS_CONTENT_IF_LARGER_THAN);
                default -> new CompressingAlgo.NoCompressionAlgo();
            };
            LOG.info("VFS uses content storage over memory-mapped file, with compression algo: " + String.valueOf(compressionAlgo));
            return new VFSContentStorageOverMMappedFile(contentsFile, pageSize, compressionAlgo);
        }
        ExecutorService storingPool = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FSRecords Content Write Pool");
        boolean useContentHashes = true;
        if (FSRecordsImpl.USE_CONTENT_STORAGE_OVER_NEW_FILE_PAGE_CACHE && PageCacheUtils.LOCK_FREE_PAGE_CACHE_ENABLED) {
            LOG.info("VFS uses content storage over new FilePageCache");
            contentStorage = new RefCountingContentStorageImplLF(contentsFile, CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, storingPool, useContentHashes);
        } else {
            LOG.info("VFS uses content storage over regular FilePageCache");
            contentStorage = new RefCountingContentStorageImpl(contentsFile, CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, storingPool, useContentHashes);
        }
        return new ContentStorageAdapter((RefCountingContentStorage)contentStorage, (ThrowableComputable<ContentHashEnumerator, IOException>)((ThrowableComputable)() -> PersistentFSLoader.openContentHashEnumeratorOrCreateEmpty(contentsHashesFile)));
    }

    @NotNull
    private static ContentHashEnumerator openContentHashEnumeratorOrCreateEmpty(@NotNull Path contentsHashesFile) throws IOException {
        if (contentsHashesFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(11);
        }
        try {
            return PersistentFSLoader.openContentHashEnumerator(contentsHashesFile);
        }
        catch (IOException e) {
            LOG.warn("ContentHashEnumerator is broken -- clean it, hope it will be recovered from ContentStorage later on. Cause: " + e.getMessage());
            IOUtil.deleteAllFilesStartingWith((Path)contentsHashesFile);
            return PersistentFSLoader.openContentHashEnumerator(contentsHashesFile);
        }
    }

    @NotNull
    private static ContentHashEnumerator openContentHashEnumerator(@NotNull Path contentsHashesFile) throws IOException {
        if (contentsHashesFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(12);
        }
        if (FSRecordsImpl.USE_CONTENT_HASH_STORAGE_OVER_MMAPPED_FILE) {
            LOG.info("VFS uses content hash storage over mmapped file");
            ContentHashEnumeratorOverDurableEnumerator contentHashEnumeratorOverDurableEnumerator = ContentHashEnumeratorOverDurableEnumerator.open(contentsHashesFile);
            if (contentHashEnumeratorOverDurableEnumerator == null) {
                PersistentFSLoader.$$$reportNull$$$0(13);
            }
            return contentHashEnumeratorOverDurableEnumerator;
        }
        LOG.info("VFS uses content hash storage over regular FilePageCache");
        ContentHashEnumerator contentHashEnumerator = ContentHashEnumerator.open((Path)contentsHashesFile, (StorageLockContext)PERSISTENT_FS_STORAGE_CONTEXT);
        if (contentHashEnumerator == null) {
            PersistentFSLoader.$$$reportNull$$$0(14);
        }
        return contentHashEnumerator;
    }

    @NotNull
    public PersistentFSRecordsStorage createRecordsStorage(@NotNull Path recordsFile) throws IOException {
        if (recordsFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(15);
        }
        PersistentFSRecordsStorageFactory recordsStorageFactory = PersistentFSRecordsStorageFactory.storageImplementation();
        LOG.info("VFS uses " + String.valueOf(recordsStorageFactory) + " storage for main file records table");
        PersistentFSRecordsStorage persistentFSRecordsStorage = (PersistentFSRecordsStorage)recordsStorageFactory.wrapStorageSafely(recordsFile, records -> records);
        if (persistentFSRecordsStorage == null) {
            PersistentFSLoader.$$$reportNull$$$0(16);
        }
        return persistentFSRecordsStorage;
    }

    private static int commonVersionIfExists(@NotNull PersistentFSRecordsStorage records, @NotNull VFSAttributesStorage attributes, @NotNull VFSContentStorage contents) throws IOException {
        if (records == null) {
            PersistentFSLoader.$$$reportNull$$$0(17);
        }
        if (attributes == null) {
            PersistentFSLoader.$$$reportNull$$$0(18);
        }
        if (contents == null) {
            PersistentFSLoader.$$$reportNull$$$0(19);
        }
        int recordsVersion = records.getVersion();
        int attributesVersion = attributes.getVersion();
        int contentsVersion = contents.getVersion();
        if (attributesVersion != recordsVersion) {
            LOG.info("VFS storages are of different versions: records(=" + recordsVersion + "), attributes(=" + attributesVersion + "), content(=" + contentsVersion + ")");
            return -1;
        }
        return recordsVersion;
    }

    private static void setCurrentVersion(@NotNull PersistentFSRecordsStorage records, @NotNull VFSAttributesStorage attributes, @NotNull VFSContentStorage contents, int version) throws IOException {
        if (records == null) {
            PersistentFSLoader.$$$reportNull$$$0(20);
        }
        if (attributes == null) {
            PersistentFSLoader.$$$reportNull$$$0(21);
        }
        if (contents == null) {
            PersistentFSLoader.$$$reportNull$$$0(22);
        }
        records.setVersion(version);
        attributes.setVersion(version);
        contents.setVersion(version);
    }

    private static void makeBestEffortToCleanStorage(@Nullable Object storage, @NotNull Path storageFile) {
        if (storageFile == null) {
            PersistentFSLoader.$$$reportNull$$$0(23);
        }
        if (storage instanceof CleanableStorage) {
            try {
                ((CleanableStorage)storage).closeAndClean();
            }
            catch (Throwable t) {
                LOG.info(storage.getClass().getSimpleName() + ".closeAndClean() fails: " + t.getClass().getSimpleName() + "(" + ExceptionUtil.getNonEmptyMessage((Throwable)t, (String)"<no error message given>") + ")");
            }
        } else {
            LOG.info("[" + String.valueOf(storageFile.getFileName()) + "]: " + String.valueOf(storage) + " is not CleanableStorage -> trying to clean by explicitly removing all the files [" + String.valueOf(storageFile.getFileName()) + "*]");
        }
        boolean noSuchFilesRemains = IOUtil.deleteAllFilesStartingWith((Path)storageFile);
        if (!noSuchFilesRemains) {
            LOG.info("Can't delete " + String.valueOf(storageFile) + "*");
        }
    }

    public PersistentFSRecordsStorage recordsStorage() {
        return this.recordsStorage;
    }

    public ScannableDataEnumeratorEx<String> namesStorage() {
        return this.namesStorage;
    }

    public VFSAttributesStorage attributesStorage() {
        return this.attributesStorage;
    }

    public VFSContentStorage contentsStorage() {
        return this.contentsStorage;
    }

    public SimpleStringPersistentEnumerator attributesEnumerator() {
        return this.attributesEnumerator;
    }

    NotNullLazyValue<IntList> reusableFileIdsLazy() {
        return this.reusableFileIdsLazy;
    }

    public void setNamesStorage(ScannableDataEnumeratorEx<String> namesStorage) {
        this.namesStorage = namesStorage;
    }

    public void setAttributesStorage(VFSAttributesStorage attributesStorage) {
        this.attributesStorage = attributesStorage;
    }

    public void setContentsStorage(VFSContentStorage contentsStorage) {
        this.contentsStorage = contentsStorage;
    }

    public void setAttributesEnumerator(SimpleStringPersistentEnumerator attributesEnumerator) {
        this.attributesEnumerator = attributesEnumerator;
    }

    public List<VFSInitException> problemsDuringLoad() {
        return Collections.unmodifiableList(this.problemsDuringLoad);
    }

    public List<VFSInitException> problemsDuringLoad(@NotNull VFSInitException.ErrorCategory firstCategory, VFSInitException.ErrorCategory ... restCategories) {
        if (firstCategory == null) {
            PersistentFSLoader.$$$reportNull$$$0(24);
        }
        if (restCategories == null) {
            PersistentFSLoader.$$$reportNull$$$0(25);
        }
        EnumSet<VFSInitException.ErrorCategory[]> categories = EnumSet.of(firstCategory, restCategories);
        return this.problemsDuringLoad.stream().filter(p -> categories.contains((Object)p.category())).toList();
    }

    public void problemsWereRecovered(@NotNull List<VFSInitException> recovered) {
        if (recovered == null) {
            PersistentFSLoader.$$$reportNull$$$0(26);
        }
        this.problemsDuringLoad.removeAll(recovered);
        this.problemsRecovered.addAll(recovered);
        String recoveredProblemsList = recovered.stream().map(VFSInitException::category).map(Object::toString).collect(Collectors.joining());
        String remainingProblemsList = this.problemsDuringLoad.isEmpty() ? "no problems" : this.problemsDuringLoad.stream().map(VFSInitException::category).map(Object::toString).collect(Collectors.joining());
        LOG.warn("[VFS load problem]: " + recoveredProblemsList + " recovered, " + remainingProblemsList + " remain");
    }

    public void problemsRecoveryFailed(@NotNull List<VFSInitException> triedToRecover, @NotNull VFSInitException.ErrorCategory category, @NotNull String message) {
        if (triedToRecover == null) {
            PersistentFSLoader.$$$reportNull$$$0(27);
        }
        if (category == null) {
            PersistentFSLoader.$$$reportNull$$$0(28);
        }
        if (message == null) {
            PersistentFSLoader.$$$reportNull$$$0(29);
        }
        this.problemsRecoveryFailed(triedToRecover, category, message, null);
    }

    public void problemsRecoveryFailed(@NotNull List<VFSInitException> triedToRecover, @NotNull VFSInitException.ErrorCategory category, @NotNull String message, @Nullable Throwable cause) {
        if (triedToRecover == null) {
            PersistentFSLoader.$$$reportNull$$$0(30);
        }
        if (category == null) {
            PersistentFSLoader.$$$reportNull$$$0(31);
        }
        if (message == null) {
            PersistentFSLoader.$$$reportNull$$$0(32);
        }
        this.problemsDuringLoad.removeAll(triedToRecover);
        VFSInitException recoveryFailed = cause == null ? new VFSInitException(category, message) : new VFSInitException(category, message, cause);
        for (VFSInitException attemptedToRecover : triedToRecover) {
            recoveryFailed.addSuppressed(attemptedToRecover);
        }
        this.problemsDuringLoad.add(recoveryFailed);
        LOG.warn("[VFS load problem]: " + triedToRecover.stream().map(VFSInitException::category).map(Object::toString).collect(Collectors.joining()) + " recovery attempt fails ('" + message + "')");
    }

    public void contentIdsInvalidated(boolean invalidated) {
        this.invalidateContentIds = invalidated;
    }

    public void postponeDirectoryRefresh(int directoryIdToRefresh) {
        this.directoriesIdsToRefresh.add(directoryIdToRefresh);
    }

    public void postponeFileInvalidation(int fileId) {
        this.filesIdsToInvalidate.add(fileId);
    }

    private static /* synthetic */ StreamlinedBlobStorageOverMMappedFile lambda$createAttributesStorage$17(SpaceAllocationStrategy allocationStrategy, MMappedFileStorage storage) throws IOException {
        return new StreamlinedBlobStorageOverMMappedFile(storage, allocationStrategy);
    }

    private static /* synthetic */ void lambda$initializeStorages$9(IntList reusableFileIds, int fileId, int nameId, int flags, int parentId, int attributeRecordId, int contentId, boolean corrupted) {
        if (PersistentFSRecordAccessor.hasDeletedFlag(flags)) {
            reusableFileIds.add(fileId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentFSPaths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesFile";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSLoader";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsHashesFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordsFile";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstCategory";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restCategories";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recovered";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "triedToRecover";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSLoader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileNamesEnumerator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "openContentHashEnumerator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecordsStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addProblem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAttributesStorage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileNamesEnumerator";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createContentStorage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openContentHashEnumeratorOrCreateEmpty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "openContentHashEnumerator";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRecordsStorage";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "commonVersionIfExists";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentVersion";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "makeBestEffortToCleanStorage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "problemsDuringLoad";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "problemsWereRecovered";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "problemsRecoveryFailed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

