/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.vfs.newvfs.persistent.ExecuteOnCallingThread;
import com.intellij.openapi.vfs.newvfs.persistent.ExecuteOnCoroutine;
import com.intellij.openapi.vfs.newvfs.persistent.ExecuteOnThreadPool;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAsyncTaskExecutor;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFsConnectorHelper;", "", "<init>", "()V", "PARALLELIZE_VFS_INITIALIZATION", "", "USE_COROUTINES_DISPATCHER", "executor", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSAsyncTaskExecutor;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPersistentFsConnectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentFsConnectorHelper.kt\ncom/intellij/openapi/vfs/newvfs/persistent/PersistentFsConnectorHelper\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,86:1\n30#2,2:87\n*S KotlinDebug\n*F\n+ 1 PersistentFsConnectorHelper.kt\ncom/intellij/openapi/vfs/newvfs/persistent/PersistentFsConnectorHelper\n*L\n79#1:87,2\n*E\n"})
public final class PersistentFsConnectorHelper {
    @NotNull
    public static final PersistentFsConnectorHelper INSTANCE = new PersistentFsConnectorHelper();
    private static final boolean PARALLELIZE_VFS_INITIALIZATION = Boolean.parseBoolean(System.getProperty("vfs.parallelize-initialization", "true"));
    private static final boolean USE_COROUTINES_DISPATCHER = Boolean.parseBoolean(System.getProperty("vfs.use-coroutines-dispatcher", "true"));

    private PersistentFsConnectorHelper() {
    }

    @NotNull
    public final VFSAsyncTaskExecutor executor() {
        if (!PARALLELIZE_VFS_INITIALIZATION) {
            return ExecuteOnCallingThread.INSTANCE;
        }
        if (USE_COROUTINES_DISPATCHER) {
            Application app = ApplicationManager.getApplication();
            if (app == null) {
                return new ExecuteOnCoroutine((CoroutineScope)GlobalScope.INSTANCE);
            }
            ComponentManager $this$service$iv = (ComponentManager)app;
            boolean $i$f$service = false;
            Class<ExecuteOnCoroutine> serviceClass$iv = ExecuteOnCoroutine.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VFSAsyncTaskExecutor)object;
        }
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        return new ExecuteOnThreadPool(executorService);
    }
}

