/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.dev;

import com.intellij.openapi.vfs.newvfs.persistent.InvertedNameIndex;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class InvertedNameIndexOverIntToIntMultimap
implements InvertedNameIndex {
    private final DurableIntToMultiIntMap nameIdToFileId;
    private final ReadWriteLock rwLock;

    public InvertedNameIndexOverIntToIntMultimap(@NotNull DurableIntToMultiIntMap map2) {
        if (map2 == null) {
            InvertedNameIndexOverIntToIntMultimap.$$$reportNull$$$0(0);
        }
        this.rwLock = new ReentrantReadWriteLock();
        this.nameIdToFileId = map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean forEachFileIds(@NotNull IntCollection nameIds, @NotNull IntPredicate fileIdProcessor) {
        if (nameIds == null) {
            InvertedNameIndexOverIntToIntMultimap.$$$reportNull$$$0(1);
        }
        if (fileIdProcessor == null) {
            InvertedNameIndexOverIntToIntMultimap.$$$reportNull$$$0(2);
        }
        Lock readLock = this.rwLock.readLock();
        try {
            IntIterator it = nameIds.intIterator();
            while (it.hasNext()) {
                int nameId = it.nextInt();
                readLock.lock();
                try {
                    int acceptedFileId = this.nameIdToFileId.lookup(nameId, fileId -> !fileIdProcessor.test(fileId));
                    if (acceptedFileId == 0) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    readLock.unlock();
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException("nameIds: " + String.valueOf(nameIds), e);
        }
    }

    @Override
    public void updateFileName(int fileId, int oldNameId, int newNameId) {
        if (oldNameId == newNameId) {
            return;
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            if (oldNameId != 0) {
                this.nameIdToFileId.remove(oldNameId, fileId);
            }
            if (newNameId != 0) {
                this.nameIdToFileId.put(newNameId, fileId);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(".updateFileName(" + fileId + ", " + newNameId + "," + oldNameId + ")", e);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.nameIdToFileId.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void checkConsistency() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIdProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/dev/InvertedNameIndexOverIntToIntMultimap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachFileIds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

