/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.recovery;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSLoader;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoverer;
import com.intellij.util.io.storage.VFSContentStorage;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ContentStoragesRecoverer
implements VFSRecoverer {
    private static final Logger LOG = Logger.getInstance(ContentStoragesRecoverer.class);

    @Override
    public void tryRecover(@NotNull PersistentFSLoader loader) {
        List<VFSInitException> contentStoragesProblems;
        if (loader == null) {
            ContentStoragesRecoverer.$$$reportNull$$$0(0);
        }
        if ((contentStoragesProblems = loader.problemsDuringLoad(VFSInitException.ErrorCategory.CONTENT_STORAGES_NOT_MATCH, VFSInitException.ErrorCategory.CONTENT_STORAGES_INCOMPLETE)).isEmpty()) {
            return;
        }
        try {
            LOG.info(contentStoragesProblems.size() + " ContentStorage-related issue(s) -> trying to fix");
            PersistentFSRecordsStorage records = loader.recordsStorage();
            try {
                ContentStoragesRecoverer.checkContentStorage(loader);
                loader.problemsWereRecovered(contentStoragesProblems);
                LOG.warn("ContentStorage was verified, no problems found -> seems like false alarm?");
            }
            catch (Throwable ex) {
                LOG.warn("ContentStorage verification is failed: " + ex.getMessage());
                VFSContentStorage contentStorage = loader.contentsStorage();
                contentStorage.closeAndClean();
                VFSContentStorage emptyContentStorage = loader.createContentStorage(loader.contentsHashesFile, loader.contentsFile);
                loader.setContentsStorage(emptyContentStorage);
                ContentStoragesRecoverer.cleanAllContentIds(records);
                loader.contentIdsInvalidated(true);
                loader.problemsWereRecovered(contentStoragesProblems);
                LOG.warn("ContentStorage is found broken -> fixed by invalidating all the content refs (LocalHistory is lost)");
            }
        }
        catch (Throwable t) {
            loader.problemsRecoveryFailed(contentStoragesProblems, VFSInitException.ErrorCategory.CONTENT_STORAGES_INCOMPLETE, "Content storage recovery fails", t);
        }
    }

    private static void checkContentStorage(@NotNull PersistentFSLoader loader) throws IOException {
        if (loader == null) {
            ContentStoragesRecoverer.$$$reportNull$$$0(1);
        }
        PersistentFSRecordsStorage records = loader.recordsStorage();
        VFSContentStorage contentStorage = loader.contentsStorage();
        int maxAllocatedID = records.maxAllocatedID();
        for (int fileId = 1; fileId <= maxAllocatedID; ++fileId) {
            int contentId = records.getContentRecordId(fileId);
            if (contentId == 0) continue;
            try {
                contentStorage.checkRecord(contentId, false);
                continue;
            }
            catch (Throwable t) {
                throw new IOException("file[#" + fileId + "].content[contentId: " + contentId + "] is broken, " + String.valueOf(t), t);
            }
        }
    }

    private static void cleanAllContentIds(@NotNull PersistentFSRecordsStorage records) throws IOException {
        if (records == null) {
            ContentStoragesRecoverer.$$$reportNull$$$0(2);
        }
        int maxAllocatedID = records.maxAllocatedID();
        for (int fileId = 1; fileId <= maxAllocatedID; ++fileId) {
            if (records.getContentRecordId(fileId) == 0) continue;
            records.setContentRecordId(fileId, 0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/recovery/ContentStoragesRecoverer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryRecover";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContentStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanAllContentIds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

