/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.wm.impl.SquareStripeButtonLook;
import com.intellij.toolWindow.ResizeStripeManager;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b \u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0004J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/wm/impl/AbstractSquareStripeButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "minimumSize", "Ljava/util/function/Supplier;", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/util/function/Supplier;)V", "doInit", "", "popupBuilder", "Lkotlin/Function0;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "paintDraggingButton", "g", "Ljava/awt/Graphics;", "isLeft", "", "intellij.platform.ide.impl"})
public abstract class AbstractSquareStripeButton
extends ActionButton {
    public AbstractSquareStripeButton(@NotNull AnAction action2, @NotNull Presentation presentation2, @Nullable Supplier<Dimension> minimumSize) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Supplier<Dimension> supplier = minimumSize;
        if (supplier == null) {
            supplier = AbstractSquareStripeButton::_init_$lambda$0;
        }
        super(action2, presentation2, "ToolwindowToolbar", supplier);
    }

    public /* synthetic */ AbstractSquareStripeButton(AnAction anAction, Presentation presentation2, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            supplier = null;
        }
        this(anAction, presentation2, supplier);
    }

    protected final void doInit(@NotNull Function0<? extends ActionGroup> popupBuilder) {
        Intrinsics.checkNotNullParameter(popupBuilder, (String)"popupBuilder");
        this.setLook(new SquareStripeButtonLook(this));
        this.addMouseListener((MouseListener)new PopupHandler(popupBuilder){
            final /* synthetic */ Function0<ActionGroup> $popupBuilder;
            {
                this.$popupBuilder = $popupBuilder;
            }

            public void invokePopup(Component component2, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                ResizeStripeManager.Companion.showPopup((ActionGroup)this.$popupBuilder.invoke(), component2, x, y);
            }
        });
    }

    public final void paintDraggingButton(@NotNull Graphics g, boolean isLeft) {
        Dimension dimension;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Dimension it = dimension = this.getSize();
        boolean bl = false;
        JBInsets.removeFrom((Dimension)it, (Insets)this.getInsets());
        JBInsets.removeFrom((Dimension)it, (Insets)SquareStripeButtonLook.Companion.getIconPadding(isLeft));
        Dimension areaSize = dimension;
        Color color = JBUI.CurrentTheme.ToolWindow.DragAndDrop.BUTTON_FLOATING_BACKGROUND;
        Rectangle rect = new Rectangle(areaSize);
        this.getButtonLook().paintLookBackground(g, rect, color);
        Icon it2 = this.getIcon();
        boolean bl2 = false;
        int x = (areaSize.width - it2.getIconWidth()) / 2;
        int y = (areaSize.height - it2.getIconHeight()) / 2;
        this.getButtonLook().paintIcon(g, this, it2, x, y);
        this.getButtonLook().paintLookBorder(g, rect, color);
    }

    private static final Dimension _init_$lambda$0() {
        return JBUI.CurrentTheme.Toolbar.stripeToolbarButtonSize();
    }
}

